/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;

public abstract class Model
implements IModel {
    private Version version;
    private List<ModelImport<?>> imports;
    private String name;
    private long timestamp = System.currentTimeMillis();

    public Model(String name) {
        this(name, null);
    }

    public Model(String name, Version version) {
        this.name = name;
        this.version = version;
        this.imports = new ArrayList();
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean addImport(ModelImport<?> pimport) {
        boolean found = false;
        if (!pimport.isConflict()) {
            int i = 0;
            while (!found && i < this.imports.size()) {
                ModelImport<?> tmp = this.imports.get(i);
                found = tmp.getName().equals(pimport.getName());
                ++i;
            }
        }
        if (!found) {
            this.imports.add(pimport);
        }
        return !found;
    }

    @Override
    public int getImportsCount() {
        return this.imports.size();
    }

    @Override
    public ModelImport<?> getImport(int index) {
        return this.imports.get(index);
    }

    @Override
    public void dispose() {
    }

    @Override
    public long getLastModification() {
        return this.timestamp;
    }
}

