/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelData;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;

public class ModelInfo<M extends IModel>
implements IModelData {
    private String name;
    private Version version;
    private IModelLoader<M> loader;
    private URI location;
    private M resolved;
    private long timestamp;
    private List<ModelImport<M>> imports;
    private Locale locale;

    ModelInfo() {
        this(null, null, null, null, null);
    }

    public ModelInfo(M model, URI location) {
        this(model.getName(), model.getVersion(), null, location, null);
    }

    public ModelInfo(M model, URI location, IModelLoader<M> loader) {
        this(model.getName(), model.getVersion(), loader, location, null);
    }

    public ModelInfo(String name, Version version, IModelLoader<M> loader, URI location, List<ModelImport<M>> imp) {
        this.name = name;
        this.version = version;
        this.loader = loader;
        this.location = location != null ? location.normalize() : null;
        this.imports = new ArrayList<ModelImport<M>>();
        if (imp != null) {
            this.imports.addAll(imp);
        }
        this.adjustTimestamp();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public URI getLocation() {
        return this.location;
    }

    public IModelLoader<M> getLoader() {
        return this.loader;
    }

    public String nameVersionToString() {
        return "'" + this.name + "'" + Version.toString(this.version);
    }

    public String toString() {
        return this.name + " v" + String.valueOf(this.version) + " " + String.valueOf(this.location) + " " + String.valueOf(this.loader) + " " + this.isResolved() + " " + String.valueOf(this.locale);
    }

    void setResolved(M resolved) {
        this.resolved = resolved;
        this.adjustTimestamp();
    }

    private void adjustTimestamp() {
        this.timestamp = this.resolved == null ? -1L : System.currentTimeMillis();
    }

    public M getResolved() {
        return this.resolved;
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isOutdated() {
        boolean actual = false;
        if (this.location != null) {
            if ("file".equalsIgnoreCase(this.location.getScheme())) {
                try {
                    File file = new File(this.location);
                    actual = file.lastModified() > this.timestamp;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            actual = true;
        }
        return actual;
    }

    public int getImportsCount() {
        int result = this.resolved != null ? this.resolved.getImportsCount() : this.imports.size();
        return result;
    }

    public ModelImport<M> getImport(int index) {
        ModelImport<Object> result = this.resolved != null ? this.resolved.getImport(index) : this.imports.get(index);
        return result;
    }

    public boolean isContainedIn(URI uri) {
        return this.isContainedIn(ModelInfo.toComparablePath(uri));
    }

    public boolean isContainedIn(String path) {
        boolean result = false;
        if (path != null && this.location != null) {
            result = ModelInfo.toComparablePath(this.location).startsWith(path);
        }
        return result;
    }

    public static String toComparablePath(URI uri) {
        Object result;
        if (uri == null) {
            result = null;
        } else {
            result = uri.getPath();
            if (!((String)result).endsWith("/")) {
                result = (String)result + "/";
            }
        }
        return result;
    }

    public static <M extends IModel> List<ModelInfo<M>> selectOutdated(List<ModelInfo<M>> info, boolean requireResolved, URI uri) {
        ArrayList<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();
        int i = 0;
        while (i < info.size()) {
            ModelInfo<M> pi = info.get(i);
            if (pi.isOutdated() && (!requireResolved || requireResolved && pi.isResolved()) && (uri == null || pi.isContainedIn(uri))) {
                result.add(pi);
            }
            ++i;
        }
        return result;
    }

    public static <M extends IModel> List<ModelInfo<M>> selectContained(List<ModelInfo<M>> info, URI uri) {
        ArrayList<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();
        int i = 0;
        while (i < info.size()) {
            ModelInfo<M> pi = info.get(i);
            if (uri == null || pi.isContainedIn(uri)) {
                result.add(pi);
            }
            ++i;
        }
        return result;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public URI getCommentsResource() {
        return this.composeCommentsURI(this.getLocale(), false);
    }

    public URI getDefaultCommentsResource() {
        return this.composeCommentsURI(null, false);
    }

    public URI getBaseCommentsResource() {
        return this.composeCommentsURI(this.getLocale(), true);
    }

    public URI getDefaultBaseCommentsResource() {
        return this.composeCommentsURI(null, true);
    }

    private URI composeCommentsURI(Locale locale, boolean base) {
        URI result = null;
        if (this.location != null) {
            Object path = this.location.getPath();
            int pos = ((String)path).lastIndexOf(47);
            if (pos >= 0 && pos < ((String)path).length()) {
                String name = ((String)path).substring(++pos);
                path = ((String)path).substring(0, pos);
                path = base ? (String)path + this.composeLocaleCommentsName("easy-base", locale) : ((pos = name.lastIndexOf(46)) >= 0 && pos < ((String)path).length() ? (String)path + this.composeLocaleCommentsName(name.substring(0, pos), locale) : null);
            } else {
                path = null;
            }
            if (path != null) {
                try {
                    result = new URI(this.location.getScheme(), this.location.getUserInfo(), this.location.getHost(), this.location.getPort(), (String)path, this.location.getQuery(), this.location.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String composeLocaleCommentsName(String name, Locale locale) {
        if (locale != null) {
            name = (String)name + "_" + locale.getLanguage();
        }
        return (String)name + ".text";
    }

    void updateModelLoader(IModelLoader<M> loader) {
        if (this.loader == null) {
            this.loader = loader;
        }
    }

    public static <M extends IModel> boolean equals(ModelInfo<M> i1, ModelInfo<M> i2) {
        boolean equals = i1 == null ? i2 == null : (i2 != null ? ModelInfo.equals(i1, i2.getName(), i2.getVersion(), i2.getLocation()) : false);
        return equals;
    }

    public static <M extends IModel> boolean equals(ModelInfo<M> info, String name, Version version, URI location) {
        if (info == null) {
            return name == null && version == null && location == null;
        }
        boolean equals = location != null ? info.getName().equals(name) && Version.equals(info.getVersion(), version) && info.getLocation().normalize().equals(location.normalize()) : false;
        return equals;
    }
}

