/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

class ModelInfoHolder<M extends IModel>
implements IModelLoader.IModelInfoHolder<M> {
    private Map<URI, ModelInfo<M>> knownURI = new HashMap<URI, ModelInfo<M>>();
    private List<ModelInfo<M>> result = new ArrayList<ModelInfo<M>>();

    ModelInfoHolder(AvailableModels<M> availableModels) {
        for (List<VersionedModelInfos<M>> info : availableModels.versionedModelInfos()) {
            int i = 0;
            while (i < info.size()) {
                VersionedModelInfos<int> vInfo = info.get(i);
                int v = 0;
                while (v < vInfo.size()) {
                    ModelInfo<int> pInfo = vInfo.get(v);
                    this.knownURI.put(pInfo.getLocation(), pInfo);
                    ++v;
                }
                ++i;
            }
        }
    }

    @Override
    public void addResult(ModelInfo<M> toAdd) {
        this.result.add(toAdd);
    }

    @Override
    public boolean isKnown(URI uri, IModelLoader<M> loader) {
        ModelInfo<M> info = this.knownURI.get(uri);
        if (info != null) {
            info.updateModelLoader(loader);
        }
        return info != null;
    }

    public int getResultCount() {
        return this.result.size();
    }

    public ModelInfo<M> getResult(int index) {
        return this.result.get(index);
    }

    @Override
    public void error(String message) {
    }
}

