/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.ssehub.easy.basics.io.FileUtils;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.ModelInfoHolder;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ObservableTask;
import net.ssehub.easy.basics.progress.ProgressObserver;

public class ModelLocations<M extends IModel> {
    private Map<String, Location> knownLocations = new HashMap<String, Location>();
    private IModelManagementRepository<M> repository;
    private List<Location> locations = new ArrayList<Location>();
    private Set<File> excludedLocations = new HashSet<File>();

    ModelLocations(IModelManagementRepository<M> repository) {
        this.repository = repository;
    }

    void clear() {
        this.knownLocations.clear();
        this.locations.clear();
    }

    public synchronized void addExcludedLocation(File location) {
        if (!this.excludedLocations.contains(location)) {
            this.excludedLocations.add(location);
        }
    }

    public synchronized void removeExcludedLocation(File location) {
        this.excludedLocations.remove(location);
    }

    public Location getLocationFor(URI uri) {
        Location result;
        block6: {
            result = null;
            try {
                if (!FileUtils.isFileURI(uri)) break block6;
                File f = new File(uri).getCanonicalFile();
                while (result == null) {
                    int l = 0;
                    while (l < this.locations.size()) {
                        Location tmp = this.locations.get(l);
                        if (tmp.contains(f) && (result == null || tmp.contains(result.getLocation()))) {
                            result = tmp;
                        }
                        ++l;
                    }
                    if (result == null && f.getParentFile() != null) {
                        f = f.getParentFile();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private Location getLocationFor(File file) throws ModelManagementException {
        return this.getLocationFor(file, false);
    }

    private synchronized Location getLocationFor(File file, boolean create) throws ModelManagementException {
        try {
            File cFile = file.getCanonicalFile();
            String key = cFile.toString();
            Location location = this.knownLocations.get(key);
            if (location == null && create) {
                location = new Location(file);
                this.knownLocations.put(key, location);
            }
            return location;
        }
        catch (IOException e) {
            throw new ModelManagementException(e.getMessage(), 10599);
        }
    }

    public synchronized Location addLocation(File file, ProgressObserver observer) throws ModelManagementException {
        return this.addLocation(file, false, observer);
    }

    public synchronized Location addLocationToFront(File file, ProgressObserver observer) throws ModelManagementException {
        return this.addLocation(file, true, observer);
    }

    private Location addLocation(File file, boolean front, ProgressObserver observer) throws ModelManagementException {
        Location location = null;
        if (file != null) {
            location = this.getLocationFor(file, true);
            if (!this.locations.contains(location)) {
                if (front) {
                    this.locations.add(0, location);
                } else {
                    this.locations.add(location);
                }
            }
            this.repository.updateModelInformation(file, observer);
        }
        return location;
    }

    public synchronized void removeLocation(Location location, ProgressObserver observer) throws ModelManagementException {
        if (location != null) {
            this.repository.clearLocation(location.getLocation(), observer);
        }
    }

    public synchronized void removeLocation(File file, ProgressObserver observer) throws ModelManagementException {
        if (file != null) {
            Location location = this.getLocationFor(file, false);
            this.removeLocation(location, observer);
        }
    }

    public synchronized void updateLocation(File file, ProgressObserver observer) throws ModelManagementException {
        Location location;
        if (file != null && (location = this.getLocationFor(file, false)) != null && this.locations.contains(location)) {
            this.repository.updateModelInformation(file, observer);
        }
    }

    public synchronized boolean isLocationKnown(File file) {
        boolean found = false;
        int l = 0;
        while (l < this.locations.size()) {
            found = this.locations.get(l).getLocation().equals(file);
            ++l;
        }
        return found;
    }

    private static int count(File location, Set<File> excludedLocations) {
        int count = 0;
        if (!(location == null || excludedLocations != null && excludedLocations.contains(location))) {
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                if (files != null) {
                    int f = 0;
                    while (f < files.length) {
                        count += ModelLocations.count(files[f], excludedLocations);
                        ++f;
                    }
                }
            } else {
                count = 1;
            }
        }
        return count;
    }

    int countFilesInLocations() {
        int count = 0;
        HashSet<Location> done = new HashSet<Location>();
        int f = 0;
        while (f < this.locations.size()) {
            count += this.locations.get(f).countFilesInLocations(this.excludedLocations, done);
            ++f;
        }
        return count;
    }

    public synchronized int getLocationCount() {
        return this.locations.size();
    }

    public synchronized Location getLocation(int index) {
        return this.locations.get(index);
    }

    synchronized void scan(File location, ModelInfoHolder<M> holder, IModelLoader<M> loader, ObservableTask task, Set<File> done) {
        if (location != null && !this.excludedLocations.contains(location)) {
            if (location.isDirectory()) {
                if (!done.contains(location)) {
                    done.add(location);
                    File[] files = location.listFiles();
                    if (files != null) {
                        int f = 0;
                        while (f < files.length) {
                            this.scan(files[f], holder, loader, task, done);
                            ++f;
                        }
                    }
                }
            } else {
                if (loader != null) {
                    loader.scan(location, holder);
                } else {
                    this.repository.loaders().scanAll(location, holder);
                }
                task.notifyProgress();
            }
        }
    }

    synchronized void removeLocationFor(File file) throws ModelManagementException {
        Location location = this.getLocationFor(file);
        this.removeLocation(location);
    }

    synchronized void removeLocation(Location location) {
        if (location != null) {
            HashSet<Location> done = new HashSet<Location>();
            this.locations.remove(location);
            int l = 0;
            while (l < this.locations.size()) {
                this.locations.get(l).removeFromDependentLocations(location, done);
                done.clear();
                ++l;
            }
            String toRemove = null;
            boolean depsExist = false;
            for (Map.Entry<String, Location> entry : this.knownLocations.entrySet()) {
                Location loc = entry.getValue();
                if (loc == location) {
                    toRemove = entry.getKey();
                    continue;
                }
                depsExist = loc.isDependentLocation(location, done);
                done.clear();
            }
            if (!depsExist && toRemove != null) {
                this.knownLocations.remove(toRemove);
            }
        }
    }

    public void updateModelInformation() throws ModelManagementException {
        ModelManagementException ex = null;
        int l = 0;
        while (l < this.locations.size()) {
            block4: {
                try {
                    this.repository.updateModelInformation(this.locations.get(l).getLocation(), ProgressObserver.NO_OBSERVER);
                }
                catch (ModelManagementException e) {
                    if (ex != null) break block4;
                    ex = e;
                }
            }
            ++l;
        }
        if (ex != null) {
            throw ex;
        }
    }

    public List<Location> getDefaultLibraryLocations() {
        return this.locations.stream().filter(l -> l.isDefaultLibLocation()).collect(Collectors.toList());
    }

    public static class Location {
        private File location;
        private List<Location> dependent;
        private Location depending;
        private boolean defaultLibLocation;

        private Location(File location) {
            this.location = location;
        }

        public File getLocation() {
            return this.location;
        }

        public Location toDefaultLibLocation() {
            this.defaultLibLocation = true;
            return this;
        }

        public boolean isDefaultLibLocation() {
            return this.defaultLibLocation;
        }

        public int getDependentLocationCount() {
            return this.dependent == null ? 0 : this.dependent.size();
        }

        public Location getDependentLocation(int index) {
            return this.dependent.get(index);
        }

        public void addDependentLocation(Location location) {
            if (location != null && location != this) {
                if (this.dependent == null) {
                    this.dependent = new ArrayList<Location>();
                }
                if (!this.dependent.contains(location)) {
                    this.dependent.add(location);
                }
                location.depending = this;
            }
        }

        public Location getDepending() {
            return this.depending;
        }

        private int countFilesInLocations(Set<File> excludedLocations, Set<Location> done) {
            int count = 0;
            if (!done.contains(this)) {
                done.add(this);
                count = ModelLocations.count(this.location, excludedLocations);
                if (this.dependent != null) {
                    int d = 0;
                    while (d < this.dependent.size()) {
                        count += this.dependent.get(d).countFilesInLocations(excludedLocations, done);
                        ++d;
                    }
                }
            }
            return count;
        }

        private boolean contains(File file) {
            boolean result;
            try {
                String sFile = file.toString();
                result = this.location.length() > 0L && sFile.startsWith(this.location.toString()) || sFile.startsWith(this.location.getCanonicalPath().toString());
            }
            catch (IOException e) {
                result = false;
            }
            return result;
        }

        private void removeFromDependentLocations(Location location, Set<Location> processed) {
            if (!processed.contains(location)) {
                processed.add(location);
                if (this.dependent != null) {
                    this.dependent.remove(location);
                    int d = 0;
                    while (d < this.dependent.size()) {
                        this.dependent.get(d).removeFromDependentLocations(location, processed);
                        ++d;
                    }
                }
            }
        }

        private boolean isDependentLocation(Location location, Set<Location> processed) {
            boolean found = false;
            if (!processed.contains(location)) {
                processed.add(location);
                if (this.dependent != null) {
                    int d = 0;
                    while (!found && d < this.dependent.size()) {
                        Location dep = this.dependent.get(d);
                        found = location == dep || dep.isDependentLocation(location, processed);
                        ++d;
                    }
                }
            }
            return found;
        }

        public String toString() {
            return "Location: " + String.valueOf(this.location) + " " + String.valueOf(this.dependent);
        }
    }
}

