/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.IModelRepository;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLoaders;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;
import net.ssehub.easy.basics.progress.ProgressObserver;

public abstract class ModelRepository<M extends IModel>
implements IModelManagementRepository<M>,
IModelRepository<M> {
    private ModelManagement<M> modelMgmt;

    protected ModelRepository(ModelManagement<M> modelMgmt) {
        this.modelMgmt = modelMgmt;
    }

    @Override
    public List<VersionedModelInfos<M>> getAvailable(String name) {
        return this.modelMgmt.getAvailable(name);
    }

    @Override
    public boolean isOutdated(ModelInfo<M> info) {
        return this.modelMgmt.isOutdated(info);
    }

    @Override
    public M load(ModelInfo<M> info, List<IMessage> messages) {
        return this.modelMgmt.load(info, messages);
    }

    @Override
    public M load(ModelInfo<M> info, ImportResolver<M> resolver, List<IMessage> messages) {
        return this.modelMgmt.load(info, resolver, messages);
    }

    @Override
    public ModelInfo<M> getModelInfo(String name, Version version, URI uri) {
        return this.modelMgmt.availableModels().getModelInfo(name, version, uri);
    }

    @Override
    public List<String> getMatchingModelNames(String name) {
        return this.modelMgmt.getMatchingModelNames(name);
    }

    @Override
    public void updateModelInformation(File file, ProgressObserver observer) throws ModelManagementException {
        this.modelMgmt.updateModelInformation(file, observer);
    }

    @Override
    public synchronized void updateForLoader(IModelLoader<M> loader, ProgressObserver observer) throws ModelManagementException {
        this.modelMgmt.updateForLoader(loader, observer);
    }

    @Override
    public ModelLocations.Location getLocationFor(URI uri) {
        return this.modelMgmt.locations().getLocationFor(uri);
    }

    @Override
    public ModelLoaders<M> loaders() {
        return this.modelMgmt.loaders();
    }

    @Override
    public synchronized void clearLocation(File file, ProgressObserver observer) {
        this.modelMgmt.clearLocation(file, observer);
    }

    @Override
    public synchronized ModelInfo<M> getResolvedModelInfo(M model) {
        return this.modelMgmt.availableModels().getResolvedModelInfo(model);
    }

    @Override
    public List<ModelLocations.Location> getDefaultLibraryLocations() {
        return this.modelMgmt.locations().getDefaultLibraryLocations();
    }
}

