/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;

class ModelUpdateUtils {
    ModelUpdateUtils() {
    }

    static <M extends IModel> Map<M, M> addReplacing(M old, M model) {
        return ModelUpdateUtils.addReplacing(old, model, null);
    }

    static <M extends IModel> Map<M, M> addReplacing(M old, M model, Map<M, M> result) {
        if (result == null) {
            result = new HashMap<M, M>();
        }
        result.put(old, model);
        return result;
    }

    static <M extends IModel> Map<M, List<M>> collectImporting(List<M> models, Map<M, M> replacing) {
        HashMap result = new HashMap();
        int m = 0;
        while (m < models.size()) {
            IModel model = (IModel)models.get(m);
            if (model != null) {
                int i = 0;
                while (i < model.getImportsCount()) {
                    Object imported = model.getImport(i).getResolved();
                    if (imported != null) {
                        ArrayList<IModel> importing;
                        IModel tmp;
                        if (replacing != null && (tmp = (IModel)replacing.get(imported)) != null) {
                            imported = tmp;
                        }
                        if ((importing = (ArrayList<IModel>)result.get(imported)) == null) {
                            importing = new ArrayList<IModel>();
                            result.put(imported, importing);
                        }
                        importing.add(model);
                    }
                    ++i;
                }
            }
            ++m;
        }
        return result;
    }

    static <M extends IModel> List<M> determineUpdateSeqence(M model, Map<M, List<M>> using) {
        ArrayList<IModel> result = new ArrayList<IModel>();
        HashMap updateSequence = new HashMap();
        int max = ModelUpdateUtils.followImporting(model, using, updateSequence, 0, new HashSet());
        while (result.size() < max) {
            result.add(null);
        }
        for (Map.Entry entry : updateSequence.entrySet()) {
            result.set((Integer)entry.getValue(), (IModel)entry.getKey());
        }
        return result;
    }

    private static <M extends IModel> int followImporting(M model, Map<M, List<M>> using, Map<M, Integer> sequence, int start, Set<M> done) {
        if (!done.contains(model)) {
            done.add(model);
            List<M> importing = using.get(model);
            if (importing != null) {
                int i = 0;
                while (i < importing.size()) {
                    IModel tmp = (IModel)importing.get(i);
                    if (tmp != model) {
                        sequence.put(tmp, start++);
                        start = ModelUpdateUtils.followImporting(tmp, using, sequence, start, done);
                    }
                    ++i;
                }
            }
        }
        return start;
    }
}

