/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.pool;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.pool.IPoolManager;

public class Pool<T> {
    private IPoolManager<T> manager;
    private List<T> pool = new ArrayList<T>();

    public Pool(IPoolManager<T> manager) {
        assert (manager != null);
        this.manager = manager;
    }

    public synchronized T getInstance() {
        T result = this.pool.isEmpty() ? this.manager.create() : this.pool.remove(this.pool.size() - 1);
        return result;
    }

    public synchronized void releaseInstance(T instance) {
        if (instance != null) {
            assert (!this.containsByRef(instance));
            this.manager.clear(instance);
            this.pool.add(instance);
        }
    }

    private boolean containsByRef(T instance) {
        boolean found = false;
        int i = 0;
        int n = this.pool.size();
        while (!found && i < n) {
            found = instance == this.pool.get(i);
            ++i;
        }
        return found;
    }
}

