/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListener;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListenerQueue;
import net.ssehub.easy.instantiation.core.model.common.VilException;

public class ArtifactChangedListenerQueue
implements IArtifactChangedListenerQueue {
    private List<IArtifactChangedListener> listeners = new ArrayList<IArtifactChangedListener>();

    @Override
    public synchronized void registerListener(IArtifactChangedListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized boolean unregisterListener(IArtifactChangedListener listener) {
        return this.listeners.remove(listener);
    }

    public synchronized void triggerArtifactChanged(Object cause) throws VilException {
        ArrayList<VilException> caught = null;
        int size = this.listeners.size();
        int l = 0;
        while (l < size) {
            try {
                this.listeners.get(l).artifactChanged(cause);
            }
            catch (VilException e) {
                if (caught == null) {
                    caught = new ArrayList<VilException>();
                }
                caught.add(e);
            }
            ++l;
        }
        if (caught != null) {
            throw new VilException(caught);
        }
    }
}

