/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreatorNode;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

public class ArtifactFactory {
    private static final String DEFAULT_MODEL_BASE = "";
    private static final ArtifactCreatorNode ARTIFACT_CREATORS = new ArtifactCreatorNode(null);
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ArtifactFactory.class, "net.ssehub.easy.instantiation.core");
    private static final List<ArtifactModel> MODELS = new ArrayList<ArtifactModel>();

    private ArtifactFactory() {
    }

    private static void initialize() {
        if (MODELS.isEmpty()) {
            MODELS.add(new ArtifactModel(new File(DEFAULT_MODEL_BASE)));
        }
    }

    public static void clear() {
        MODELS.clear();
        ArtifactFactory.initialize();
    }

    public static ArtifactModel createArtifactModel(File base) {
        ArtifactFactory.initialize();
        ArtifactModel model = new ArtifactModel(base);
        MODELS.add(model);
        return model;
    }

    public static synchronized void release(ArtifactModel model) {
        ArtifactFactory.initialize();
        MODELS.remove(model);
        model.clear();
    }

    public static synchronized void clearDefaultModel() {
        ArtifactModel m;
        if (!MODELS.isEmpty() && DEFAULT_MODEL_BASE.equals((m = MODELS.get(0)).getBase().getPath())) {
            m.clear();
        }
    }

    public static IArtifact createArtifact(Object real) throws VilException {
        return ArtifactFactory.createArtifact(IArtifact.class, real, null);
    }

    public static <T extends IArtifact> T createArtifact(Class<T> kind, Object real, ArtifactModel model) throws VilException {
        IArtifact artifact;
        if (real == null) {
            throw new VilException("given object must not be null", 30005);
        }
        if (model == null) {
            model = ArtifactFactory.findModel(real);
        }
        if ((artifact = model.getArtifact(real)) == null || !kind.isAssignableFrom(artifact.getClass())) {
            IArtifactCreator creator = ArtifactFactory.findCreator(kind, real);
            if (creator == null) {
                throw new VilException("no artifact creator handles " + real.getClass().getName() + " " + String.valueOf(real), 30004);
            }
            artifact = creator.createArtifactInstance(real, model);
            model.register(real, artifact);
        } else {
            artifact.update();
        }
        try {
            return (T)((IArtifact)kind.cast(artifact));
        }
        catch (ClassCastException e) {
            throw new VilException("obtained artifact is of type " + artifact.getClass().getName() + " but " + kind.getName() + " is requested", 30006);
        }
    }

    public static IFileSystemArtifact createFileSystemArtifact(File real) throws VilException {
        return ArtifactFactory.createArtifact(IFileSystemArtifact.class, real, null);
    }

    static IFileSystemArtifact createFileSystemArtifact(File real, ArtifactModel model) throws VilException {
        return ArtifactFactory.createArtifact(IFileSystemArtifact.class, real, model);
    }

    static ArtifactCreator getCreator(Class<?> cls) {
        return cls.getAnnotation(ArtifactCreator.class);
    }

    public static String checkReplacement(Class<?> registered, Class<?> replacing) {
        String message = null;
        ArtifactCreator regCreator = ArtifactFactory.getCreator(registered);
        if (regCreator != null && ArtifactFactory.getCreator(replacing) == null) {
            message = "replacing class " + replacing.getName() + " must also be an artifact creator";
        }
        return message;
    }

    public static void registered(Class<?> cls) {
        ArtifactCreator creatorAnnotation = ArtifactFactory.getCreator(cls);
        if (creatorAnnotation != null) {
            Class<? extends IArtifactCreator> creatorClass = creatorAnnotation.value();
            if (creatorClass == null) {
                LOGGER.error("artifact creator class empty at class " + cls.getName());
            } else {
                try {
                    ArtifactFactory.addArtifactCreator(creatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    LOGGER.error("cannot create artifact creator of class " + creatorClass.getName() + ": " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("cannot create artifact creator of class " + creatorClass.getName() + ": " + e.getCause().getMessage());
                }
            }
        }
    }

    public static void addArtifactCreator(IArtifactCreator creator) {
        String creatorArtifactName = creator.getArtifactClass().getSimpleName();
        Class<?> creatorClass = creator.getClass();
        ArtifactCreatorNode node = ARTIFACT_CREATORS;
        boolean replaced = false;
        do {
            ArtifactCreatorNode found = null;
            int c = 0;
            while (found == null && c < node.getChildrenCount()) {
                ArtifactCreatorNode tmp = node.getChild(c);
                if (tmp.isMoreGeneralThan(creatorClass)) {
                    if (tmp.getArtifactName().equals(creatorArtifactName)) {
                        tmp.setCreator(creator);
                        replaced = true;
                        break;
                    }
                    found = tmp;
                }
                ++c;
            }
            if (replaced) continue;
            if (found == null) {
                node.addChild(creator);
                break;
            }
            node = found;
        } while (node != null && !replaced);
        if (node != null) {
            Object parent = node.getCreator() == null ? "as root creator" : "below " + node.getCreator().getClass().getName();
            LOGGER.info((replaced ? "replaced" : "registered") + " " + creatorClass.getName() + " " + (String)parent);
        } else {
            LOGGER.error("internal error: " + creatorClass.getName() + " not registered");
        }
    }

    private static IArtifactCreator findCreator(Class<? extends IArtifact> kind, Object real) {
        return ArtifactFactory.findCreator(kind, real, ARTIFACT_CREATORS, null).getCreator();
    }

    private static ArtifactCreatorNode findCreator(Class<? extends IArtifact> kind, Object real, ArtifactCreatorNode node, ArtifactCreatorNode actualResult) {
        ArtifactCreatorNode candidateResult = node;
        int c = 0;
        while (c < node.getChildrenCount()) {
            ArtifactCreatorNode tmp = node.getChild(c);
            boolean handles = tmp.handlesArtifact(kind, real);
            if (handles || tmp.subtreeMayHandle(kind)) {
                ArtifactCreatorNode tmpResult = ArtifactFactory.findCreator(kind, real, tmp, actualResult);
                if (!handles && tmpResult == tmp) {
                    tmpResult = null;
                }
                if (tmpResult != null) {
                    candidateResult = tmpResult;
                }
            }
            ++c;
        }
        if (candidateResult != null) {
            if (actualResult != null && actualResult.getCreator() != null) {
                LOGGER.warn(candidateResult.getCreatorClassName() + " is another handling creator for " + real.getClass().getName() + "in addition to " + actualResult.getCreatorClassName());
            } else {
                actualResult = candidateResult;
            }
        }
        return actualResult;
    }

    private static void configureArtifactCreators(ArtifactCreatorNode node, Properties properties, List<Message> messages) {
        node.configure(properties, messages);
        int c = 0;
        while (c < node.getChildrenCount()) {
            ArtifactFactory.configureArtifactCreators(node.getChild(c), properties, messages);
            ++c;
        }
    }

    public static List<Message> configureArtifactCreators(Properties properties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArtifactFactory.configureArtifactCreators(ARTIFACT_CREATORS, properties, messages);
        return messages;
    }

    public static synchronized Set<FileArtifact> selectByType(Path path, Class<?> type, boolean byKind, boolean negate) {
        ArtifactFactory.initialize();
        LinkedList<FileArtifact> result = new LinkedList<FileArtifact>();
        int m = MODELS.size() - 1;
        while (m >= 0) {
            MODELS.get(m).selectByType(path, type, result, byKind, negate);
            --m;
        }
        return new ListSet<FileArtifact>(result, type);
    }

    public static synchronized ArtifactModel findModel(Object real) {
        ArtifactFactory.initialize();
        if (real instanceof String) {
            real = new File(real.toString()).getAbsoluteFile();
        }
        ArtifactModel result = null;
        int maxPrio = 0;
        int m = MODELS.size() - 1;
        while (result == null && m >= 0) {
            ArtifactModel model = MODELS.get(m);
            int prio = model.handles(real);
            if (prio > 0 && (result == null || prio > maxPrio)) {
                result = model;
                maxPrio = prio;
            }
            --m;
        }
        if (result == null) {
            result = MODELS.get(0);
        }
        return result;
    }

    static ArtifactModel getDefaultArtifactModel() {
        ArtifactFactory.initialize();
        return MODELS.get(0);
    }
}

