/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;

public class DefaultFileArtifactCreator
implements IArtifactCreator {
    private Pattern[] patterns;
    private boolean considerBuiltInCheck = true;

    public static final boolean checkSuffix(File file, String suffix) {
        return file.getName().endsWith(suffix);
    }

    private boolean handlesFile(File file) {
        boolean handles;
        boolean bl = handles = FileUtils.isFile(file) && !PathUtils.isPattern(file);
        if (this.considerBuiltInCheck) {
            handles &= this.handlesFileImpl(file);
        }
        if (this.patterns != null) {
            String path = file.getAbsolutePath();
            int p = 0;
            while (!handles && p < this.patterns.length) {
                handles |= this.patterns[p].matcher(path).matches();
                ++p;
            }
        }
        return handles;
    }

    protected boolean handlesFileImpl(File file) {
        return true;
    }

    @Override
    public Class<? extends IArtifact> getArtifactClass() {
        return FileArtifact.class;
    }

    @Override
    public boolean handlesArtifact(Class<? extends IArtifact> kind, Object real) {
        return kind.isAssignableFrom(this.getArtifactClass()) && real instanceof File && (this.handlesFile((File)real) || this.handlesFallback(kind, (File)real));
    }

    public boolean handlesFallback(Class<? extends IArtifact> kind, File file) {
        return false;
    }

    @Override
    public IFileSystemArtifact createArtifactInstance(Object real, ArtifactModel model) throws VilException {
        return new FileArtifact((File)real, model);
    }

    @Override
    public void configure(Properties properties, List<Message> messages) {
        StringTokenizer tokens;
        String cfg;
        Class<? extends IArtifact> artifactClass = this.getArtifactClass();
        if (artifactClass != null && (cfg = properties.getProperty(artifactClass.getSimpleName(), null)) != null && (tokens = new StringTokenizer(cfg, ",")).hasMoreTokens()) {
            ArrayList<Pattern> tmpPatterns = new ArrayList<Pattern>();
            this.considerBuiltInCheck = false;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ("*".equals(token)) {
                    this.considerBuiltInCheck = true;
                    continue;
                }
                try {
                    tmpPatterns.add(Pattern.compile(token));
                }
                catch (PatternSyntaxException e) {
                    messages.add(new Message(e.getMessage(), Status.WARNING));
                }
            }
            if (!tmpPatterns.isEmpty()) {
                this.patterns = new Pattern[tmpPatterns.size()];
                tmpPatterns.toArray(this.patterns);
            }
        }
    }
}

