/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;

public class JavaPath
extends Path {
    private String path;

    protected JavaPath(Path path) throws VilException {
        this(path, null);
    }

    protected JavaPath(Path path, String prefixRegEx) throws VilException {
        super(path.getPath(), path.getArtifactModel());
        int pos;
        String tmp = path.getPath();
        if (prefixRegEx != null) {
            tmp = tmp.replaceAll(prefixRegEx, "");
        }
        if (FileUtils.isFile(tmp) && (tmp.endsWith(".java") || tmp.endsWith(".class")) && (pos = tmp.lastIndexOf(46)) > 0) {
            tmp = tmp.substring(0, pos);
        }
        this.path = tmp.replace("/", ".").replace("\\", ".");
        JavaPath.checkJavaPath(this.path);
    }

    private static String checkJavaPath(String path) throws VilException {
        boolean atIdentifierStart = true;
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (atIdentifierStart) {
                if (!Character.isJavaIdentifierStart(c)) {
                    throw new VilException("Java identifer must not start with '" + c + "'", 30007);
                }
                atIdentifierStart = false;
            } else if ('.' == c) {
                atIdentifierStart = true;
            } else if (!Character.isJavaIdentifierPart(c)) {
                throw new VilException("Java identifier must not contain '" + c + "'", 30007);
            }
            ++i;
        }
        if (path.length() == 0 && atIdentifierStart) {
            throw new VilException("Java path must not end with '.'", 30007);
        }
        return path;
    }

    @Override
    @Invisible
    public JavaPath toJavaPath() throws VilException {
        return this;
    }

    @Override
    public void deleteAll() {
    }

    @Override
    public void mkdir() {
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() throws VilException {
        int pos = this.path.lastIndexOf(46);
        String name = pos > 0 ? this.path.substring(pos + 1) : this.path;
        return name;
    }

    @Override
    public String getPathSegments() {
        return this.getPackage();
    }

    public JavaPath getPathSegmentsPath() {
        return JavaPath.convert(this.getPackage());
    }

    public String getPackage() {
        int pos = this.path.lastIndexOf(46);
        String pkg = pos > 0 ? this.path.substring(0, pos) : this.path;
        return pkg;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return this.path;
    }

    @Invisible
    @Conversion
    public static JavaPath convert(String val) {
        JavaPath result;
        try {
            result = new JavaPath(Path.convert(val));
        }
        catch (VilException e) {
            result = null;
        }
        return result;
    }
}

