/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AlternativeExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExecutableRules;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ForStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IBuildlangVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.InstantiateExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.LoadProperties;
import net.ssehub.easy.instantiation.core.model.buildlangModel.MapExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.NoTracer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionContext;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionResult;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.StrategyCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Utils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableFinder;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VtlRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.execOperand.ExecutableOperand;
import net.ssehub.easy.instantiation.core.model.buildlangModel.execOperand.IExecutableOperandType;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.BuildCollectionApplicator;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.BuildEnablingApplicator;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.BuildExecutionApplicator;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.LhsRhsMatchLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.RuleBodyExecutor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.ArtifactMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.BooleanMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.CollectionMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.CompoundMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.MatchResolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.PathMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.StringMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ExecutionVisitor;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.ITerminatable;
import net.ssehub.easy.instantiation.core.model.common.ITerminator;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.StreamGobbler;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionParserRegistry;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringReplacer;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangExecution;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractArrayWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.FixedListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Project;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.lang.SystemUtils;

public class BuildlangExecution
extends ExecutionVisitor<Script, AbstractRule, VariableDeclaration, Resolver>
implements IBuildlangVisitor,
RuleBodyExecutor,
ITerminator {
    public static final ExpressionParserRegistry.ILanguage<Resolver> LANGUAGE = new ExpressionParserRegistry.ILanguage<Resolver>(){

        @Override
        public String getName() {
            return "VIL";
        }
    };
    public static final String PARAM_SOURCE = "source";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_CONFIG = "config";
    public static final String DEFAULT_MAIN_RULE = "main";
    private RuntimeEnvironment environment;
    private ITracer tracer;
    private File base;
    private String startRuleName;
    private List<Rule> failed = new ArrayList<Rule>();
    private MatchResolver matchResolver;
    private VariableFinder variableFinder;
    private ExecutableRules executableRules;
    private Stack<RuleExecutionContext> ruleStack = new Stack();
    private Resolver resolver;
    private boolean enableRuleElementFailed = true;
    private boolean stop = false;
    private Set<ITerminatable> terminatables = new HashSet<ITerminatable>();

    public BuildlangExecution(ITracer tracer, File base, Map<String, Object> parameter) {
        this(tracer, base, DEFAULT_MAIN_RULE, parameter);
    }

    public BuildlangExecution(ITracer tracer, File base, String startRuleName, Map<String, Object> parameter) {
        super(new RuntimeEnvironment(), tracer, parameter);
        this.tracer = tracer;
        this.environment = this.getRuntimeEnvironment();
        this.base = base;
        this.startRuleName = startRuleName;
        this.initialize();
    }

    protected BuildlangExecution(RuntimeEnvironment environment) {
        super(environment, NoTracer.INSTANCE, new HashMap<String, Object>());
        this.tracer = NoTracer.INSTANCE;
        this.environment = environment;
        this.base = new File("");
        this.startRuleName = DEFAULT_MAIN_RULE;
        this.initialize();
    }

    public void stop() {
        this.stop = true;
        for (ITerminatable t : this.terminatables) {
            t.stop();
        }
    }

    protected boolean setEnableRuleElementFailed(boolean enableRuleElementFailed) {
        boolean old = this.enableRuleElementFailed;
        this.enableRuleElementFailed = enableRuleElementFailed;
        return old;
    }

    protected RuntimeEnvironment createRuntimeEnvironment() {
        return new RuntimeEnvironment();
    }

    @Override
    public RuntimeEnvironment getRuntimeEnvironment() {
        return (RuntimeEnvironment)super.getRuntimeEnvironment();
    }

    @Override
    protected ITracer getTracer() {
        return this.tracer;
    }

    @Override
    protected IExpressionParser<Resolver> getExpressionParser() {
        return ExpressionParserRegistry.getExpressionParser(LANGUAGE);
    }

    protected RuleExecutionContext peekRuleStack() {
        return this.ruleStack.peek();
    }

    protected int getRuleStackSize() {
        return this.ruleStack.size();
    }

    private void initialize() {
        this.matchResolver = new MatchResolver(this.environment, this.getExpressionParser(), this);
        this.variableFinder = new VariableFinder();
        this.executableRules = this.createExecutableRulesInstance();
        this.resolver = new Resolver(this.environment.getTypeRegistry());
    }

    protected ExecutableRules createExecutableRulesInstance() {
        return new ExecutableRules();
    }

    private static File absolute(String path, File base) {
        File result = new File(path);
        if (!result.isAbsolute()) {
            result = new File(base, path);
        }
        return result;
    }

    public int getFailedCount() {
        return this.failed.size();
    }

    public Rule getFailed(int index) {
        return this.failed.get(index);
    }

    @Override
    protected boolean checkConditionResult(Object value, Object element, ExecutionVisitor.ConditionTest test) {
        boolean ok = true;
        ok = element instanceof MapExpression ? true : (value instanceof RuleExecutionResult ? ((RuleExecutionResult)value).getStatus() != RuleExecutionResult.Status.FAIL : super.checkConditionResult(value, element, test));
        return ok;
    }

    @Override
    public Object visitScript(Script script) throws VilException {
        this.environment.switchContext(script);
        return this.executeScript(script, null);
    }

    private Object executeScript(Script script, RuleCallExpression start) throws VilException {
        Map<String, Object> scriptParam = this.determineScriptParam(start);
        this.resolver.pushModel(script);
        this.tracer.visitScript(script, this.environment);
        if (scriptParam != null) {
            scriptParam = this.replaceParameter(scriptParam);
        }
        this.visitModelHeader(script);
        ArrayList<File> vtlPaths = new ArrayList<File>();
        int p = 0;
        while (p < script.getParameterCount()) {
            String pName;
            Configuration config;
            Object value;
            try {
                value = this.environment.getValue(script.getParameter(p));
            }
            catch (VilException e) {
                value = null;
            }
            if (value instanceof Configuration && (config = (Configuration)value).getRootScript() == null) {
                config.setRootScript(script);
            }
            if ((pName = script.getParameter(p).getName()).equals(PARAM_SOURCE) || pName.equals(PARAM_TARGET)) {
                if (value instanceof Project) {
                    vtlPaths.add(((Project)value).getVtlFolder().getAbsolutePath());
                }
                if (value instanceof Project[]) {
                    Project[] projectArray = (Project[])value;
                    int n = projectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Project prj = projectArray[n2];
                        vtlPaths.add(prj.getVtlFolder().getAbsolutePath());
                        ++n2;
                    }
                }
            }
            ++p;
        }
        this.executableRules.collect(script);
        IResolvableModel<VariableDeclaration, Script> oldContext = this.environment.switchContext(script);
        this.environment.setContextPaths(vtlPaths);
        this.processProperties(script, this.getTargetPath(script, scriptParam));
        this.checkConstants(script);
        this.tracer.visitScriptBody(script, this.environment);
        Object result = start == null ? this.executeDefault(script) : start.accept(this);
        this.resolver.popModel();
        if (scriptParam != null) {
            scriptParam = this.replaceParameter(scriptParam);
        }
        this.environment.switchContext(oldContext);
        this.tracer.visitedScript(script);
        return result;
    }

    @Override
    public void release(boolean releaseDefault) {
        Object source;
        Object target = this.getParameter(PARAM_TARGET);
        if (target instanceof Project) {
            ((Project)target).release();
        }
        if ((source = this.getParameter(PARAM_SOURCE)) != target && source instanceof Project) {
            ((Project)source).release();
        }
        if (releaseDefault) {
            ArtifactFactory.clearDefaultModel();
        }
    }

    protected Object executeDefault(Script script) throws VilException {
        return this.executeMain(script, script.determineStartRule(this.startRuleName));
    }

    private File getTargetPath(Script script, Map<String, Object> scriptParam) {
        File result = this.base;
        Object target = null;
        if (scriptParam != null) {
            target = scriptParam.get(PARAM_TARGET);
        }
        if (target == null && script.getParameterCount() >= 3) {
            try {
                target = this.environment.getValue(script.getParameter(2));
            }
            catch (VilException vilException) {
                // empty catch block
            }
            if (!(target instanceof Project)) {
                target = null;
            }
        }
        if (target == null) {
            int p = 0;
            while (target == null && p < script.getParameterCount()) {
                VariableDeclaration decl = script.getParameter(p);
                if (decl.getName().equals(PARAM_TARGET)) {
                    try {
                        target = this.environment.getValue(decl);
                    }
                    catch (VilException vilException) {
                        // empty catch block
                    }
                }
                ++p;
            }
        }
        if (target instanceof Project) {
            result = ((Project)target).getPath().getAbsolutePath();
        }
        return result;
    }

    @Override
    protected void initializeImplicitVariables(IResolvableModel<VariableDeclaration, Script> model) throws VilException {
        if (model instanceof Script) {
            Script script = (Script)model;
            VariableDeclaration var = script.getVariableDeclaration("OTHERPROJECTS");
            if (var != null) {
                this.environment.addValue(var, this.environment.getOtherProjects());
            }
            if ((var = script.getVariableDeclaration("SCRIPTDIR")) != null) {
                File file = script.getContainingFolder();
                String scriptDir = file == null ? "" : file.getAbsolutePath();
                this.environment.addValue(var, scriptDir);
            }
        }
    }

    @Override
    protected ModelCallExpression<VariableDeclaration, Script, AbstractRule> createModelCall(Script model, AbstractRule operation, CallArgument ... arguments) throws VilException {
        return new RuleCallExpression(model, operation, arguments);
    }

    @Override
    protected void setModelArgument(VariableDeclaration param, Object value) throws VilException {
        AbstractArrayWrapper newVal = value;
        if (value != null) {
            Project[] pArray;
            TypeDescriptor<?> projectType = IvmlTypes.projectType();
            TypeDescriptor<?> type = param.getType();
            if (type.isCollection() && 1 == type.getGenericParameterCount() && projectType.isAssignableFrom(type.getGenericParameterType(0))) {
                Project[] pArray2 = null;
                if (value instanceof Project[]) {
                    pArray2 = (Project[])value;
                } else if (value instanceof Project) {
                    pArray2 = new Project[]{(Project)((Object)value)};
                }
                if (pArray2 != null) {
                    newVal = type.isSequence() ? new ArraySequence<Project>(pArray2, Project.class) : new ArraySet<Project>(pArray2, Project.class);
                }
            } else if (type.isAssignableFrom(projectType) && value instanceof Project[] && (pArray = (Project[])value).length > 0) {
                newVal = pArray[0];
            }
        }
        super.setModelArgument(param, newVal);
    }

    protected void processProperties(Script script, File base) throws VilException {
        Properties loaded = new Properties();
        int p = 0;
        while (p < script.getPropertiesCount()) {
            LoadProperties prop = script.getProperties(p);
            String path = prop.getPath();
            path = StringReplacer.substitute(path, new Resolver(this.environment), this.getExpressionParser(), this, null);
            File file = BuildlangExecution.absolute(path, base);
            this.loadProperties(file, loaded, null);
            if (SystemUtils.IS_OS_MAC) {
                this.loadProperties(file, loaded, "macos");
            } else if (SystemUtils.IS_OS_UNIX) {
                this.loadProperties(file, loaded, "unix");
            } else if (SystemUtils.IS_OS_WINDOWS) {
                this.loadProperties(file, loaded, "win");
            }
            ++p;
        }
        int v = 0;
        while (v < script.getVariableDeclarationCount()) {
            VariableDeclaration var = script.getVariableDeclaration(v);
            String value = loaded.getProperty(var.getName(), null);
            if (value != null) {
                if (var.isConstant() && var.getExpression() != null) {
                    throw new VilException("constant '" + var.getName() + "' is already assigned a value", 50002);
                }
                Object actValue = this.evaluateExternalValue(var, value);
                this.environment.setValue(var, actValue);
                this.tracer.valueDefined(var, null, actValue);
            }
            ++v;
        }
    }

    private void loadProperties(File file, Properties prop, String os) throws VilException {
        boolean loadFile = true;
        if (os != null) {
            Object f = file.toString();
            int pos = ((String)f).lastIndexOf(46);
            if (pos > 0 && pos < ((String)f).length()) {
                f = ((String)f).substring(0, pos + 1) + os + "." + ((String)f).substring(pos + 1);
                file = new File((String)f);
                loadFile = file.exists();
            } else {
                loadFile = false;
            }
        }
        if (loadFile) {
            try {
                FileInputStream fis = new FileInputStream(file);
                Properties p = new Properties();
                p.load(fis);
                prop.putAll((Map<?, ?>)p);
                fis.close();
                for (String key : prop.stringPropertyNames()) {
                    String value = prop.getProperty(key);
                    try {
                        value = StringReplacer.substitute(value, new Resolver(this.environment), this.getExpressionParser(), this, null);
                    }
                    catch (VilException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception((Exception)((Object)e));
                    }
                    prop.setProperty(key, value);
                }
            }
            catch (IOException e) {
                throw new VilException(e.getMessage(), e, 50001);
            }
        }
    }

    private Object evaluateExternalValue(VariableDeclaration var, String value) throws VilException {
        Object actValue;
        block2: {
            try {
                ConstantExpression ex = new ConstantExpression(var.getType(), value, this.environment.getTypeRegistry());
                actValue = ex.accept(this);
            }
            catch (VilException e) {
                OperationDescriptor desc;
                actValue = value;
                TypeDescriptor<?> varType = var.getType();
                TypeDescriptor<?> exType = TypeRegistry.stringType();
                if (varType.isAssignableFrom(exType) || (desc = TypeDescriptor.findConversionOnBoth(exType, varType)) == null) break block2;
                Expression ex = new ConstantExpression(exType, value, this.environment.getTypeRegistry());
                ex = new CallExpression(desc, new CallArgument(ex));
                actValue = ex.accept(this);
            }
        }
        return actValue;
    }

    private void checkConstants(Script script) throws VilException {
        int v = 0;
        while (v < script.getVariableDeclarationCount()) {
            VariableDeclaration var = script.getVariableDeclaration(v);
            if (var.isConstant() && !this.environment.isDefined(var)) {
                throw new VilException("constant '" + var.getName() + "' must be assigned a value (either in script or via loaded properties)", 70001);
            }
            ++v;
        }
    }

    private String postprocessSystemCallArgument(String argument) {
        return argument == null ? "" : argument.replaceAll("(\\r|\\n)", "");
    }

    @Override
    public Object visitStrategyCallExpression(StrategyCallExpression call) throws VilException {
        Object result = this.stop || call.isPlaceholder() ? null : this.visitStrategyCallExpressionImpl(call);
        return result;
    }

    public Object visitStrategyCallExpressionImpl(StrategyCallExpression call) throws VilException {
        Object result;
        switch (call.getType()) {
            case EXECUTE: {
                Object nameVarVal = this.environment.getValue(call.getNameVariable());
                String exec = nameVarVal instanceof Path ? ((Path)nameVarVal).getAbsolutePath().getAbsolutePath() : StringValueHelper.getStringValue(nameVarVal, null);
                Object[] args = new String[call.getArgumentsCount() + 1];
                args[0] = this.postprocessSystemCallArgument(exec);
                int a = 1;
                while (a < args.length) {
                    Object o = call.getArgument(a - 1).accept(this);
                    IExecutableOperandType type = ExecutableOperand.getExecutableType(o);
                    args[a] = type == null ? (o == null ? null : o.toString()) : type.convert(o);
                    args[a] = this.postprocessSystemCallArgument((String)args[a]);
                    ++a;
                }
                EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(StrategyCallExpression.class, "net.ssehub.easy.instantiation.core");
                logger.info("system call: " + Arrays.toString(args));
                this.tracer.visitSystemCall((String[])args);
                ProcessBuilder builder = new ProcessBuilder((String[])args);
                try {
                    Process process = builder.start();
                    StreamGobbler.gobble(process);
                    int res = process.waitFor();
                    logger.info("execution result: " + res);
                }
                catch (InterruptedException e) {
                    throw new VilException(e, 50501);
                }
                catch (IOException e) {
                    throw new VilException(e, 50501);
                }
                result = Boolean.TRUE;
                break;
            }
            case INSTANTIATOR: {
                this.tracer.visitingInstantiator(call.getName());
                result = this.visitCallExpression(call);
                this.tracer.visitedInstantiator(call.getName(), result);
                break;
            }
            default: {
                throw new VilException("illegal strategy type " + String.valueOf((Object)call.getType()), 70000);
            }
        }
        return result;
    }

    @Override
    protected void addImplicitParamters(Map<String, Object> named) {
        super.addImplicitParamters(named);
        named.put("$terminator", this);
    }

    @Override
    public Object visitLoadProperties(LoadProperties properties) throws VilException {
        return null;
    }

    private void registerParameter(AbstractRule rule) throws VilException {
        int p = 0;
        while (p < rule.getParameterCount()) {
            VariableDeclaration var = (VariableDeclaration)rule.getParameter(p);
            IResolvable res = this.environment.get(var.getName());
            if (res == null) {
                throw new VilException("parameter " + var.getName() + " is not defined in rule " + rule.getSignature(), 50004);
            }
            this.environment.addValue(var, this.environment.getValue(res));
            ++p;
        }
    }

    private void addVariablesToFinder(Rule rule, Rule.Side side, boolean matchVariables) {
        int i = 0;
        while (i < rule.getVariablesCount(side)) {
            VariableDeclaration decl = matchVariables ? rule.getMatchVariable(side, i) : rule.getVariable(side, i);
            if (decl != null) {
                this.variableFinder.addToSearch(decl);
            }
            ++i;
        }
    }

    protected Object applyRuleBody(Rule rule, Object[] rhsValues, RuleExecutionContext context) throws VilException {
        Object bodyRes = null;
        RuleExecutionResult.Status status = RuleExecutionResult.Status.SUCCESS;
        if (context != null) {
            this.variableFinder.reset();
            this.addVariablesToFinder(rule, Rule.Side.LHS, false);
            this.addVariablesToFinder(rule, Rule.Side.RHS, false);
            rule.accept(this.variableFinder);
            boolean iteratedExecution = this.variableFinder.wasFound();
            this.variableFinder.reset();
            this.addVariablesToFinder(rule, Rule.Side.RHS, true);
            rule.accept(this.variableFinder);
            boolean matchExecution = this.variableFinder.wasFound();
            if (matchExecution) {
                LhsRhsMatchLoop.matchLoop(rule, rhsValues, new BuildCollectionApplicator(this.environment), this.tracer);
            }
            if (iteratedExecution) {
                BuildExecutionApplicator applicator = new BuildExecutionApplicator(this.environment, context, this);
                LhsRhsMatchLoop.matchLoop(rule, rhsValues, applicator, this.tracer);
                status = applicator.getStatus();
            } else {
                bodyRes = this.executeRuleBody(rule, context);
                status = RuleExecutionResult.Status.toStatus(bodyRes);
            }
        } else {
            BuildEnablingApplicator applicator = new BuildEnablingApplicator();
            LhsRhsMatchLoop.matchLoop(rule, rhsValues, applicator, this.tracer);
            status = applicator.allConditionsEnabled() ? RuleExecutionResult.Status.SUCCESS : RuleExecutionResult.Status.NOT_APPLICABLE;
        }
        Object result = context != null && rule.returnActualValue() ? bodyRes : status;
        return result;
    }

    @Override
    public Object executeRuleBody(IRuleBlock ruleBody, RuleExecutionContext context) throws VilException {
        RuleExecutionResult.Status result;
        RuleExecutionResult.Status status = RuleExecutionResult.Status.SUCCESS;
        Object resVal = null;
        if (ruleBody != null) {
            int bodyEltCount = ruleBody.getBodyElementCount();
            int lastBodyEltIndex = bodyEltCount - 1;
            boolean returnActual = ruleBody.returnActualValue();
            int e = 0;
            while (RuleExecutionResult.Status.SUCCESS == status && e < bodyEltCount) {
                Object eltVal;
                IRuleElement elt = ruleBody.getBodyElement(e);
                resVal = eltVal = elt.accept(this);
                if (this.mayFail(elt) && !this.checkConditionResult(eltVal, elt, ExecutionVisitor.ConditionTest.DONT_CARE)) {
                    if (this.enableRuleElementFailed && (!returnActual || e != lastBodyEltIndex) && this.ruleElementFailed(elt, context)) {
                        this.tracer.failedAt(ruleBody.getBodyElement(e));
                        status = RuleExecutionResult.Status.FAIL;
                    }
                } else {
                    context.add(eltVal);
                    if (RuleExecutionResult.Status.FAIL == context.getStatus()) {
                        status = RuleExecutionResult.Status.FAIL;
                    }
                }
                ++e;
            }
        }
        if (context.getRule().returnActualValue()) {
            if (RuleExecutionResult.Status.FAIL == status) {
                resVal = null;
            }
            result = resVal;
        } else {
            result = status;
        }
        return result;
    }

    protected boolean ruleElementFailed(IRuleElement elt, RuleExecutionContext context) throws VilException {
        return true;
    }

    void resolveMatches(AbstractRule rule, Rule.Side side) throws VilException {
        int count = rule.getRuleConditionCount(side);
        if (count > 0) {
            int i = 0;
            while (i < count) {
                rule.getRuleCondition(side, i).accept(this.matchResolver);
                ++i;
            }
        }
    }

    boolean isOnStack(AbstractRule rule) {
        boolean found = false;
        int i = this.ruleStack.size() - 1;
        while (!found && i >= 0) {
            found = ((RuleExecutionContext)this.ruleStack.get(i)).getRule() == rule;
            --i;
        }
        return found;
    }

    private RuleExecutionResult.Status determineRhsLhsMatching(Rule rule, Object[] rhsValues) throws VilException {
        RuleExecutionResult.Status status = RuleExecutionResult.Status.SUCCESS;
        int rhsCondCount = rule.getRuleConditionCount(Rule.Side.RHS);
        int c = 0;
        while (RuleExecutionResult.Status.SUCCESS == status && c < rhsCondCount) {
            AbstractRuleMatchExpression cond = rule.getRuleCondition(Rule.Side.RHS, c);
            rhsValues[c] = cond.accept(this);
            assert (cond.inferType().isCollection());
            if (!this.checkConditionResult(rhsValues[c], rule, ExecutionVisitor.ConditionTest.DONT_CARE)) {
                rhsValues[c] = this.executableRules.buildContributing(cond, this);
                if (!this.checkConditionResult(rhsValues[c], cond, ExecutionVisitor.ConditionTest.DONT_CARE)) {
                    status = RuleExecutionResult.Status.NOT_APPLICABLE;
                }
            }
            ++c;
        }
        if (RuleExecutionResult.Status.SUCCESS == status) {
            status = RuleExecutionResult.Status.toStatus(this.applyRuleBody(rule, rhsValues, null));
        }
        return status;
    }

    @Override
    public Object visitRule(Rule rule) throws VilException {
        boolean visited = false;
        Object bodyRes = null;
        boolean ruleExecResult = true;
        RuleExecutionContext context = new RuleExecutionContext(rule, this.environment);
        if (this.prepareExecution(context)) {
            this.tracer.visitRule(rule, this.environment);
            visited = true;
            if (RuleExecutionResult.Status.SUCCESS == context.getStatus()) {
                bodyRes = this.applyRuleBody(rule, context.getRhsValues(), context);
                ruleExecResult = bodyRes instanceof RuleExecutionResult.Status;
                context.setStatus(bodyRes);
                this.checkPostconditions(context);
            }
        }
        this.cleanupRuleExecution(context);
        Object result = ruleExecResult ? new RuleExecutionResult(context.getStatus(), context) : bodyRes;
        if (visited) {
            this.tracer.visitedRule(rule, this.environment, result);
        }
        return result;
    }

    @Override
    public Object visitRule(VtlRule rule) throws VilException {
        net.ssehub.easy.instantiation.core.model.templateModel.ITracer tracer = TracerFactory.createTemplateLanguageTracer();
        TracerFactory.registerTemplateLanguageTracer(tracer);
        NullWriter writer = new NullWriter();
        HashMap<String, Object> localParam = new HashMap<String, Object>();
        localParam.put(PARAM_CONFIG, this.environment.getTopLevelConfiguration());
        localParam.put(PARAM_TARGET, null);
        net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment<?, ?> oldEnv = tracer.getRuntimeEnvironment();
        TemplateLangExecution exec = new TemplateLangExecution(tracer, (Writer)writer, localParam);
        Def def = rule.getDef();
        Template template = (Template)def.getParent();
        IRuntimeEnvironment tEnv = exec.getRuntimeEnvironment();
        ((net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment)tEnv).switchContext(template);
        exec.visitModelHeader(template);
        int p = 0;
        while (p < rule.getParameterCount()) {
            VariableDeclaration var = rule.getParameter(p);
            net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration defP = def.getParameter(p);
            IResolvable res = this.environment.get(var.getName());
            if (res == null) {
                throw new VilException("parameter " + var.getName() + " is not defined in rule " + rule.getSignature(), 50004);
            }
            ((net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment)tEnv).addValue(defP, this.environment.getValue(res));
            ++p;
        }
        Object result = def.accept(exec);
        TracerFactory.unregisterTemplateLanguageTracer(tracer);
        tracer.setRuntimeEnvironment(oldEnv);
        return result;
    }

    protected boolean prepareExecution(RuleExecutionContext context) throws VilException {
        boolean goOn;
        Rule rule = context.getRule();
        if (rule.isPlaceholder()) {
            context.setStatus(RuleExecutionResult.Status.NOT_APPLICABLE);
            goOn = false;
        } else {
            this.ruleStack.push(context);
            context.setStatus(RuleExecutionResult.Status.SUCCESS);
            this.environment.pushLevel();
            this.registerParameter(rule);
            this.resolveMatches(rule, Rule.Side.RHS);
            this.resolveMatches(rule, Rule.Side.LHS);
            int rhsCondCount = rule.getRuleConditionCount(Rule.Side.RHS);
            if (rhsCondCount > 0) {
                Object[] rhsValues = new Object[rhsCondCount];
                context.setStatus(this.determineRhsLhsMatching(rule, rhsValues));
                context.setRhsValues(rhsValues);
            }
            int c = 0;
            while (RuleExecutionResult.Status.SUCCESS == context.getStatus() && c < rule.getRuleCallCount(Rule.Side.RHS)) {
                RuleCallExpression ex = rule.getRuleCall(Rule.Side.RHS, c);
                RuleExecutionResult res = (RuleExecutionResult)ex.accept(this);
                if (RuleExecutionResult.Status.FAIL == res.getStatus()) {
                    context.setStatus(RuleExecutionResult.Status.FAIL);
                }
                this.environment.addValue(rule.getVariable(Rule.Side.RHS, rhsCondCount + c), res);
                context.add(res);
                ++c;
            }
            goOn = true;
        }
        return goOn;
    }

    protected void checkPostconditions(RuleExecutionContext context) throws VilException {
        Rule rule = context.getRule();
        int c = 0;
        while (RuleExecutionResult.Status.SUCCESS == context.getStatus() && c < rule.getRuleConditionCount(Rule.Side.LHS)) {
            AbstractRuleMatchExpression ex = rule.getRuleCondition(Rule.Side.LHS, c);
            if (!this.checkConditionResult(ex.accept(this), ex, ExecutionVisitor.ConditionTest.EXISTS)) {
                context.setStatus(RuleExecutionResult.Status.FAIL);
                this.tracer.failedAt(ex);
            }
            ++c;
        }
    }

    protected void cleanupRuleExecution(RuleExecutionContext context) throws VilException {
        if (RuleExecutionResult.Status.NOT_APPLICABLE != context.getStatus()) {
            Rule rule = context.getRule();
            this.ruleStack.pop();
            this.environment.popLevel();
            if (RuleExecutionResult.Status.FAIL == context.getStatus()) {
                this.failed.add(rule);
            } else if (RuleExecutionResult.Status.SUCCESS == context.getStatus()) {
                context.addAllResults();
            }
        }
    }

    @Override
    public Object visitRuleCallExpression(RuleCallExpression ex) throws VilException {
        return this.visitModelCallExpression(ex);
    }

    @Override
    protected Object executeModelCall(AbstractRule rule) throws VilException {
        Object result = this.stop ? null : rule.accept(this);
        return result;
    }

    @Override
    public Object visitPathMatchExpression(PathMatchExpression expression) throws VilException {
        return expression.evaluate(this);
    }

    @Override
    public Object visitBooleanMatchExpression(BooleanMatchExpression expression) throws VilException {
        return expression.getExpression().accept(this);
    }

    @Override
    public Object visitStringMatchExpression(StringMatchExpression expression) throws VilException {
        return expression.evaluate(this);
    }

    @Override
    public Object visitArtifactMatchExpression(ArtifactMatchExpression expression) throws VilException {
        return expression.evaluate(this);
    }

    @Override
    public Object visitCollectionMatchExpression(CollectionMatchExpression expression) throws VilException {
        return expression.evaluate(this);
    }

    @Override
    public Object visitJoinExpression(JoinExpression ex) throws VilException {
        this.environment.pushLevel();
        Object result = this.join(ex);
        this.environment.popLevel();
        return result;
    }

    private Collection<Object> evaluate(JoinVariableDeclaration var) throws VilException {
        return (Collection)var.getExpression().accept(this);
    }

    private static Collection<Object>[] createCollectionArray(int length) {
        return new Collection[length];
    }

    private static Iterator<Object>[] createIteratorArray(int length) {
        return new Iterator[length];
    }

    private Object join(JoinExpression join) throws VilException {
        ArrayList<IVilType> simpleResult = new ArrayList<IVilType>();
        ArrayList<IVilType[]> complexResult = new ArrayList<IVilType[]>();
        Collection<Object>[] collection = BuildlangExecution.createCollectionArray(join.getVariablesCount());
        Iterator<Object>[] iter = BuildlangExecution.createIteratorArray(join.getVariablesCount());
        int i = 0;
        while (i < join.getVariablesCount()) {
            collection[i] = this.tracer.adjustSequenceForJoin(this.evaluate(join.getVariable(i)));
            iter[i] = collection[i].iterator();
            ++i;
        }
        boolean stop = false;
        int lastIndex = join.getVariablesCount() - 1;
        int i2 = 0;
        while (!stop && i2 <= lastIndex) {
            if (iter[i2].hasNext()) {
                this.setJoinVariableValue(join, i2, iter[i2].next());
            } else {
                stop = true;
            }
            ++i2;
        }
        if (!stop && iter[lastIndex].hasNext()) {
            boolean propagate = false;
            while (iter[0].hasNext()) {
                if (propagate) {
                    iter[lastIndex] = collection[lastIndex].iterator();
                    this.setJoinVariableValue(join, lastIndex, iter[lastIndex].next());
                    int pos = lastIndex - 1;
                    while (pos >= 0 && !iter[pos].hasNext()) {
                        --pos;
                    }
                    if (pos >= 0) {
                        this.setJoinVariableValue(join, pos, iter[pos].next());
                        int i3 = lastIndex - 1;
                        while (i3 > pos) {
                            iter[i3] = collection[i3].iterator();
                            if (iter[i3].hasNext()) {
                                iter[i3] = collection[i3].iterator();
                                this.setJoinVariableValue(join, i3, iter[i3].next());
                            }
                            --i3;
                        }
                    }
                }
                this.evaluateJoinCombination(join, simpleResult, complexResult);
                while (iter[lastIndex].hasNext()) {
                    this.setJoinVariableValue(join, lastIndex, iter[lastIndex].next());
                    this.evaluateJoinCombination(join, simpleResult, complexResult);
                }
                propagate = true;
            }
        }
        FixedListSequence result = 1 == join.getVisibleVariablesCount() ? new FixedListSequence(simpleResult, this.environment.getTypeRegistry(), BuildlangExecution.types(join)) : new FixedListSequence(complexResult, this.environment.getTypeRegistry(), BuildlangExecution.types(join));
        return result;
    }

    private void setJoinVariableValue(JoinExpression join, int index, Object value) throws VilException {
        this.environment.addValue(join.getVariable(index), value);
    }

    private void evaluateJoinCombination(JoinExpression join, List<IVilType> simpleResult, List<IVilType[]> complexResult) throws VilException {
        Boolean bool = join.getCondition() != null ? (Boolean)join.getCondition().accept(this) : Boolean.TRUE;
        if (bool != null && bool.booleanValue()) {
            if (1 == join.getVisibleVariablesCount()) {
                simpleResult.add((IVilType)this.environment.getValue(join.getVisibleVariable(0)));
            } else {
                IVilType[] tmp = new IVilType[join.getVisibleVariablesCount()];
                int i = 0;
                while (i < join.getVisibleVariablesCount()) {
                    tmp[i] = (IVilType)this.environment.getValue(join.getVisibleVariable(i));
                    ++i;
                }
                complexResult.add(tmp);
            }
        }
    }

    private static Class<?>[] types(JoinExpression join) {
        int count = join.getVisibleVariablesCount();
        Class[] result = new Class[count];
        int i = 0;
        while (i < count) {
            result[i] = join.getVisibleVariable(i).getType().getTypeClass();
            ++i;
        }
        return result;
    }

    @Override
    public Object visitJoinVariableDeclaration(JoinVariableDeclaration decl) throws VilException {
        return decl.getExpression().accept(this);
    }

    @Override
    public Object visitAlternativeExpression(AlternativeExpression alt) throws VilException {
        Object result = null;
        Object condition = alt.getCondition().accept(this);
        if (condition instanceof Boolean) {
            boolean execThenPart = (Boolean)condition;
            this.tracer.visitAlternative(execThenPart);
            IRuleBlock execute = execThenPart ? alt.getIfPart() : alt.getElsePart();
            if (execute != null) {
                RuleExecutionContext context = this.ruleStack.peek();
                boolean failed = false;
                ExpressionStatement determinesResult = Utils.findLastExpressionStatement(execute);
                this.environment.pushLevel();
                int e = 0;
                while (!failed && e < execute.getBodyElementCount()) {
                    IRuleElement elt = execute.getBodyElement(e);
                    Object eltRes = elt.accept(this);
                    context.add(eltRes);
                    if (elt == determinesResult) {
                        result = eltRes;
                    } else if (this.mayFail(elt)) {
                        boolean bl = failed = !this.checkConditionResult(eltRes, elt, ExecutionVisitor.ConditionTest.DONT_CARE);
                        if (this.enableRuleElementFailed) {
                            this.ruleElementFailed(elt, context);
                        }
                    }
                    ++e;
                }
                this.environment.popLevel();
            }
        }
        return result;
    }

    @Override
    public Object visitMapExpression(MapExpression map) throws VilException {
        boolean failed = false;
        TypeDescriptor<?> mapType = map.inferType();
        ArrayList<Object> result = TypeRegistry.voidType() == mapType ? null : new ArrayList<Object>();
        try {
            this.environment.pushLevel();
            this.tracer.visitLoop(map, this.environment);
            failed = this.executeLoop(map, true, result) == null;
            this.tracer.visitedLoop(map, this.environment);
        }
        catch (ClassCastException e) {
            throw new VilException(e.getMessage(), 70000);
        }
        catch (IndexOutOfBoundsException e) {
            throw new VilException("index out of bounds " + e.getMessage(), 70000);
        }
        this.environment.popLevel();
        return BuildlangExecution.mapResult(mapType, result, failed);
    }

    private Object executeLoop(IEnumeratingLoop loop, boolean parallelize, List<Object> result) throws VilException {
        Object bodyResult = null;
        boolean failed = false;
        RuleExecutionContext context = this.ruleStack.peek();
        Expression expr = loop.getExpression();
        Object set = this.convertToContainer(expr, expr.accept(this), loop.getElementName());
        if (set instanceof Collection) {
            Collection<?> coll = (Collection<?>)set;
            if (coll.allowSequenceAdjustment()) {
                coll = this.tracer.adjustSequenceForMap(coll);
            }
            Iterator iter = coll.iterator();
            while (iter.hasNext() && !this.stop) {
                Object entry = iter.next();
                if (loop.getVariablesCount() > 1) {
                    Object[] data = (Object[])entry;
                    int v = 0;
                    while (v < loop.getVariablesCount()) {
                        VariableDeclaration var = loop.getVariable(v);
                        this.environment.addValue(var, data[v]);
                        this.tracer.visitIteratorAssignment(loop, var, data[v]);
                        ++v;
                    }
                } else {
                    VariableDeclaration var = loop.getVariable(0);
                    this.environment.addValue(var, entry);
                    this.tracer.visitIteratorAssignment(loop, var, entry);
                }
                Object iterResult = null;
                IRuleElement determinesResult = loop.determinesResult();
                int e = 0;
                while (!failed && e < loop.getBodyElementCount()) {
                    IRuleElement elt = loop.getBodyElement(e);
                    Object eltRes = elt.accept(this);
                    context.add(eltRes);
                    if (elt == determinesResult) {
                        iterResult = eltRes;
                    } else if (this.mayFail(elt)) {
                        boolean bl = failed = !this.checkConditionResult(eltRes, elt, ExecutionVisitor.ConditionTest.DONT_CARE);
                        if (this.enableRuleElementFailed) {
                            this.ruleElementFailed(elt, context);
                        }
                    }
                    ++e;
                }
                if (result != null) {
                    result.add(iterResult);
                }
                bodyResult = iterResult;
            }
        }
        return bodyResult;
    }

    private static Object mapResult(TypeDescriptor<?> mapType, List<Object> result, boolean failed) {
        Object mapResult;
        if (result == null) {
            mapResult = !failed;
        } else {
            TypeDescriptor<?>[] param;
            if (1 == mapType.getGenericParameterCount()) {
                param = TypeDescriptor.createArray(1);
                param[0] = mapType.getGenericParameterType(0);
            } else {
                param = null;
            }
            mapResult = new ListSequence<Object>(result, param);
        }
        return mapResult;
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        return cst.getValue();
    }

    @Override
    protected AbstractRule dynamicDispatch(AbstractRule operation, Object[] args, IArgumentProvider argumentProvider, boolean enableParentScope) {
        return AbstractCallExpression.dynamicDispatch(operation, args, AbstractRule.class, this.environment.getTypeRegistry(), argumentProvider, enableParentScope ? this.environment.getMostSpecificContextModel() : null);
    }

    @Override
    protected void handleParameterInSequence(IResolvableModel<VariableDeclaration, Script> model, Map<String, VariableDeclaration> varMap) throws VilException {
        if (model.getParameterCount() >= 3) {
            boolean ok = IvmlTypes.projectType().isAssignableFrom(((VariableDeclaration)model.getParameter(0)).getType());
            ok &= IvmlTypes.configurationType().isAssignableFrom(((VariableDeclaration)model.getParameter(1)).getType());
            if (ok &= IvmlTypes.projectType().isAssignableFrom(((VariableDeclaration)model.getParameter(2)).getType())) {
                this.assignModelParameter(model, model);
                int p = 0;
                while (p < 3) {
                    varMap.remove(((VariableDeclaration)model.getParameter(p)).getName());
                    ++p;
                }
            }
        }
    }

    @Override
    protected void assignModelParameter(IResolvableModel<VariableDeclaration, Script> targetModel, IResolvableModel<VariableDeclaration, Script> srcModel) throws VilException {
        this.setModelArgument(srcModel, 0, PARAM_SOURCE);
        this.setModelArgument(srcModel, 1, PARAM_CONFIG);
        this.setModelArgument(srcModel, 2, PARAM_TARGET);
        this.evaluateModelParameter(targetModel, srcModel, 3);
    }

    private void setModelArgument(IResolvableModel<VariableDeclaration, Script> srcModel, int index, String name) throws VilException {
        if (srcModel.getParameterCount() >= index + 1) {
            try {
                this.setModelArgument((VariableDeclaration)srcModel.getParameter(index), this.getParameter(name));
            }
            catch (VilException e) {
                VariableDeclaration decl = (VariableDeclaration)srcModel.getParameter(name);
                if (decl != null) {
                    this.setModelArgument(decl, this.getParameter(name));
                }
                throw e;
            }
        }
    }

    private Script resolveScript(Project project, IVersionRestriction restrictions) throws VilException {
        Script script = null;
        AvailableModels available = BuildModel.INSTANCE.availableModels();
        Script current = (Script)this.resolver.getCurrentModel();
        ModelInfo currentInfo = available.getModelInfo((IModel)current);
        try {
            script = (Script)BuildModel.INSTANCE.resolve(project.getName(), restrictions, currentInfo.getLocation(), this.environment);
        }
        catch (ModelManagementException e) {
            throw new VilException(e.getMessage(), e.getId());
        }
        return script;
    }

    @Override
    public Object visitInstantiateExpression(InstantiateExpression inst) throws VilException {
        Script script = null;
        String name = null;
        if (inst.getProject() != null) {
            Object pr;
            name = inst.getName();
            if (name == null) {
                name = DEFAULT_MAIN_RULE;
            }
            if ((pr = this.environment.getValue(inst.getProject())) instanceof Project) {
                Project project = (Project)pr;
                script = this.resolveScript(project, inst.getVersionRestriction());
                if (script == null) {
                    script = project.getMainVilScript();
                }
                if (script == null) {
                    throw new VilException("cannot resolve script " + name + " in project " + project.getName(), 50502);
                }
            }
            if (script == null) {
                throw new VilException("cannot resolve script " + name, 50502);
            }
            this.resolver.pushModel(script);
        } else {
            name = inst.getQualifiedName();
        }
        CallArgument[] args = new CallArgument[inst.getArgumentsCount()];
        int a = 0;
        while (a < args.length) {
            args[a] = inst.getArgument(a);
            ++a;
        }
        RuleCallExpression ex = (RuleCallExpression)this.resolver.createCallExpression(false, name, args);
        if (inst.getProject() != null) {
            this.resolver.popModel();
        }
        if (ex == null) {
            throw new VilException("cannot resolve rule " + name, 50502);
        }
        Object result = script == null ? ex.accept(this) : this.executeScript(script, ex);
        return result;
    }

    @Override
    public Object visitCompoundMatchExpression(CompoundMatchExpression expression) throws VilException {
        return expression.evaluate(this);
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        Object result;
        Object val = this.environment.getValue(ex.getVariable());
        if (val instanceof Rule) {
            Rule rule = (Rule)val;
            result = this.proceedModelCall(rule, rule.getParent(), ex, false, false);
        } else {
            result = super.visitResolvableOperationCallExpression(ex);
        }
        return result;
    }

    @Override
    public Object visitTypedef(Typedef typedef) throws VilException {
        return null;
    }

    @Override
    public Object visitWhileStatement(WhileStatement stmt) throws VilException {
        Expression condition = stmt.getCondition();
        boolean executeLoop = false;
        RuleExecutionContext context = this.ruleStack.peek();
        Object bodyResult = null;
        do {
            Object conditionResult;
            boolean bl = executeLoop = (conditionResult = condition.accept(this)) instanceof Boolean && (Boolean)conditionResult != false;
            if (!executeLoop) continue;
            this.tracer.visitWhileBody();
            bodyResult = this.executeRuleBody(stmt, context);
            if (bodyResult == null) {
                executeLoop = false;
            }
            this.tracer.visitedWhileBody();
        } while (executeLoop && !this.stop);
        return bodyResult;
    }

    @Override
    public Object visitForStatement(ForStatement stmt) throws VilException {
        Object result = null;
        try {
            this.environment.pushLevel();
            this.tracer.visitLoop(stmt, this.environment);
            result = this.executeLoop(stmt, false, null);
            this.tracer.visitedLoop(stmt, this.environment);
        }
        catch (ClassCastException e) {
            throw new VilException(e.getMessage(), 70000);
        }
        catch (IndexOutOfBoundsException e) {
            throw new VilException("index out of bounds " + e.getMessage(), 70000);
        }
        this.environment.popLevel();
        return result;
    }

    @Override
    public void register(ITerminatable terminatable) {
        if (terminatable != null) {
            this.terminatables.add(terminatable);
        }
    }

    @Override
    public void unregister(ITerminatable terminatable) {
        if (terminatable != null) {
            this.terminatables.remove(terminatable);
        }
    }

    @Override
    public Object visitCompound(Compound compound) throws VilException {
        return null;
    }
}

