/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.io.Writer;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AlternativeExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ForStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IBuildlangVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.InstantiateExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.LoadProperties;
import net.ssehub.easy.instantiation.core.model.buildlangModel.MapExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.StrategyCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VtlRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.ArtifactMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.BooleanMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.CollectionMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.CompoundMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.PathMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.StringMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.common.WriterVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class BuildlangWriter
extends WriterVisitor<VariableDeclaration>
implements IBuildlangVisitor {
    public BuildlangWriter(Writer out) {
        super(out);
    }

    @Override
    protected boolean endsWithSemicolon(ExpressionStatement statement) {
        return !(statement.getExpression() instanceof AlternativeExpression);
    }

    private void printString(String string) {
        this.print("\"");
        this.print(string);
        this.print("\"");
    }

    @Override
    public Object visitStrategyCallExpression(StrategyCallExpression call) throws VilException {
        if (StrategyCallExpression.Type.EXECUTE == call.getType()) {
            this.print("execute ");
        }
        this.print(call.getName());
        this.printArgumentList(call, 0);
        return null;
    }

    @Override
    public Object visitRuleCallExpression(RuleCallExpression ex) throws VilException {
        if (ex.isSuper()) {
            this.print("super.");
        }
        if (ex.getPrefix() != null) {
            this.print(ex.getPrefix());
            this.print("::");
        }
        this.print(ex.getName());
        this.printArgumentList(ex, 0);
        return null;
    }

    protected String getScriptElementName() {
        return "vilScript";
    }

    protected void printScriptHeader(Script script) throws VilException {
        this.printImports(script);
        this.printVtlRestrictions(script);
        int a = 0;
        while (a < script.getAdviceCount()) {
            script.getAdvice(a).accept(this);
            ++a;
        }
        this.printIndentation();
        this.print(this.getScriptElementName());
        this.printWhitespace();
        this.print(script.getName());
        this.printWhitespace();
        this.printParameterList(script);
        this.printWhitespace();
        if (script.getSuper() != null) {
            this.print("extends ");
            this.print(script.getSuper().getName());
            this.printWhitespace();
        }
    }

    protected boolean hasContainedElements(Script script) {
        return script.getImportsCount() + script.getRuleCount() + script.getVariableDeclarationCount() + script.getPropertiesCount() + BuildlangWriter.o2i(script.getVersion()) > 0;
    }

    protected void printScriptContents(Script script) throws VilException {
        if (script.getVersion() != null) {
            this.printIndentation();
            this.printVersion(script.getVersion());
            this.println();
        }
        if (script.getPropertiesCount() > 0) {
            int l = 0;
            while (l < script.getPropertiesCount()) {
                script.getProperties(l).accept(this);
                ++l;
            }
            this.println();
        }
        if (script.getTypedefCount() > 0) {
            this.printTypedefs(script);
            this.println();
        }
        if (script.getCompoundCount() > 0) {
            this.printCompounds(script);
            this.println();
        }
        if (script.getVariableDeclarationCount() > 0) {
            int implCount = 0;
            int v = 0;
            while (v < script.getVariableDeclarationCount()) {
                VariableDeclaration varDecl = script.getVariableDeclaration(v);
                if (!script.isImplicit(varDecl)) {
                    script.getVariableDeclaration(v).accept(this);
                } else {
                    ++implCount;
                }
                ++v;
            }
            if (implCount != script.getVariableDeclarationCount()) {
                this.println();
            }
        }
        this.printScriptContentsBeforeRules(script);
        if (script.getRuleCount() > 0) {
            int r = 0;
            while (r < script.getRuleCount()) {
                script.getRule(r).accept(this);
                ++r;
            }
            this.println();
        }
    }

    protected void printScriptContentsBeforeRules(Script script) throws VilException {
    }

    protected void printScript(Script script) throws VilException {
        this.printScriptHeader(script);
        this.println('{');
        this.println();
        if (this.hasContainedElements(script)) {
            this.println();
            this.increaseIndentation();
            this.printScriptContents(script);
            this.decreaseIndentation();
        } else {
            this.println();
        }
        this.println('}');
    }

    @Override
    public Object visitScript(Script script) throws VilException {
        this.printScript(script);
        return null;
    }

    private void printImports(Script script) throws VilException {
        if (script.getImportsCount() > 0) {
            int i = 0;
            while (i < script.getImportsCount()) {
                ModelImport imp = script.getImport(i);
                this.printIndentation();
                this.printImportLeadin(imp);
                this.printVersionRestrictions(imp.getVersionRestriction(), false);
                this.println(";");
                ++i;
            }
            this.println();
        }
    }

    private void printVtlRestrictions(Script script) throws VilException {
        if (script.getVtlRestrictionsCount() > 0) {
            int i = 0;
            while (i < script.getVtlRestrictionsCount()) {
                ModelImport<Template> imp = script.getVtlRestriction(i);
                this.printIndentation();
                this.print("requireVTL ");
                this.printString(imp.getName());
                this.printVersionRestrictions(imp.getVersionRestriction(), false);
                this.println(";");
                ++i;
            }
            this.println();
        }
    }

    @Override
    public Object visitLoadProperties(LoadProperties properties) throws VilException {
        this.printIndentation();
        this.print("load properties ");
        this.printString(properties.getPath());
        this.println(";");
        return null;
    }

    @Override
    public Object visitRule(VtlRule rule) throws VilException {
        return null;
    }

    @Override
    public Object visitRule(Rule rule) throws VilException {
        int a = 0;
        while (a < rule.getAnnotationCount()) {
            this.printIndentation();
            this.print("@");
            this.print(rule.getAnnotation(a));
            this.println();
            ++a;
        }
        this.printIndentation();
        if (rule.getName() != null) {
            if (rule.isProtected()) {
                this.print("protected");
                this.printWhitespace();
            }
            if (rule.getDefaultReturnType() != rule.getReturnType()) {
                this.printType((TypeDescriptor<?>)rule.getReturnType());
                this.printWhitespace();
            }
            this.print(rule.getName());
            this.printParameterList(rule);
            this.printWhitespace();
            this.print("=");
            this.printWhitespace();
        }
        this.printRuleConditions(rule, Rule.Side.LHS);
        this.print(": ");
        this.printRuleConditions(rule, Rule.Side.RHS);
        this.printBlock(rule);
        this.println();
        boolean isLast = false;
        Script script = rule.getParent();
        if (script != null) {
            boolean bl = isLast = script.indexOf(rule) + 1 == script.getRuleCount();
        }
        if (!isLast) {
            this.println();
        }
        return null;
    }

    protected void printRuleConditions(Rule rule, Rule.Side side) throws VilException {
        int conditionCount = rule.getRuleConditionCount(side);
        int c = 0;
        while (c < conditionCount) {
            if (c > 0) {
                this.print(", ");
            }
            rule.getRuleCondition(side, c).accept(this);
            ++c;
        }
        int callCount = rule.getRuleCallCount(side);
        int c2 = 0;
        while (c2 < callCount) {
            if (c2 + conditionCount > 0) {
                this.print(", ");
            }
            rule.getRuleCall(side, c2).accept(this);
            ++c2;
        }
        if (conditionCount + callCount > 0) {
            this.print(" ");
        }
    }

    protected void printBlockContents(IRuleBlock block) throws VilException {
        int b = 0;
        while (b < block.getBodyElementCount()) {
            block.getBodyElement(b).accept(this);
            ++b;
        }
    }

    protected void printBlock(IRuleBlock block) throws VilException {
        boolean emitBrackets;
        boolean exprIndent = this.isPrintExpressionStatementIndentation();
        boolean exprNewLine = this.isPrintExpressionStatementNewLine();
        boolean bl = emitBrackets = !block.isVirtual();
        if (emitBrackets) {
            this.println("{");
            this.increaseIndentation();
        } else {
            this.setPrintExpressionStatementIndentation(false);
            this.setPrintExpressionStatementNewLine(false);
        }
        this.printBlockContents(block);
        if (emitBrackets) {
            this.decreaseIndentation();
            this.printIndentation();
            this.print("}");
        } else {
            this.setPrintExpressionStatementIndentation(exprIndent);
            this.setPrintExpressionStatementNewLine(exprNewLine);
        }
    }

    @Override
    public Object visitStringMatchExpression(StringMatchExpression expression) throws VilException {
        this.printString(expression.getText());
        return null;
    }

    @Override
    public Object visitPathMatchExpression(PathMatchExpression expression) throws VilException {
        return expression.getExpression().accept(this);
    }

    @Override
    public Object visitBooleanMatchExpression(BooleanMatchExpression expression) throws VilException {
        return expression.getExpression().accept(this);
    }

    @Override
    public Object visitArtifactMatchExpression(ArtifactMatchExpression expression) throws VilException {
        return expression.getExpression().accept(this);
    }

    @Override
    public Object visitCollectionMatchExpression(CollectionMatchExpression expression) throws VilException {
        return expression.getExpression().accept(this);
    }

    @Override
    public Object visitJoinExpression(JoinExpression ex) throws VilException {
        this.print("join(");
        int i = 0;
        while (i < ex.getVariablesCount()) {
            if (i > 0) {
                this.print(", ");
            }
            ex.getVariable(i).accept(this);
            ++i;
        }
        this.print(")");
        if (ex.getCondition() != null) {
            this.print(" with (");
            ex.getCondition().accept(this);
            this.print(")");
        }
        return null;
    }

    @Override
    public Object visitJoinVariableDeclaration(JoinVariableDeclaration decl) throws VilException {
        if (decl.isExcluded()) {
            this.print("exclude ");
        }
        this.print(decl.getName());
        this.print(":");
        decl.getExpression().accept(this);
        return null;
    }

    @Override
    public Object visitMapExpression(MapExpression map) throws VilException {
        return this.visitLoop(map);
    }

    private Object visitLoop(IEnumeratingLoop loop) throws VilException {
        this.print(loop.getElementName());
        this.print("(");
        int v = 0;
        while (v < loop.getVariablesCount()) {
            TypeDescriptor<?> givenType = loop.getGivenType(v);
            if (givenType != null) {
                this.print(givenType.getVilName());
                this.print(" ");
            }
            if (v > 0) {
                this.print(",");
            }
            this.print(loop.getVariable(v).getName());
            ++v;
        }
        if (loop.isColonSeparator()) {
            this.print(":");
        } else {
            this.print("=");
        }
        loop.getExpression().accept(this);
        this.print(") ");
        this.printBlock(loop);
        return null;
    }

    @Override
    public Object visitInstantiateExpression(InstantiateExpression inst) throws VilException {
        this.print("instantiate ");
        if (inst.getProject() != null) {
            this.print(inst.getProject().getName());
        } else {
            this.printString(inst.getQualifiedName());
        }
        this.print(" ");
        this.printArgumentList(inst, 0);
        this.printVersionRestrictions(inst.getVersionRestriction(), false);
        return null;
    }

    @Override
    public Object visitAlternativeExpression(AlternativeExpression alt) throws VilException {
        this.print("if (");
        alt.getCondition().accept(this);
        this.print(") ");
        this.printBlock(alt.getIfPart());
        if (alt.getElsePart() != null) {
            this.print(" else ");
            this.printBlock(alt.getElsePart());
        }
        this.println();
        return null;
    }

    @Override
    public Object visitCompoundMatchExpression(CompoundMatchExpression expression) throws VilException {
        return expression.getCompositeExpression().accept(this);
    }

    @Override
    public Object visitWhileStatement(WhileStatement stmt) throws VilException {
        this.printIndentation();
        this.print("while(");
        stmt.getCondition().accept(this);
        this.print(") ");
        this.printBlock(stmt);
        this.println(";");
        return null;
    }

    @Override
    public Object visitForStatement(ForStatement stmt) throws VilException {
        this.printIndentation();
        this.visitLoop(stmt);
        this.println(";");
        return null;
    }
}

