/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangExecution;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;

class ExecutableRules {
    private List<AbstractRule> rules = new ArrayList<AbstractRule>();

    public void collect(Script script) {
        HashSet<Script> processed = new HashSet<Script>();
        HashSet<String> knownSignatures = new HashSet<String>();
        this.collect(script, false, processed, knownSignatures);
    }

    private void collect(Script script, boolean asParent, Set<Script> processed, Set<String> knownSignatures) {
        if (!processed.contains(script)) {
            processed.add(script);
            if (script.getParent() != null) {
                this.collect(script.getParent(), true, processed, knownSignatures);
            }
            int i = 0;
            while (i < script.getImportsCount()) {
                Script imp = (Script)script.getImport(i).getResolved();
                if (imp != null) {
                    this.collect(imp, false, processed, knownSignatures);
                }
                ++i;
            }
            int r = 0;
            while (r < script.getRuleCount()) {
                AbstractRule rule = script.getRule(r);
                String signature = rule.getSignature();
                if (!asParent || !knownSignatures.contains(signature)) {
                    knownSignatures.add(signature);
                    this.rules.add(rule);
                }
                ++r;
            }
        }
    }

    public Object buildContributing(AbstractRuleMatchExpression expression, BuildlangExecution visitor) throws VilException {
        ArrayList<AbstractRule> contributing = new ArrayList<AbstractRule>();
        int r = 0;
        while (r < this.rules.size()) {
            AbstractRule candidate = this.rules.get(r);
            if (!visitor.isOnStack(candidate)) {
                try {
                    visitor.resolveMatches(candidate, Rule.Side.LHS);
                }
                catch (VilException vilException) {
                    // empty catch block
                }
                int c = 0;
                while (c < candidate.getRuleConditionCount(Rule.Side.LHS)) {
                    AbstractRuleMatchExpression lhsEx = candidate.getRuleCondition(Rule.Side.LHS, c);
                    if (lhsEx.contributesTo(expression)) {
                        contributing.add(candidate);
                    }
                    ++c;
                }
            }
            ++r;
        }
        int c = 0;
        while (c < contributing.size()) {
            ((AbstractRule)contributing.get(c)).accept(visitor);
            ++c;
        }
        Object value = expression.accept(visitor);
        assert (expression.inferType().isCollection());
        return value;
    }
}

