/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Utils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class MapExpression
extends Expression
implements IRuleBlock,
IEnumeratingLoop {
    private VariableDeclaration[] variables;
    private Expression expr;
    private IRuleElement[] body;
    private TypeDescriptor<?> type;
    private TypeDescriptor<?>[] givenTypes;
    private boolean colon;

    MapExpression() {
    }

    public MapExpression(VariableDeclaration[] variables, Expression expr, IRuleElement[] body, TypeDescriptor<?>[] givenTypes, boolean colon) throws VilException {
        if (variables == null || variables.length < 1) {
            throw new VilException("no iterator variables given", 70001);
        }
        if (givenTypes != null && variables.length != givenTypes.length) {
            throw new VilException("given types length does not match to variables length", 70001);
        }
        this.variables = variables;
        this.colon = colon;
        if (expr == null) {
            throw new VilException("no expression given", 70001);
        }
        this.expr = expr;
        this.body = body;
        this.givenTypes = givenTypes;
        this.colon = colon;
    }

    @Override
    public int getBodyElementCount() {
        return this.body == null ? 0 : this.body.length;
    }

    @Override
    public IRuleElement getBodyElement(int index) {
        if (this.body == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.body[index];
    }

    @Override
    public int getVariablesCount() {
        return this.variables.length;
    }

    @Override
    public VariableDeclaration getVariable(int index) {
        return this.variables[index];
    }

    @Override
    public TypeDescriptor<?> getGivenType(int index) {
        return this.givenTypes == null ? null : this.givenTypes[index];
    }

    @Override
    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitMapExpression(this) : visitor.visitExpression(this);
        return result;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (this.type == null) {
            Expression expr = Utils.findLastExpression(this);
            if (expr == null) {
                this.type = TypeRegistry.voidType();
            } else {
                TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
                param[0] = expr.inferType();
                this.type = TypeRegistry.getSequenceType(param);
            }
        }
        return this.type;
    }

    @Override
    public IRuleElement determinesResult() {
        return Utils.findLastExpressionStatement(this);
    }

    @Override
    public boolean isColonSeparator() {
        return this.colon;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public void addBodyElement(int index, IRuleElement elt) {
        this.body = RuleBlock.addBodyElement(this.body, index, elt);
    }

    @Override
    public String getElementName() {
        return "map";
    }

    @Override
    public boolean returnActualValue() {
        return false;
    }
}

