/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleDescriptorException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.MatchFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class RuleDescriptor {
    public static final String MATCH_VAR_POSTFIX = "MATCH";
    private AbstractRuleMatchExpression[] lhsRuleMatches;
    private RuleCallExpression[] lhsRuleCalls;
    private AbstractRuleMatchExpression[] rhsRuleMatches;
    private RuleCallExpression[] rhsRuleCalls;
    private VariableDeclaration[] lhsVariables;
    private VariableDeclaration[] rhsVariables;
    private VariableDeclaration[] lhsMatchVariables;
    private VariableDeclaration[] rhsMatchVariables;
    private TypeDescriptor<?> returnType;

    public void setRuleExpressions(Rule.Side side, List<Expression> conditions) throws RuleDescriptorException {
        AbstractRuleMatchExpression[] matches = null;
        RuleCallExpression[] calls = null;
        if (conditions != null) {
            ArrayList<AbstractRuleMatchExpression> matchTmp = new ArrayList<AbstractRuleMatchExpression>();
            ArrayList<RuleCallExpression> callsTmp = new ArrayList<RuleCallExpression>();
            int c = 0;
            while (c < conditions.size()) {
                block11: {
                    Expression expr = conditions.get(c);
                    try {
                        AbstractRuleMatchExpression matchExpr = MatchFactory.INSTANCE.create(expr);
                        if (matchExpr != null) {
                            matchTmp.add(matchExpr);
                            if (!callsTmp.isEmpty()) {
                                throw new RuleDescriptorException("conditions must not be mixed with calls", c);
                            }
                            break block11;
                        }
                        if (expr instanceof RuleCallExpression) {
                            callsTmp.add((RuleCallExpression)expr);
                            break block11;
                        }
                        throw new RuleDescriptorException("unrecongnized expression of type " + expr.inferType().getVilName(), c);
                    }
                    catch (VilException e) {
                        throw new RuleDescriptorException(e, c);
                    }
                }
                ++c;
            }
            if (!matchTmp.isEmpty()) {
                matches = new AbstractRuleMatchExpression[matchTmp.size()];
                matchTmp.toArray(matches);
            }
            if (!callsTmp.isEmpty()) {
                calls = new RuleCallExpression[callsTmp.size()];
                callsTmp.toArray(calls);
            }
        }
        if (Rule.Side.LHS == side) {
            this.lhsRuleMatches = matches;
            this.lhsRuleCalls = calls;
        } else {
            this.rhsRuleMatches = matches;
            this.rhsRuleCalls = calls;
        }
    }

    public AbstractRuleMatchExpression[] getRuleMatches(Rule.Side side) {
        AbstractRuleMatchExpression[] result = Rule.Side.LHS == side ? this.lhsRuleMatches : this.rhsRuleMatches;
        return result;
    }

    public int getRuleMatchCount(Rule.Side side) {
        AbstractRuleMatchExpression[] calls = this.getRuleMatches(side);
        return calls == null ? 0 : calls.length;
    }

    public RuleCallExpression[] getRuleCalls(Rule.Side side) {
        RuleCallExpression[] result = Rule.Side.LHS == side ? this.lhsRuleCalls : this.rhsRuleCalls;
        return result;
    }

    public int getRuleCallCount(Rule.Side side) {
        RuleCallExpression[] calls = this.getRuleCalls(side);
        return calls == null ? 0 : calls.length;
    }

    public void registerVariables(Resolver resolver) throws VilException {
        HashMap<String, Integer> known = new HashMap<String, Integer>();
        this.registerVariables(Rule.Side.LHS, resolver, known);
        this.registerVariables(Rule.Side.RHS, resolver, known);
    }

    private void registerVariables(Rule.Side side, Resolver res, Map<String, Integer> names) throws VilException {
        RuleCallExpression[] calls;
        String predefined = Rule.Side.LHS == side ? "LHS" : "RHS";
        String predefinedAlias = Rule.Side.LHS == side ? "TO" : "FROM";
        ArrayList<VariableDeclaration> vars = null;
        ArrayList<VariableDeclaration> matchVars = null;
        AbstractRuleMatchExpression[] matches = this.getRuleMatches(side);
        if (matches != null) {
            vars = new ArrayList<VariableDeclaration>();
            if (Rule.Side.RHS == side) {
                matchVars = new ArrayList<VariableDeclaration>();
            }
            int m = 0;
            while (m < matches.length) {
                Object name = predefined;
                Object nameAlias = predefinedAlias;
                if (m > 0) {
                    name = (String)name + m;
                    nameAlias = (String)nameAlias + m;
                }
                if (Rule.Side.RHS == side) {
                    VariableDeclaration matchDecl = new VariableDeclaration((String)name + MATCH_VAR_POSTFIX, matches[m].inferType());
                    matchVars.add(matchDecl);
                    res.add(matchDecl);
                    res.addAlias((String)nameAlias + "_MATCH", matchDecl);
                }
                VariableDeclaration varDecl = new VariableDeclaration((String)name, matches[m].getEntryType());
                vars.add(varDecl);
                res.add(varDecl);
                res.addAlias((String)nameAlias, varDecl);
                ++m;
            }
        }
        if ((calls = this.getRuleCalls(side)) != null) {
            if (vars == null) {
                vars = new ArrayList();
            }
            int c = 0;
            while (c < calls.length) {
                RuleCallExpression call = calls[c];
                Object name = call.getName();
                if (!names.containsKey(name)) {
                    names.put((String)name, 1);
                } else {
                    int count = names.get(name) + 1;
                    names.put((String)name, count);
                    name = (String)name + count;
                }
                VariableDeclaration varDecl = new VariableDeclaration((String)name, call.inferType());
                vars.add(varDecl);
                res.add(varDecl);
                ++c;
            }
        }
        VariableDeclaration[] result = RuleDescriptor.toArray(vars);
        VariableDeclaration[] matchResult = RuleDescriptor.toArray(matchVars);
        if (Rule.Side.LHS == side) {
            this.lhsVariables = result;
            this.lhsMatchVariables = matchResult;
        } else {
            this.rhsVariables = result;
            this.rhsMatchVariables = matchResult;
        }
    }

    private static VariableDeclaration[] toArray(List<VariableDeclaration> vars) {
        VariableDeclaration[] result;
        if (vars != null && !vars.isEmpty()) {
            result = new VariableDeclaration[vars.size()];
            vars.toArray(result);
        } else {
            result = null;
        }
        return result;
    }

    public VariableDeclaration[] getVariables(Rule.Side side) {
        VariableDeclaration[] result = Rule.Side.LHS == side ? this.lhsVariables : this.rhsVariables;
        return result;
    }

    public VariableDeclaration[] getMatchVariables(Rule.Side side) {
        VariableDeclaration[] result = Rule.Side.LHS == side ? this.lhsMatchVariables : this.rhsMatchVariables;
        return result;
    }

    public void setReturnType(TypeDescriptor<?> returnType) {
        this.returnType = returnType;
    }

    public TypeDescriptor<?> getReturnType() {
        return this.returnType;
    }
}

