/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IBuildlangElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Imports;
import net.ssehub.easy.instantiation.core.model.buildlangModel.LoadProperties;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleDescriptor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.AbstractResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaField;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;

public class Script
extends AbstractResolvableModel<VariableDeclaration, Script>
implements IBuildlangElement,
IResolvableModel<VariableDeclaration, Script>,
IVariableDeclarationReceiver<VariableDeclaration> {
    public static final String DEFAULT_START_RULE_NAME = "main";
    public static final String NAME_OTHERPROJECTS = "OTHERPROJECTS";
    public static final String NAME_SCRIPTDIR = "SCRIPTDIR";
    private static final Set<String> IMPLICIT_VARS = new HashSet<String>();
    private String name;
    private Version version;
    private ModelImport<Script> parent;
    private VariableDeclaration[] parameters;
    private Map<String, VariableDeclaration> namedParams;
    private List<VariableDeclaration> declarations;
    private List<AbstractRule> rules;
    private List<LoadProperties> loadProperties;
    private long timestamp = System.currentTimeMillis();

    static {
        IMPLICIT_VARS.add(NAME_OTHERPROJECTS);
        IMPLICIT_VARS.add(NAME_SCRIPTDIR);
    }

    Script() {
        this(null, null, null, null);
    }

    public Script(String name) {
        this(name, TypeRegistry.DEFAULT);
    }

    public Script(String name, TypeRegistry registry) {
        this(name, null, null, registry);
    }

    public Script(String name, VariableDeclaration[] parameters) {
        this(name, parameters, TypeRegistry.DEFAULT);
    }

    public Script(String name, VariableDeclaration[] parameters, TypeRegistry registry) {
        this(name, null, new ScriptDescriptor<Script>(parameters, null, null), registry);
    }

    public Script(String name, ModelImport<Script> parent, ScriptDescriptor<Script> descriptor, TypeRegistry registry) {
        super(descriptor == null ? null : descriptor.imports, registry, descriptor == null ? null : descriptor.advices);
        this.name = name;
        this.parent = parent;
        this.version = null;
        this.loadProperties = new ArrayList<LoadProperties>();
        this.declarations = new ArrayList<VariableDeclaration>();
        this.rules = new ArrayList<AbstractRule>();
        this.parameters = descriptor == null ? null : descriptor.parameters;
        this.namedParams = VariableDeclaration.mapDefaultedParameters(this.namedParams, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.parameters);
        this.createImplicitVariables();
        this.adjustParents();
    }

    private void adjustParents() {
        int r = 0;
        while (r < this.rules.size()) {
            this.rules.get(r).setParent(this);
            ++r;
        }
        int p = 0;
        while (p < this.getParameterCount()) {
            this.getParameter(p).setParent(this);
            ++p;
        }
        int d = 0;
        while (d < this.getVariableDeclarationCount()) {
            this.getVariableDeclaration(d).setParent(this);
            ++d;
        }
    }

    @Override
    protected net.ssehub.easy.instantiation.core.model.common.Imports<Script> createImports() {
        return new Imports<Script>(null, null);
    }

    public static VariableDeclaration[] createDefaultParameter() {
        VariableDeclaration[] param = new VariableDeclaration[]{new VariableDeclaration("source", IvmlTypes.projectType()), new VariableDeclaration("config", IvmlTypes.configurationType()), new VariableDeclaration("target", IvmlTypes.projectType())};
        return param;
    }

    protected void createImplicitVariables() {
        try {
            TypeDescriptor<?>[] tmp = TypeDescriptor.createArray(1);
            tmp[0] = IvmlTypes.projectType();
            this.declarations.add(new VariableDeclaration(NAME_OTHERPROJECTS, TypeRegistry.getSetType(tmp)));
            this.declarations.add(new VariableDeclaration(NAME_SCRIPTDIR, TypeRegistry.stringType()));
        }
        catch (VilException e) {
            EASyLoggerFactory.INSTANCE.getLogger(Script.class, "net.ssehub.easy.instantiation.core").exception((Exception)((Object)e));
        }
    }

    @Override
    public boolean isImplicit(VariableDeclaration decl) {
        return decl != null && IMPLICIT_VARS.contains(decl.getName());
    }

    @Override
    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    @Override
    public VariableDeclaration getParameter(int index) {
        if (this.parameters == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.parameters[index];
    }

    @Override
    public int getRequiredParameterCount() {
        return VariableDeclaration.getRequiredParameterCount(this.namedParams, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.parameters);
    }

    @Override
    public VariableDeclaration getParameter(String name) {
        return (VariableDeclaration)VariableDeclaration.getParameter(this.namedParams, (String)name, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.parameters);
    }

    public void addLoadProperties(LoadProperties propFile) {
        this.loadProperties.add(propFile);
    }

    public void addRule(AbstractRule rule) {
        this.rules.add(rule);
        rule.setParent(this);
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule);
    }

    @Override
    public void addVariableDeclaration(VariableDeclaration varDecl) {
        this.declarations.add(varDecl);
        varDecl.setParent(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public Script getParent() {
        Script result = this.parent == null ? null : (Script)this.parent.getResolved();
        return result;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public AbstractRule getRule(int index) {
        return this.rules.get(index);
    }

    public int indexOf(Rule rule) {
        return this.rules.indexOf(rule);
    }

    public VariableDeclaration getVariableDeclaration(String name) {
        VariableDeclaration result = null;
        int d = 0;
        while (result == null && d < this.declarations.size()) {
            VariableDeclaration decl = this.declarations.get(d);
            if (decl.getName().equals(name)) {
                result = decl;
            }
            ++d;
        }
        return result;
    }

    @Override
    public int getVariableDeclarationCount() {
        return this.declarations.size();
    }

    @Override
    public VariableDeclaration getVariableDeclaration(int index) {
        return this.declarations.get(index);
    }

    public int getPropertiesCount() {
        return this.loadProperties.size();
    }

    public LoadProperties getProperties(int index) {
        return this.loadProperties.get(index);
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitScript(this);
    }

    @Override
    public int getOperationsCount() {
        return this.rules.size();
    }

    @Override
    public IMetaOperation getOperation(int index) {
        return this.rules.get(index);
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        boolean assignable = false;
        if (type instanceof Script) {
            Script iter = (Script)type;
            while (iter != null && !assignable) {
                Script parent = iter.parent == null ? null : (Script)iter.parent.getResolved();
                assignable = parent == this;
                iter = parent;
            }
        }
        return assignable;
    }

    @Override
    public IMetaOperation findConversion(IMetaType sourceType, IMetaType targetType) {
        return null;
    }

    public ModelImport<Script> getSuper() {
        return this.parent;
    }

    @Override
    public int getExtensionTypesCount() {
        return 0;
    }

    @Override
    public IMetaType getExtensionType(int index) {
        throw new IndexOutOfBoundsException();
    }

    public IndentationConfiguration getIndentationConfiguration() {
        return null;
    }

    public AbstractRule determineStartRule(String startRuleName) throws VilException {
        AbstractRule startRule = null;
        ArrayList<AbstractRule> roots = new ArrayList<AbstractRule>();
        this.collectRoots(new HashSet<Script>(), new HashSet<String>(), roots);
        if (roots.isEmpty()) {
            throw new VilException("no rule (without dependencies) to be executed", 50003);
        }
        if (1 == roots.size() && startRuleName == null) {
            startRule = (AbstractRule)roots.get(0);
        } else {
            if (startRuleName == null) {
                StringBuilder tmp = new StringBuilder();
                int r = 0;
                while (r < roots.size()) {
                    if (r > 0) {
                        tmp.append(", ");
                    }
                    tmp.append(((AbstractRule)roots.get(r)).getJavaSignature());
                    ++r;
                }
                throw new VilException("multiple possible start rules (" + String.valueOf(tmp) + ") but no start rule name specified", 50003);
            }
            int count = 0;
            int r = 0;
            while (r < roots.size()) {
                AbstractRule rule = (AbstractRule)roots.get(r);
                if (rule.getName().equals(startRuleName)) {
                    startRule = rule;
                    ++count;
                }
                ++r;
            }
            if (count == 0) {
                throw new VilException("no matching start rule found (check parameter, protected)", 50003);
            }
            if (count > 1) {
                throw new VilException("ambiguous matching start rules", 50003);
            }
        }
        return startRule;
    }

    private void collectRoots(Set<Script> processed, Set<String> knownSignatures, List<AbstractRule> roots) {
        if (!processed.contains(this)) {
            processed.add(this);
            HashSet<AbstractRule> candidates = new HashSet<AbstractRule>();
            HashSet<AbstractRule> resolved = new HashSet<AbstractRule>();
            int r = 0;
            while (r < this.getRuleCount()) {
                AbstractRule rule = this.getRule(r);
                if (!rule.isProtected()) {
                    candidates.add(rule);
                }
                ++r;
            }
            int lastResolvedSize = resolved.size();
            do {
                Iterator iter = candidates.iterator();
                while (iter.hasNext()) {
                    AbstractRule rule = (AbstractRule)iter.next();
                    boolean allResolved = true;
                    int p = 0;
                    while (allResolved && p < rule.getRuleCallCount(Rule.Side.RHS)) {
                        RuleCallExpression call = rule.getRuleCall(Rule.Side.RHS, p);
                        allResolved &= resolved.contains(call.getResolved()) || call.isSuper();
                        ++p;
                    }
                    if (!allResolved) continue;
                    resolved.add(rule);
                    iter.remove();
                }
            } while (!candidates.isEmpty() && resolved.size() != lastResolvedSize);
            if (candidates.isEmpty()) {
                candidates = resolved;
            }
            roots.addAll(candidates);
        }
    }

    File getContainingFolder() {
        File result;
        ModelInfo info = BuildModel.INSTANCE.availableModels().getModelInfo((IModel)this);
        if (info != null && info.getLocation() != null) {
            URI location = info.getLocation();
            result = new File(location);
            if (result.isFile()) {
                result = result.getParentFile();
            }
        } else {
            result = null;
        }
        return result;
    }

    public AbstractRule getMainRule(boolean createIfAbsent) {
        return this.getMainRule(DEFAULT_START_RULE_NAME, createIfAbsent);
    }

    public AbstractRule getMainRule(String name, boolean createIfAbsent) {
        AbstractRule main = null;
        int r = 0;
        while (main == null && r < this.getRuleCount()) {
            AbstractRule rule = this.getRule(r);
            if (rule.getName().equals(name)) {
                boolean ok = rule.getParameterCount() == this.getParameterCount();
                int p = 0;
                while (ok && p < this.getParameterCount()) {
                    ok = this.getParameter(p).getType().isAssignableFrom(((VariableDeclaration)rule.getParameter(p)).getType());
                    ++p;
                }
                if (ok) {
                    main = rule;
                }
            }
            ++r;
        }
        if (main == null && createIfAbsent) {
            VariableDeclaration[] param = new VariableDeclaration[this.getParameterCount()];
            int p = 0;
            while (p < param.length) {
                VariableDeclaration sParam = this.getParameter(p);
                param[p] = new VariableDeclaration(sParam.getName(), sParam.getType());
                ++p;
            }
            main = new Rule(name, false, param, new RuleDescriptor(), this);
            this.rules.add(main);
        }
        return main;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean enableDynamicDispatch() {
        return true;
    }

    @Override
    protected Imports<Script> getImports() {
        return (Imports)super.getImports();
    }

    public int getVtlRestrictionsCount() {
        net.ssehub.easy.instantiation.core.model.common.Imports imp = this.getImports();
        return imp == null ? 0 : ((Imports)imp).getVtlRestrictionsCount();
    }

    public ModelImport<Template> getVtlRestriction(int index) {
        net.ssehub.easy.instantiation.core.model.common.Imports imp = this.getImports();
        if (imp == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((Imports)imp).getVtlRestriction(index);
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public IMetaOperation addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return false;
    }

    @Override
    protected void reload() {
        BuildModel.INSTANCE.reload(this);
    }

    public IRestrictionEvaluationContext getRestrictionEvaluationContext() {
        return new RuntimeEnvironment();
    }

    @Override
    public IMetaType getBaseType() {
        return null;
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public IMetaField getField(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public IMetaType getSuperType() {
        return this.parent != null ? (IMetaType)this.parent.getResolved() : null;
    }

    @Override
    public int getGenericParameterCount() {
        return 0;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }

    @Override
    public List<IMetaOperation> getCandidates(String name, int unnamedArgsCount) {
        return TypeDescriptor.getCandidates(this, name, unnamedArgsCount);
    }

    public String getLanguageName() {
        return "VIL";
    }

    public long getLastModification() {
        return this.timestamp;
    }

    public static class ScriptDescriptor<S extends Script> {
        private VariableDeclaration[] parameters;
        private Advice[] advices;
        private Imports<S> imports;

        public ScriptDescriptor(VariableDeclaration[] parameters, Advice[] advices, Imports<S> imports) {
            this.parameters = parameters;
            this.advices = advices;
            this.imports = imports;
        }

        public VariableDeclaration[] getParameters() {
            return this.parameters;
        }

        public Advice[] getAdvices() {
            return this.advices;
        }

        public Imports<S> getImports() {
            return this.imports;
        }
    }
}

