/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelListener;
import net.ssehub.easy.basics.modelManagement.ModelEvents;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ICompoundReceiver;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.ITypedefReceiver;
import net.ssehub.easy.instantiation.core.model.common.Imports;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public abstract class AbstractResolvableModel<V extends IMetaParameterDeclaration, M extends IModel>
implements IResolvableModel<V, M>,
IModelListener<Project>,
ITypedefReceiver,
ICompoundReceiver {
    private transient boolean dirty = false;
    private Imports<M> imports;
    private TypeRegistry registry;
    private Advice[] advices;
    private List<Typedef> typedefs;
    private List<Compound> compounds;

    protected AbstractResolvableModel(Imports<M> imports, TypeRegistry registry, Advice[] advices) {
        this.imports = imports;
        this.registry = registry;
        this.advices = advices;
        this.processModelListeners(true);
    }

    private void processModelListeners(boolean add) {
        if (this.advices != null) {
            ModelEvents events = VarModel.INSTANCE.events();
            int a = 0;
            while (a < this.advices.length) {
                Project resolved = this.advices[a].getResolved();
                if (resolved != null) {
                    if (add) {
                        events.addModelListener((IModel)resolved, (IModelListener)this);
                        EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Added model listener to " + resolved.getName() + " " + System.identityHashCode(resolved) + " from " + this.getName() + " " + System.identityHashCode(this));
                    } else {
                        events.removeModelListener((IModel)resolved, (IModelListener)this);
                        EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Removed model listener to " + resolved.getName() + " " + System.identityHashCode(resolved) + " from " + this.getName() + " " + System.identityHashCode(this));
                    }
                }
                ++a;
            }
        }
    }

    public int getImportsCount() {
        return this.imports == null ? 0 : this.imports.getImportsCount();
    }

    public ModelImport<M> getImport(int index) {
        if (this.imports == null) {
            throw new IllegalArgumentException();
        }
        return this.imports.getImport(index);
    }

    protected Imports<M> createImports() {
        return new Imports(null);
    }

    public void addImport(ModelImport<M> imp) {
        if (this.imports == null) {
            this.imports = this.createImports();
        }
        this.imports.add(imp);
    }

    @Override
    public void addRuntimeImport(ModelImport<M> imp) {
        this.addImport(imp);
    }

    protected Imports<M> getImports() {
        return this.imports;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    public int getAdviceCount() {
        return this.advices == null ? 0 : this.advices.length;
    }

    public Advice getAdvice(int index) {
        if (this.advices == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.advices[index];
    }

    @Override
    public int getTypedefCount() {
        return this.typedefs == null ? 0 : this.typedefs.size();
    }

    @Override
    public Typedef getTypedef(int index) {
        if (this.typedefs == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.typedefs.get(index);
    }

    @Override
    public void addTypedef(Typedef typedef) {
        if (this.typedefs == null) {
            this.typedefs = new ArrayList<Typedef>();
        }
        this.typedefs.add(typedef);
    }

    @Override
    public Typedef getTypedef(String name) {
        Typedef result = null;
        int t = 0;
        int n = this.getTypedefCount();
        while (result == null && t < n) {
            Typedef td = this.getTypedef(t);
            if (td.getName().equals(name)) {
                result = td;
            }
            ++t;
        }
        return result;
    }

    @Override
    public void addCompound(Compound compound) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<Compound>();
        }
        this.compounds.add(compound);
    }

    @Override
    public Compound getCompound(String name) {
        Compound result = null;
        int c = 0;
        int n = this.getCompoundCount();
        while (result == null && c < n) {
            Compound cmp = this.getCompound(c);
            if (cmp.getName().equals(name)) {
                result = cmp;
            }
            ++c;
        }
        return result;
    }

    @Override
    public int getCompoundCount() {
        return this.compounds == null ? 0 : this.compounds.size();
    }

    @Override
    public Compound getCompound(int index) {
        if (this.compounds == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.compounds.get(index);
    }

    public void dispose() {
        this.processModelListeners(false);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void notifyReplaced(Project oldModel, Project newModel) {
        if (newModel != null) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Model " + this.getName() + " " + System.identityHashCode(this) + " became dirty as " + newModel.getName() + " was changed.");
        }
        this.dirty = true;
    }

    @Override
    public Object getIvmlElement(String name) {
        Object result = null;
        int a = 0;
        while (result == null && a < this.getAdviceCount()) {
            result = this.getAdvice(a).getIvmlElement(name);
            ++a;
        }
        return result;
    }

    protected abstract void reload();
}

