/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.Bundle;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.common.DummyModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypedModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilGenericType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.NullValue;

public abstract class RuntimeEnvironment<V extends VariableDeclaration, M extends IModel>
implements IRuntimeEnvironment,
IRestrictionEvaluationContext {
    private Map<IModel, Context<V, M>> contexts = new HashMap<IModel, Context<V, M>>();
    private Context<V, M> currentContext;
    private IResolvableModel<V, M> mostSpecificModel;
    private TypeRegistry typeRegistry;
    private Class<V> cls;
    private Set<IArtifact> noAutoStore = new HashSet<IArtifact>();
    private Supplier<String> modelNameSupplier = new Supplier<String>(){

        @Override
        public String get() {
            String modelName = null;
            if (RuntimeEnvironment.this.currentContext != null && RuntimeEnvironment.this.currentContext.getModel() != null && RuntimeEnvironment.this.contexts.size() > 0) {
                modelName = RuntimeEnvironment.this.currentContext.getModel().getName();
            }
            return modelName;
        }
    };

    public RuntimeEnvironment(Class<V> cls) {
        this.cls = cls;
        this.typeRegistry = TypeRegistry.DEFAULT;
    }

    public RuntimeEnvironment(Class<V> cls, TypeRegistry typeRegistry) {
        this.cls = cls;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    Context<V, M> findInheritedContext(IResolvableModel<V, M> model) {
        Context<V, M> result = null;
        for (Context<V, M> ctx : this.contexts.values()) {
            IResolvableModel<V, M> ctxModel = ctx.getModel();
            if (!model.isAssignableFrom(ctxModel)) continue;
            result = ctx;
            break;
        }
        return result;
    }

    public IResolvableModel<V, M> switchContext(IResolvableModel<V, M> model) {
        Context<V, M> oldC = this.currentContext;
        IResolvableModel<V, M> oldContext = this.currentContext != null ? this.currentContext.getModel() : null;
        TypeRegistry tmp = model.getTypeRegistry();
        if (tmp != null) {
            this.typeRegistry = tmp;
        }
        this.currentContext = this.contexts.get(model);
        if (this.currentContext == null) {
            this.currentContext = new Context<V, M>(model, this.findInheritedContext(model));
            this.contexts.put(model, this.currentContext);
            if (this.contexts.size() > 1) {
                this.currentContext.increaseIndentation();
            }
        } else if (oldC != null) {
            this.currentContext.setIndentation(oldC.getIndentation());
        }
        if (oldContext != null && this.currentContext.getModel().isAssignableFrom(oldContext)) {
            this.mostSpecificModel = oldContext;
            this.currentContext.setMostSpecificModel(oldContext);
        } else if (this.mostSpecificModel == null || oldContext != this.currentContext.getModel()) {
            this.mostSpecificModel = this.currentContext.getMostSpecificModel();
        }
        return oldContext;
    }

    public void deleteContext(ITypedModel model) {
        Context<V, M> context = this.contexts.get(model);
        if (context != this.currentContext) {
            this.contexts.remove(model);
        }
    }

    public void setContextPaths(List<File> paths) {
        if (this.currentContext != null) {
            String[] tmp = null;
            if (paths != null) {
                tmp = new String[paths.size()];
                int i = 0;
                while (i < tmp.length) {
                    tmp[i] = paths.get(i).getAbsolutePath();
                    ++i;
                }
            }
            this.currentContext.paths = tmp;
        }
    }

    @Override
    public String[] getContextPaths() {
        String[] result = null;
        if (this.currentContext != null) {
            result = this.currentContext.paths;
        }
        return result;
    }

    public IResolvableModel<?, M> getContextModel() {
        IResolvableModel<V, M> model = this.currentContext == null ? null : this.currentContext.getModel();
        return model;
    }

    public IResolvableModel<?, M> getMostSpecificContextModel() {
        return this.mostSpecificModel;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getValue(IResolvable resolvable) throws VilException {
        block6: {
            result = null;
            try {
                result = this.currentContext.getValue(resolvable);
                break block6;
            }
            catch (VilException e) {
                found = false;
                ** for (ctx : this.contexts.values())
            }
lbl-1000:
            // 1 sources

            {
                if (ctx == this.currentContext) continue;
                try {
                    result = ctx.getValue(resolvable);
                    found = true;
                    if (result == null) continue;
                    break;
                }
                catch (VilException var7_7) {
                    // empty catch block
                }
                continue;
            }
lbl17:
            // 2 sources

            if (!found) {
                throw e;
            }
        }
        return result;
    }

    public Object getValue(IResolvableModel<V, M> contextModel, String name) throws VilException {
        Context<V, M> context = this.contexts.get(contextModel);
        if (context == null) {
            throw new VilException("No such context", 30008);
        }
        V varDecl = context.get(name);
        if (varDecl == null) {
            throw new VilException("variable " + name + " is not defined", 50000);
        }
        return context.getValue((IResolvable)varDecl);
    }

    public Object getValue(V var) throws VilException {
        return this.getValue((IResolvable)var);
    }

    @Override
    public void storeArtifacts(boolean force) throws VilException {
        this.currentContext.storeArtifacts(force);
    }

    public V get(String name) {
        return this.currentContext.get(name);
    }

    public boolean isDefined(V var) {
        return this.currentContext.isDefined(var);
    }

    @Override
    public void setValue(IResolvable var, Object object) throws VilException {
        if (this.cls.isInstance(var)) {
            this.setValue((V)((VariableDeclaration)this.cls.cast(var)), object);
        }
    }

    public void setValue(V var, Object object) throws VilException {
        object = this.checkType(var, object);
        this.currentContext.setValue(var, object);
    }

    private static Object checkInitialCollectionValue(TypeDescriptor<?> type, Object object) {
        if ((type.isSet() || type.isSequence()) && object instanceof Collection) {
            Collection coll = (Collection)object;
            if (coll.isEmpty() && type.getGenericParameterCount() > 0 && !type.isSame(coll.getType())) {
                object = type.isSet() ? new ListSet(new ArrayList(), type.getGenericParameter()) : new ListSequence(new ArrayList(), type.getGenericParameter());
            }
        } else if (type.isMap() && object instanceof Sequence) {
            try {
                object = net.ssehub.easy.instantiation.core.model.vilTypes.Map.convert((Sequence)object);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return object;
    }

    public void pushLevel() {
        this.currentContext.pushLevel();
    }

    public void popLevel() throws VilException {
        this.currentContext.popLevel();
    }

    public void addValue(V var, Object object) throws VilException {
        this.addValue(var, object, false);
    }

    public void addValue(V var, Object object, boolean modelVar) throws VilException {
        object = this.checkType(var, object);
        Context<Object, Object> context = this.currentContext;
        if (modelVar) {
            boolean isDefined = false;
            while (context.parent != null) {
                context = context.parent;
                isDefined |= context.isDefined(var);
            }
            if (isDefined) {
                context = this.currentContext;
            }
        }
        context.addValue(var, object);
    }

    public void removeValue(V var) {
        this.currentContext.removeValue(var);
    }

    private Object checkType(V var, Object object) throws VilException {
        return RuntimeEnvironment.checkType(((VariableDeclaration)var).getName(), ((VariableDeclaration)var).getType(), object, this.getTypeRegistry(), this.modelNameSupplier);
    }

    public static Object checkType(String name, TypeDescriptor<?> type, Object object, TypeRegistry registry, Supplier<String> modelName) throws VilException {
        object = type instanceof IActualValueProvider ? ((IActualValueProvider)((Object)type)).determineActualValue(object) : RuntimeEnvironment.checkInitialCollectionValue(type, object);
        if (NullValue.INSTANCE == object || NullValue.VALUE == object) {
            object = null;
        }
        if (object != null) {
            boolean compatible = type.isInstance(object);
            if (!compatible) {
                TypeDescriptor<?> td;
                IDatatype dType;
                if (object instanceof DecisionVariable) {
                    DecisionVariable decVar = (DecisionVariable)object;
                    dType = decVar.getActualType();
                    td = registry.getType(dType = DerivedDatatype.resolveToBasis((IDatatype)Reference.dereference((IDatatype)dType)));
                    if (td != null) {
                        compatible = type.isAssignableFrom(td);
                    }
                    if (compatible) {
                        object = RuntimeEnvironment.evaluatePrimitives(object, decVar, type);
                    }
                }
                if (object instanceof CompoundValue) {
                    CompoundValue cValue = (CompoundValue)object;
                    dType = cValue.getType();
                    td = registry.getType(dType = DerivedDatatype.resolveToBasis((IDatatype)Reference.dereference((IDatatype)dType)));
                    if (td != null) {
                        compatible = type.isAssignableFrom(td);
                    }
                }
            }
            if (!compatible) {
                TypeDescriptor<?> oType = registry.findType(object.getClass());
                if (oType == null && object instanceof IVilGenericType) {
                    oType = ((IVilGenericType)object).getType();
                }
                Object oTypeName = oType == null ? "?" : oType.getVilName();
                if (object instanceof DecisionVariable) {
                    DecisionVariable decVar = (DecisionVariable)object;
                    IDatatype dType = decVar.getActualType();
                    String typeName = dType != null ? IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)dType) : decVar.getTypeName();
                    oTypeName = (String)oTypeName + " (" + typeName + ")";
                }
                String msg = RuntimeEnvironment.appendModelName("cannot assign value of type \"" + (String)oTypeName + "\" to \"" + name + "\" of type \"" + type.getVilName() + "\"", modelName);
                Bundle.getLogger(RuntimeEnvironment.class).debug(msg);
                throw new VilException(msg, 50008);
            }
        }
        return object;
    }

    private static String appendModelName(String msg, Supplier<String> modelName) {
        String mName;
        if (modelName != null && (mName = modelName.get()) != null) {
            msg = (String)msg + " called in '" + mName + "'";
        }
        return msg;
    }

    private static Object evaluatePrimitives(Object object, DecisionVariable decVar, TypeDescriptor<?> varType) {
        if (TypeRegistry.integerType().isSame(varType)) {
            object = decVar.getIntegerValue();
        } else if (TypeRegistry.realType().isSame(varType)) {
            object = decVar.getRealValue();
        } else if (TypeRegistry.booleanType().isSame(varType)) {
            object = decVar.getBooleanValue();
        } else if (TypeRegistry.stringType().isSame(varType)) {
            object = decVar.getStringValue();
        }
        return object;
    }

    public IndentationConfiguration getIndentationConfiguration() {
        return this.currentContext.getIndentationConfiguration();
    }

    public int getIndentation() {
        return this.currentContext.getIndentation();
    }

    public void setIndentationSteps(int steps) {
        this.currentContext.setIndentationSteps(steps);
    }

    public void setIndentation(int indentation) {
        this.currentContext.setIndentation(indentation);
    }

    public void increaseIndentation() {
        this.currentContext.increaseIndentation();
    }

    public void decreaseIndentation() {
        this.currentContext.decreaseIndentation();
    }

    @Override
    public Object getIvmlValue(String name) throws VilException {
        return this.currentContext.getIvmlValue(name);
    }

    public void setValue(IVariable variable, Version version) throws RestrictionEvaluationException {
        if (this.cls.isInstance(variable)) {
            try {
                this.addValue((VariableDeclaration)this.cls.cast(variable), version);
            }
            catch (VilException e) {
                throw new RestrictionEvaluationException(e.getMessage(), e.getId());
            }
        } else {
            throw new RestrictionEvaluationException("unsupported type", 10999);
        }
    }

    public void unsetValue(IVariable variable) throws RestrictionEvaluationException {
        if (!this.cls.isInstance(variable)) {
            throw new RestrictionEvaluationException("unsupported type", 10999);
        }
        this.removeValue((VariableDeclaration)this.cls.cast(variable));
    }

    protected abstract IExpressionVisitor createEvaluationProcessor();

    protected abstract void releaseEvaluationProcessor(IExpressionVisitor var1);

    public Object startEvaluation() throws RestrictionEvaluationException {
        if (this.currentContext == null) {
            this.switchContext(new DummyModel());
        }
        this.pushLevel();
        return this.createEvaluationProcessor();
    }

    public void endEvaluation(Object processor) throws RestrictionEvaluationException {
        if (processor instanceof IExpressionVisitor) {
            this.releaseEvaluationProcessor((IExpressionVisitor)processor);
        }
        try {
            this.popLevel();
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId());
        }
    }

    public Configuration getTopLevelConfiguration() {
        return this.currentContext.getTopLevelConfiguration();
    }

    public void markNoAutoStore(IArtifact artifact) {
        this.noAutoStore.add(artifact);
    }

    public void unmarkNoAutoStore(IArtifact artifact) {
        this.noAutoStore.remove(artifact);
    }

    private class Context<D extends VariableDeclaration, O extends IModel> {
        private Stack<Level<D>> levels = new Stack();
        private IResolvableModel<D, O> model;
        private IResolvableModel<D, O> specificModel;
        private int indentation;
        private IndentationConfiguration indentationConfiguration;
        private String[] paths;
        private Context<D, O> parent;

        public Context(IResolvableModel<D, O> model, Context<D, O> parent) {
            this.parent = parent;
            this.model = model;
            this.specificModel = model;
            if (model.getIndentationConfiguration() != null && model.getIndentationConfiguration().isIndentationEnabled()) {
                this.indentationConfiguration = model.getIndentationConfiguration();
            }
            this.pushLevel();
        }

        public IResolvableModel<D, O> getModel() {
            return this.model;
        }

        public IResolvableModel<D, O> getMostSpecificModel() {
            return this.specificModel;
        }

        public void setMostSpecificModel(IResolvableModel<D, O> model) {
            this.specificModel = model;
        }

        public Object getValue(IResolvable resolvable) throws VilException {
            return this.getValue(resolvable, true);
        }

        private Object getValue(IResolvable resolvable, boolean thrw) throws VilException {
            boolean found = false;
            Object value = null;
            int l = this.levels.size() - 1;
            while (!found && l >= 0) {
                Level level = (Level)this.levels.get(l);
                if (level.values.containsKey(resolvable)) {
                    found = true;
                    value = level.values.get(resolvable);
                }
                --l;
            }
            if (!found && this.parent != null) {
                value = this.parent.getValue(resolvable, false);
                boolean bl = found = value != null;
            }
            if (!found && thrw) {
                throw new VilException("variable " + resolvable.getName() + " is not defined", 50000);
            }
            return value;
        }

        public D get(String name) {
            VariableDeclaration result = null;
            int l = this.levels.size() - 1;
            while (result == null && l >= 0) {
                Level level = (Level)this.levels.get(l);
                result = (VariableDeclaration)level.variables.get(name);
                --l;
            }
            return (D)result;
        }

        public boolean isDefined(D var) {
            return this.isDefined(var, this.levels.size() - 1);
        }

        private boolean isDefined(D var, int maxIndex) {
            boolean found = false;
            int l = maxIndex;
            while (!found && l >= 0) {
                Level level = (Level)this.levels.get(l);
                if (level.values.containsKey(var)) {
                    found = level.values.get(var) != null;
                }
                --l;
            }
            return found;
        }

        public void setValue(D var, Object object) throws VilException {
            if (((VariableDeclaration)var).isConstant() && this.isDefined(var)) {
                throw new VilException("variable " + ((VariableDeclaration)var).getName() + " is constant", 50002);
            }
            boolean found = false;
            int l = this.levels.size() - 1;
            while (!found && l >= 0) {
                Level level = (Level)this.levels.get(l);
                if (level.values.containsKey(var)) {
                    level.values.put(var, object);
                    level.variables.put(((VariableDeclaration)var).getName(), var);
                    if (((VariableDeclaration)var).getType() == IvmlTypes.configurationType() && object instanceof Configuration) {
                        level.configurations.add((Configuration)object);
                    }
                    found = true;
                }
                --l;
            }
            if (!found) {
                this.addValue(var, object);
            }
        }

        public void pushLevel() {
            this.levels.push(new Level());
        }

        public void popLevel() throws VilException {
            this.storeArtifacts(false);
            if (this.levels.size() <= 1) {
                throw new IllegalArgumentException("lowest level element cannot be removed");
            }
            this.levels.pop();
        }

        private boolean enableAutoStore(IArtifact artifact, boolean enable, int nestingLevel) {
            if (enable && !artifact.enableAutoStore()) {
                return nestingLevel < 0;
            }
            return enable;
        }

        public void storeArtifacts(boolean force) throws VilException {
            if (this.levels.size() > 0) {
                Level<D> top = this.levels.peek();
                int maxLevel = this.levels.size() - 2;
                for (Map.Entry ent : top.values.entrySet()) {
                    Object o = ent.getValue();
                    if (!(o instanceof IArtifact)) continue;
                    IArtifact artifact = (IArtifact)o;
                    if (!force && !this.enableAutoStore(artifact, !RuntimeEnvironment.this.noAutoStore.contains(artifact) && !this.isDefined((VariableDeclaration)ent.getKey(), maxLevel), maxLevel)) continue;
                    artifact.store();
                }
            }
        }

        public void addValue(D var, Object object) throws VilException {
            Level<D> level = this.levels.peek();
            level.values.put(var, object);
            level.variables.put(((VariableDeclaration)var).getName(), var);
            if (((VariableDeclaration)var).getType() == IvmlTypes.configurationType() && object instanceof Configuration) {
                level.configurations.add((Configuration)object);
            }
        }

        public void removeValue(D var) {
            Level<D> level = this.levels.peek();
            Object object = level.values.get(var);
            level.values.remove(var);
            level.variables.remove(((VariableDeclaration)var).getName());
            if (((VariableDeclaration)var).getType() == IvmlTypes.configurationType() && object instanceof Configuration) {
                level.configurations.remove((Configuration)object);
            }
        }

        public IndentationConfiguration getIndentationConfiguration() {
            return this.indentationConfiguration;
        }

        public int getIndentation() {
            return this.indentation;
        }

        public void setIndentationSteps(int steps) {
            if (steps > 0 && this.indentationConfiguration != null) {
                this.indentation = steps * this.indentationConfiguration.getIndentationStep();
            }
        }

        public void setIndentation(int indentation) {
            if (indentation >= 0) {
                this.indentation = indentation;
            }
        }

        public void increaseIndentation() {
            if (this.indentationConfiguration != null) {
                this.indentation += Math.max(0, this.indentationConfiguration.getIndentationStep());
            }
        }

        public void decreaseIndentation() {
            int step;
            if (this.indentationConfiguration != null && this.indentation > (step = Math.max(0, this.indentationConfiguration.getIndentationStep()))) {
                this.indentation -= step;
            }
        }

        public Object getIvmlValue(String name) throws VilException {
            boolean found = false;
            IvmlElement value = null;
            int l = this.levels.size() - 1;
            while (!found && l >= 0) {
                Level level = (Level)this.levels.get(l);
                int c = 0;
                while (!found && c < level.configurations.size()) {
                    IvmlElement elt = level.configurations.get(c).getElement(name);
                    if (elt != null) {
                        found = true;
                        value = elt;
                    }
                    ++c;
                }
                --l;
            }
            if (!found) {
                throw new VilException("IVML element '" + name + "' is not defined", 50000);
            }
            return value;
        }

        public Configuration getTopLevelConfiguration() {
            List<Configuration> cfgs;
            Configuration result = null;
            if (!this.levels.isEmpty() && (cfgs = ((Level)this.levels.get((int)0)).configurations) != null && !cfgs.isEmpty()) {
                result = cfgs.get(0);
            }
            return result;
        }
    }

    private static class Level<V extends VariableDeclaration> {
        private Map<V, Object> values = new HashMap<V, Object>();
        private Map<String, V> variables = new HashMap<String, V>();
        private List<Configuration> configurations = new ArrayList<Configuration>();

        private Level() {
        }

        public String toString() {
            return "[" + String.valueOf(this.values) + " " + String.valueOf(this.variables) + "]";
        }
    }
}

