/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;

public class StreamGobbler
extends Thread {
    private InputStream is;
    private boolean isErrorStream;
    private IMsgManipulator manipulator;
    private TracerFactory tracers;
    private List<Predicate<String>> excludeFilters;

    public StreamGobbler(InputStream is, boolean isErrorStream) {
        this(is, isErrorStream, null);
    }

    public StreamGobbler(InputStream is, boolean isErrorStream, IMsgManipulator manipulator) {
        this.is = is;
        this.isErrorStream = isErrorStream;
        this.manipulator = manipulator;
        this.tracers = TracerFactory.getInstance();
    }

    public static void gobble(Process proc) {
        StreamGobbler.gobble(proc, null, new GobblerConfigurer[0]);
    }

    public static void gobble(Process proc, IMsgManipulator manipulator, GobblerConfigurer ... configurers) {
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), true, manipulator);
        GobblerConfigurer[] gobblerConfigurerArray = configurers;
        int n = configurers.length;
        int n2 = 0;
        while (n2 < n) {
            GobblerConfigurer c = gobblerConfigurerArray[n2];
            c.configure(errorGobbler);
            ++n2;
        }
        errorGobbler.start();
        StreamGobbler outGobbler = new StreamGobbler(proc.getInputStream(), false, manipulator);
        outGobbler.start();
        GobblerConfigurer[] gobblerConfigurerArray2 = configurers;
        int n3 = configurers.length;
        n = 0;
        while (n < n3) {
            GobblerConfigurer c = gobblerConfigurerArray2[n];
            c.configure(outGobbler);
            ++n;
        }
    }

    public void addExcludeFilter(Predicate<String> filter) {
        if (filter != null) {
            if (this.excludeFilters == null) {
                this.excludeFilters = new ArrayList<Predicate<String>>();
            }
            this.excludeFilters.add(filter);
        }
    }

    private boolean isOkForFilter(String line) {
        boolean ok = true;
        int size = this.excludeFilters == null ? 0 : this.excludeFilters.size();
        int i = 0;
        while (ok && i < size) {
            ok = !this.excludeFilters.get(i).test(line);
            ++i;
        }
        return ok;
    }

    public boolean isErrorStream() {
        return this.isErrorStream;
    }

    @Override
    public void run() {
        TracerFactory.setInstance(this.tracers);
        IInstantiatorTracer tracer = TracerFactory.createInstantiatorTracer();
        try {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.manipulator != null) {
                        line = this.manipulator.manipulate(line);
                    }
                    if (line == null || !this.isOkForFilter(line)) continue;
                    if (this.isErrorStream) {
                        tracer.traceError(line);
                        continue;
                    }
                    tracer.traceMessage(line);
                }
            }
            catch (EOFException isr) {
                TracerFactory.setInstance(null);
            }
            catch (IOException ioe) {
                EASyLoggerFactory.INSTANCE.getLogger(StreamGobbler.class, "net.ssehub.easy.instantiation.core").exception((Exception)ioe);
                TracerFactory.setInstance(null);
            }
        }
        finally {
            TracerFactory.setInstance(null);
        }
    }

    public static interface GobblerConfigurer {
        public void configure(StreamGobbler var1);
    }

    public static interface IMsgManipulator {
        public String manipulate(String var1);
    }
}

