/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.io.Writer;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.ITracer;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;

public abstract class StreamTracer
extends net.ssehub.easy.instantiation.core.model.expressions.StreamTracer
implements ITracer {
    private boolean enabled = true;

    public StreamTracer(Writer out, String ... baseFolder) {
        super(out, baseFolder);
    }

    @Override
    public void trace(String text) {
        this.printIndentation();
        this.println(text);
    }

    @Override
    public void traceError(String text) {
        this.printIndentation();
        this.println(text);
    }

    @Override
    public void traceWarning(String text) {
        this.printIndentation();
        this.println("Warning: " + text);
    }

    @Override
    public void valueDefined(VariableDeclaration var, FieldDescriptor field, Object value) {
        if (this.enabled) {
            this.printIndentation();
            this.printValueDefined(var, field, value);
            this.println();
        }
    }

    protected void printValueDefined(VariableDeclaration var, FieldDescriptor field, Object value) {
        if (this.enabled) {
            boolean tmp = false;
            if (value instanceof Path) {
                tmp = ((Path)value).isTemporary();
            } else if (value instanceof IFileSystemArtifact) {
                tmp = ((IFileSystemArtifact)value).isTemporary();
            }
            String valueString = tmp ? "<temp>" : this.makeRelative(value);
            Object name = var.getName();
            if (field != null) {
                name = (String)name + "." + field.getName();
            }
            this.print((String)name + " <- " + valueString);
        }
    }

    @Override
    public void traceExecutionException(VilException exception) {
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void enable(boolean enable) {
        this.enabled = enable;
    }
}

