/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.execution;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangExecution;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionResult;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Project;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FrozenVariablesFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.NoVariableFilter;
import net.ssehub.easy.varModel.confModel.Configuration;

public class Executor {
    public static final String PARAM_SOURCE = "source";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_CONFIG = "config";
    public static final String DEFAULT_START_RULE_NAME = "main";
    protected static final IExecutable DEFAULT_EXECUTABLE = new IExecutable(){

        @Override
        public void execute(Executor executor, ITracer tracer, java.util.Map<String, Object> args) throws VilException {
            BuildlangExecution exec = executor.getActualExecutor();
            Object result = executor.getScript().accept(exec);
            if (result instanceof RuleExecutionResult) {
                RuleExecutionResult rExecResult = (RuleExecutionResult)result;
                executor.handleExecutionResult(rExecResult, tracer, exec);
            }
        }
    };
    private static final Set<String> DEFAULT_PARAMS = new HashSet<String>();
    private java.util.Map<String, Object> arguments = new HashMap<String, Object>();
    private Script script;
    private String startRuleName = "main";
    private File base;
    private boolean frozenOnly = true;
    private transient BuildlangExecution executor;

    static {
        DEFAULT_PARAMS.add(PARAM_SOURCE);
        DEFAULT_PARAMS.add(PARAM_TARGET);
        DEFAULT_PARAMS.add(PARAM_CONFIG);
    }

    public Executor(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("VIL build script must be given");
        }
        this.script = script;
    }

    public Executor(Script script, java.util.Map<String, Object> arguments) {
        this(script);
        if (arguments != null) {
            for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (DEFAULT_PARAMS.contains(name)) {
                    this.arguments.put(name, value);
                    continue;
                }
                this.arguments.put(name, Executor.convertToVIL(value));
            }
        }
    }

    public Executor addStartRuleName(String startRuleName) {
        if (startRuleName != null && startRuleName.length() > 0) {
            this.startRuleName = startRuleName;
        }
        return this;
    }

    public Executor frozenOnly(boolean frozenOnly) {
        this.setFrozenOnly(frozenOnly);
        return this;
    }

    protected void setFrozenOnly(boolean frozenOnly) {
        this.frozenOnly = frozenOnly;
    }

    public Executor addSource(File source) {
        if (source == null) {
            throw new IllegalArgumentException("at least one source must be given");
        }
        this.arguments.put(PARAM_SOURCE, source);
        return this;
    }

    public Executor addSource(IProjectDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException("at least one source must be given");
        }
        this.arguments.put(PARAM_SOURCE, source);
        return this;
    }

    public Executor addSources(List<File> sources) {
        if (sources == null || sources.size() == 0) {
            throw new IllegalArgumentException("at least one source must be given");
        }
        File[] sFiles = new File[sources.size()];
        return this.addSources(sources.toArray(sFiles));
    }

    public Executor addSources(File[] sources) {
        if (sources == null || sources.length == 0) {
            throw new IllegalArgumentException("at least one source must be given");
        }
        this.arguments.put(PARAM_SOURCE, sources);
        return this;
    }

    public Executor addSources(IProjectDescriptor[] sources) {
        if (sources == null || sources.length == 0) {
            throw new IllegalArgumentException("at least one source must be given");
        }
        this.arguments.put(PARAM_SOURCE, sources);
        return this;
    }

    public Executor addTarget(File target) {
        this.arguments.put(PARAM_TARGET, target);
        return this;
    }

    public Executor addTarget(IProjectDescriptor target) {
        this.arguments.put(PARAM_TARGET, target);
        return this;
    }

    public Executor addConfiguration(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.arguments.put(PARAM_CONFIG, config);
        return this;
    }

    public Executor addConfiguration(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.arguments.put(PARAM_CONFIG, config);
        return this;
    }

    public Executor addBase(File base) {
        this.base = base;
        return this;
    }

    public Executor addCustomArgument(String name, Object value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("parameter name must be given");
        }
        this.arguments.put(name, Executor.convertToVIL(value));
        return this;
    }

    private static TypeDescriptor<?>[] unknownCollectionType() {
        TypeDescriptor<?>[] unknown = TypeDescriptor.createArray(1);
        unknown[0] = TypeRegistry.anyType();
        return unknown;
    }

    private static TypeDescriptor<?>[] unknownMapType() {
        TypeDescriptor<?>[] unknown = TypeDescriptor.createArray(2);
        unknown[0] = TypeRegistry.anyType();
        unknown[1] = TypeRegistry.anyType();
        return unknown;
    }

    private static Object convertToVIL(Object object) {
        IStringValueProvider result = object;
        try {
            if (object != null) {
                if (object.getClass().isArray()) {
                    Object[] tmp = new Object[Array.getLength(object)];
                    int i = 0;
                    while (i < tmp.length) {
                        tmp[i] = Executor.convertToVIL(Array.get(object, i));
                        ++i;
                    }
                    result = new ArraySequence<Object>(tmp, Executor.unknownCollectionType());
                } else if (object instanceof Set) {
                    Set set = (Set)((Object)object);
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    for (Object o : set) {
                        tmp.add(Executor.convertToVIL(o));
                    }
                    result = new ListSet(tmp, Executor.unknownCollectionType());
                } else if (object instanceof List) {
                    List list = (List)((Object)object);
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    int size = list.size();
                    int i = 0;
                    while (i < size) {
                        tmp.add(Executor.convertToVIL(list.get(i)));
                        ++i;
                    }
                    result = new ListSequence(tmp, Executor.unknownCollectionType());
                } else if (object instanceof java.util.Map) {
                    java.util.Map map = (java.util.Map)((Object)object);
                    HashMap<Object, Object> tmp = new HashMap<Object, Object>();
                    for (Map.Entry entry : map.entrySet()) {
                        tmp.put(Executor.convertToVIL(entry.getKey()), Executor.convertToVIL(entry.getValue()));
                    }
                    result = new Map(tmp, Executor.unknownMapType());
                }
            }
        }
        catch (ClassCastException e) {
            EASyLoggerFactory.INSTANCE.getLogger(Executor.class, "net.ssehub.easy.instantiation.core").warn("class mismatch during automatic VIL parameter conversion: " + e.getMessage());
        }
        return result;
    }

    public void execute() throws VilException {
        this.execute(true);
    }

    public void execute(boolean check) throws VilException {
        this.execute(ProgressObserver.NO_OBSERVER, check);
    }

    public void execute(ProgressObserver observer, boolean check) throws VilException {
        this.execute(observer, check, DEFAULT_EXECUTABLE);
    }

    public BuildlangExecution getActualExecutor() {
        return this.executor;
    }

    protected static net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration getConfiguration(java.util.Map<String, Object> args) throws VilException {
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration result = null;
        if (!(args.get(PARAM_CONFIG) instanceof net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration)) {
            throw new VilException("No VIL configuration given", 30003);
        }
        result = (net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration)args.get(PARAM_CONFIG);
        return result;
    }

    public Script getScript() {
        return this.script;
    }

    protected void execute(ProgressObserver observer, boolean check, IExecutable executable) throws VilException {
        if (observer == null) {
            throw new IllegalArgumentException("observer must not be null");
        }
        HashMap<String, Object> actArgs = new HashMap<String, Object>();
        actArgs.putAll(this.arguments);
        ITracer tracer = TracerFactory.createBuildLanguageTracer();
        TracerFactory.registerBuildLanguageTracer(tracer);
        File base = this.base;
        if (check) {
            Object tmp;
            this.checkArguments(actArgs, observer);
            if (actArgs.get(PARAM_TARGET) == null && actArgs.get(PARAM_SOURCE) instanceof Project) {
                actArgs.put(PARAM_TARGET, actArgs.get(PARAM_SOURCE));
            }
            if (actArgs.get(PARAM_TARGET) == null) {
                throw new IllegalArgumentException("no target project specified, neither via target project nor explicitly");
            }
            if (base == null && (tmp = actArgs.get(PARAM_TARGET)) instanceof Project) {
                base = ((Project)tmp).getPath().getAbsolutePath();
            }
        }
        if (base == null) {
            throw new IllegalArgumentException("no base folder specified, neither via target project nor explicitly");
        }
        if (this.script.isDirty()) {
            Script old = this.script;
            this.script = (Script)BuildModel.INSTANCE.reload(this.script);
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Reloading model " + this.script.getName() + " " + System.identityHashCode(this.script) + " as it was marked dirty " + (old != this.script));
        }
        this.executor = this.createExecutionEnvironment(tracer, base, this.startRuleName, actArgs);
        try {
            try {
                executable.execute(this, tracer, actArgs);
                Project.clearProjectDescriptorCache();
                this.executor.release(true);
            }
            catch (VilException e) {
                tracer.traceExecutionException(e);
                throw e;
            }
        }
        finally {
            TracerFactory.unregisterBuildLanguageTracer(tracer);
        }
        tracer.reset();
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.stop();
        }
    }

    protected void handleExecutionResult(RuleExecutionResult result, ITracer tracer, BuildlangExecution executor) throws VilException {
        if (RuleExecutionResult.Status.FAIL == result.getStatus()) {
            StringBuilder tmp = new StringBuilder("build execution failed");
            if (executor.getFailedCount() > 0) {
                tmp.append(" in rule");
                if (executor.getFailedCount() > 1) {
                    tmp.append("s");
                }
                tmp.append(" ");
                int f = 0;
                while (f < executor.getFailedCount()) {
                    if (f > 0) {
                        tmp.append(", ");
                    }
                    tmp.append(executor.getFailed(f).getName());
                    ++f;
                }
            }
            this.completeExecutionError(tmp, result);
            if (tmp.length() > 0) {
                VilException e = new VilException(tmp.toString(), 50007);
                tracer.traceExecutionException(e);
                throw e;
            }
        }
    }

    protected void completeExecutionError(StringBuilder msg, RuleExecutionResult result) {
    }

    protected Script reload(Script script) {
        return (Script)BuildModel.INSTANCE.reload(script);
    }

    protected BuildlangExecution createExecutionEnvironment(ITracer tracer, File base, String startRuleName, java.util.Map<String, Object> parameter) {
        return new BuildlangExecution(tracer, base, startRuleName, parameter);
    }

    private static void checkProjectArgument(java.util.Map<String, Object> args, String param, ProgressObserver observer) throws VilException {
        int f;
        Project[] sources;
        Object[] tmp;
        if (args.get(param) == null) {
            throw new IllegalArgumentException(param + " not given");
        }
        if (args.get(param) instanceof File) {
            args.put(param, new Project((File)args.get(param), observer));
        }
        if (args.get(param) instanceof IProjectDescriptor) {
            args.put(param, Project.getProjectFor((IProjectDescriptor)args.get(param)));
        }
        if (param.equals(PARAM_SOURCE) && args.get(PARAM_SOURCE) instanceof IProjectDescriptor[]) {
            tmp = (IProjectDescriptor[])args.get(PARAM_SOURCE);
            sources = new Project[tmp.length];
            f = 0;
            while (f < tmp.length) {
                sources[f] = Project.getProjectFor((IProjectDescriptor)tmp[f]);
                ++f;
            }
            args.put(PARAM_SOURCE, sources);
        }
        if (param.equals(PARAM_SOURCE) && args.get(PARAM_SOURCE) instanceof File[]) {
            tmp = (File[])args.get(PARAM_SOURCE);
            sources = new Project[tmp.length];
            f = 0;
            while (f < tmp.length) {
                sources[f] = new Project((File)tmp[f], observer);
                ++f;
            }
            args.put(PARAM_SOURCE, sources);
        }
        if (!(args.get(param) instanceof Project || param.equals(PARAM_SOURCE) && args.get(PARAM_SOURCE) instanceof Project[])) {
            throw new IllegalArgumentException(param + " is neither instance of " + Project.class.getName() + " nor an array of that class");
        }
    }

    private void checkArguments(java.util.Map<String, Object> args, ProgressObserver observer) throws VilException {
        Executor.checkProjectArgument(args, PARAM_SOURCE, observer);
        Executor.checkProjectArgument(args, PARAM_TARGET, observer);
        if (args.get(PARAM_CONFIG) == null) {
            throw new IllegalArgumentException("no configuration given");
        }
        if (args.get(PARAM_CONFIG) instanceof Configuration) {
            IVariableFilter filter = this.frozenOnly ? FrozenVariablesFilter.INSTANCE : NoVariableFilter.INSTANCE;
            args.put(PARAM_CONFIG, new net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration((Configuration)args.get(PARAM_CONFIG), filter));
        }
        if (!(args.get(PARAM_CONFIG) instanceof net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration)) {
            throw new IllegalArgumentException("config is not instance of " + net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration.class.getName());
        }
    }

    protected static interface IExecutable {
        public void execute(Executor var1, ITracer var2, java.util.Map<String, Object> var3) throws VilException;
    }
}

