/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IInitializableValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class ConstructorCallExpression
extends CallExpression {
    private TypeDescriptor<?> type;

    public ConstructorCallExpression(TypeDescriptor<?> type, Expression ... arguments) throws VilException {
        super(null, "create", arguments);
        if (type == null) {
            throw new VilException("cannot resolve type", 70001);
        }
        this.type = type;
    }

    public ConstructorCallExpression(TypeDescriptor<?> type, CallArgument ... arguments) throws VilException {
        super(null, "create", arguments);
        if (type == null) {
            throw new VilException("cannot resolve type", 70001);
        }
        if (!type.canBeInstantiated()) {
            throw new VilException("'" + type.getVilName() + "' cannot be instantiated", 50503);
        }
        this.type = type;
    }

    @Override
    protected boolean doZeroArgumentTest() {
        return false;
    }

    @Override
    protected TypeDescriptor<?> determineOperand() throws VilException {
        return this.type;
    }

    @Override
    protected boolean checkMetaForFirstArgField() {
        return false;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = super.accept(visitor);
        if (result instanceof IInitializableValue) {
            ((IInitializableValue)result).initialize(visitor);
        }
        return result;
    }
}

