/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class FieldAccessExpression
extends Expression {
    private FieldAccessExpression nested;
    private VariableDeclaration variable;
    private FieldDescriptor field;
    private boolean metaAccess;

    public FieldAccessExpression() {
    }

    public FieldAccessExpression(FieldDescriptor field) throws VilException {
        this.field = field;
        this.variable = null;
        if (!field.isStatic()) {
            throw new VilException("static field access must be on a static field", 40010);
        }
    }

    public FieldAccessExpression(VariableDeclaration variable, FieldDescriptor field) throws VilException {
        this.variable = variable;
        this.field = field;
        if (field.isStatic()) {
            throw new VilException("non-static field access must be on a non-static field", 40010);
        }
    }

    public FieldAccessExpression(FieldAccessExpression nested, FieldDescriptor field) {
        this.nested = nested;
        this.field = field;
    }

    public FieldAccessExpression getNested() {
        return this.nested;
    }

    public VariableDeclaration getVariable() {
        return this.variable;
    }

    public FieldDescriptor getField() {
        return this.field;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        IMetaType result = null;
        if (this.isMetaAccess()) {
            result = this.field.getMetaType();
        }
        if (result == null) {
            result = this.field.getType();
        }
        return result;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitFieldAccessExpression(this);
    }

    public boolean isMetaAccess() {
        return this.metaAccess;
    }

    public void enableMetaAccess() {
        this.metaAccess = true;
    }
}

