/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class MultiAndExpression
extends Expression {
    private AbstractCallExpression[] expressions;

    public MultiAndExpression(AbstractCallExpression ... expressions) throws VilException {
        if (expressions == null) {
            throw new VilException("No expression given", 30003);
        }
        int e = 0;
        while (e < expressions.length) {
            if (expressions[e] == null) {
                throw new VilException("Expression missing", 30003);
            }
            ++e;
        }
        this.expressions = expressions;
    }

    public int getExpressionCount() {
        return this.expressions.length;
    }

    public AbstractCallExpression getExpression(int index) {
        return this.expressions[index];
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> booleanType = TypeRegistry.booleanType();
        int e = 0;
        while (e < this.expressions.length) {
            if (!booleanType.isAssignableFrom(this.expressions[e].inferType())) {
                throw new VilException("Expression at index " + e + " does not evaluate to Boolean", 30006);
            }
            ++e;
        }
        return booleanType;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitMultiAndExpression(this);
    }
}

