/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ResolvableOperationCallExpression
extends AbstractCallExpression {
    private VariableDeclaration var;
    private CallArgument[] arguments;

    public ResolvableOperationCallExpression(VariableDeclaration var, CallArgument[] arguments) throws VilException {
        super(var.getName(), false);
        this.var = var;
        this.arguments = arguments;
        if (arguments == null) {
            throw new VilException("no arguments provided (null)", 70000);
        }
        TypeDescriptor<?> varType = var.getType();
        if (!TypeRegistry.resolvableOperationType().isAssignableFrom(varType)) {
            throw new VilException("var is not of type resolvable operation", 70000);
        }
        int genParamCount = varType.getGenericParameterCount();
        if (genParamCount < 1) {
            throw new VilException("no generic parameter of var", 70000);
        }
        if (arguments.length != genParamCount - 1) {
            throw new VilException("number of provided operation and call does not match", 70000);
        }
        int a = 0;
        while (a < arguments.length) {
            if (!varType.getGenericParameterType(a).isAssignableFrom(arguments[a].getExpression().inferType())) {
                throw new VilException("argument number " + a + " does not match declared parameter type", 70000);
            }
            ++a;
        }
    }

    public VariableDeclaration getVariable() {
        return this.var;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public String getVilSignature() {
        return ResolvableOperationCallExpression.getSignature(this.getName(), this.arguments);
    }

    @Override
    public int getArgumentsCount() {
        return this.arguments.length;
    }

    @Override
    public CallArgument getArgument(int index) {
        return this.arguments[index];
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> type = this.var.getType();
        return type.getGenericParameterType(type.getGenericParameterCount() - 1);
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitResolvableOperationCallExpression(this);
    }
}

