/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ValueAssignmentExpression
extends Expression {
    private VariableDeclaration varDecl;
    private FieldDescriptor field;
    private Expression valueExpression;

    ValueAssignmentExpression() {
    }

    public ValueAssignmentExpression(VariableDeclaration varDecl, Expression valueExpression) {
        this(varDecl, null, valueExpression);
    }

    public ValueAssignmentExpression(VariableDeclaration varDecl, FieldDescriptor field, Expression valueExpression) {
        this.varDecl = varDecl;
        this.field = field;
        this.valueExpression = valueExpression;
    }

    public VariableDeclaration getVarDecl() {
        return this.varDecl;
    }

    public FieldDescriptor getField() {
        return this.field;
    }

    public Expression getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        boolean assignable;
        TypeDescriptor<?> varType = this.varDecl.getType();
        TypeDescriptor<?> valType = this.valueExpression.inferType();
        boolean bl = assignable = varType.isSet() && valType.isSequence();
        if (!(assignable |= varType.isAssignableFrom(valType))) {
            OperationDescriptor operation = valType.findConversion(valType, varType);
            if (operation == null) {
                operation = varType.findConversion(valType, varType);
            }
            if (operation != null) {
                this.valueExpression = new CallExpression(operation, new CallArgument(this.valueExpression));
            } else {
                Object target = this.varDecl.getName();
                if (this.field != null) {
                    target = (String)target + "." + this.field.getName();
                }
                throw new VilException("cannot assign/convert value of type " + valType.getVilName() + " to variable " + (String)target + " of type " + varType.getVilName(), 70001);
            }
        }
        return TypeRegistry.voidType();
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitValueAssignmentExpression(this);
    }
}

