/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class AlternativeStatement
extends AbstractTemplateElement {
    private Expression condition;
    private ITemplateElement ifStatement;
    private ITemplateElement elseStatement;

    AlternativeStatement() {
    }

    public AlternativeStatement(Expression condition, ITemplateElement ifStatement) throws VilException {
        this(condition, ifStatement, null);
    }

    public AlternativeStatement(Expression condition, ITemplateElement ifStatement, ITemplateElement elseStatement) throws VilException {
        this.condition = condition;
        this.ifStatement = ifStatement;
        this.elseStatement = elseStatement;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public ITemplateElement getIfStatement() {
        return this.ifStatement;
    }

    public ITemplateElement getElseStatement() {
        return this.elseStatement;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitAlternative(this);
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> elseType;
        TypeDescriptor<?> ifType;
        TypeDescriptor<?> result = this.elseStatement == null ? this.ifStatement.inferType() : ((ifType = this.ifStatement.inferType()).equals(elseType = this.elseStatement.inferType()) ? ifType : TypeRegistry.anyType());
        return result;
    }

    @Override
    public boolean endsWithContentStatement() {
        boolean endsWith = this.ifStatement.endsWithContentStatement();
        if (this.elseStatement != null) {
            endsWith &= this.elseStatement.endsWithContentStatement();
        }
        return endsWith;
    }
}

