/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.function.Predicate;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentFormatter;
import net.ssehub.easy.instantiation.core.model.templateModel.Formatting;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;

public class CodeWriter
implements Closeable {
    private static Predicate<File> debugFilter = f -> Boolean.valueOf(System.getProperty("easy.java.writer.debug", "false"));
    private PrintWriter out;
    private String indent = "";
    private String indentStep = "  ";
    private String lineEnd = System.lineSeparator();
    private int lineLength = -1;
    private ContentFormatter contentFormatter;
    private Charset charset;
    private StringBuilder buffer = new StringBuilder();
    private boolean debug;

    public CodeWriter(File file) throws VilException {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            this.out = new PrintWriter(file);
            this.initializeFormatting();
            this.debug = debugFilter.test(file);
        }
        catch (IOException e) {
            throw new VilException(e, 70000);
        }
    }

    public CodeWriter(PrintWriter out) {
        this.out = out;
        this.initializeFormatting();
    }

    private void initializeFormatting() {
        FormattingConfiguration fCfg = Formatting.getFormattingConfiguration();
        IndentationConfiguration iCfg = Formatting.getIndentationConfiguration();
        int iStep = fCfg.getIndentSteps() >= 0 ? fCfg.getIndentSteps() : iCfg.getIndentationStep();
        this.indentStep = "";
        int i = 1;
        while (i <= iStep) {
            this.indentStep = String.valueOf(this.indentStep) + " ";
            ++i;
        }
        if (fCfg.getLineEnding() != null) {
            this.lineEnd = fCfg.getLineEnding();
        }
        if (fCfg.getLineLength() > 0) {
            this.lineLength = fCfg.getLineLength();
        }
        this.contentFormatter = Formatting.getContentFormatter();
        this.charset = fCfg.getCharset() == null ? Charset.defaultCharset() : fCfg.getCharset();
    }

    public static Predicate<File> setDebugFilter(Predicate<File> filter) {
        Predicate<File> old = debugFilter;
        if (filter != null) {
            debugFilter = filter;
        }
        return old;
    }

    protected Charset getCharset() {
        return this.charset;
    }

    public String getLineEnd() {
        return this.lineEnd;
    }

    public void printIndent() {
        this.buffer.append(this.indent);
    }

    public void printIndentStep() {
        this.buffer.append(this.indentStep);
    }

    public void printlnwi(String text) {
        this.printIndent();
        this.println(text);
    }

    public void printwi(String text) {
        this.printIndent();
        this.print(text);
    }

    public void println() {
        this.buffer.append(this.lineEnd);
    }

    public void println(String text) {
        this.buffer.append(text);
        this.buffer.append(this.lineEnd);
        this.emit();
    }

    void emit() {
        if (this.buffer.length() > 0) {
            String formatted = this.contentFormatter.format(this.buffer.toString());
            this.buffer.setLength(0);
            this.out.print(formatted);
            if (this.debug) {
                System.out.print(formatted);
            }
        }
    }

    public void print(String text) {
        this.buffer.append(text);
    }

    public void increaseIndent() {
        this.indent = String.valueOf(this.indent) + this.indentStep;
    }

    public void decreaseIndent() {
        if (this.indent.length() >= this.indentStep.length()) {
            this.indent = this.indent.substring(this.indentStep.length());
        }
    }

    @Override
    public void close() {
        this.emit();
        if (this.out != null) {
            this.out.close();
        }
    }

    protected void flush() {
        this.emit();
        if (this.out != null) {
            this.out.flush();
        }
    }

    public boolean printLinesWi(String text, boolean always, boolean endWithNewLine) {
        boolean printed = false;
        if (text.contains("\n") || text.contains("\r")) {
            String[] lines = text.split(this.getLineEnd());
            int count = 1;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                if (count < lines.length) {
                    this.printlnwi(l);
                } else if (endWithNewLine) {
                    this.printlnwi(l);
                } else {
                    this.printwi(l);
                }
                ++count;
                ++n2;
            }
            printed = true;
        } else if (always) {
            if (endWithNewLine) {
                this.printlnwi(text);
            } else {
                this.printwi(text);
            }
            printed = true;
        }
        return printed;
    }
}

