/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class LoopStatement
extends AbstractTemplateElement {
    private VariableDeclaration iteratorVar;
    private Expression containerExpression;
    private ITemplateElement statement;
    private Expression separatorExpression;
    private Expression finalSeparatorExpression;

    LoopStatement() {
    }

    public LoopStatement(VariableDeclaration iteratorVar, Expression containerExpression, ITemplateElement statement, Expression separatorExpression, Expression finalSeparatorExpression) throws VilException {
        this.iteratorVar = iteratorVar;
        this.containerExpression = containerExpression;
        this.statement = statement;
        this.separatorExpression = separatorExpression;
        if (separatorExpression != null) {
            this.finalSeparatorExpression = finalSeparatorExpression;
        }
    }

    public Expression getSeparatorExpression() {
        return this.separatorExpression;
    }

    public Expression getFinalSeparatorExpression() {
        return this.finalSeparatorExpression;
    }

    public VariableDeclaration getIteratorVariable() {
        return this.iteratorVar;
    }

    public Expression getContainerExpression() {
        return this.containerExpression;
    }

    public ITemplateElement getLoopStatement() {
        return this.statement;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitLoop(this);
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return TypeRegistry.voidType();
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        this.iteratorVar.setParent(this);
    }

    @Override
    public boolean endsWithContentStatement() {
        return this.statement.endsWithContentStatement();
    }

    @Override
    public boolean isLoop() {
        return true;
    }
}

