/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IStringParserFactory;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceForCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceIfCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceImportCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceVarDeclCommand;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentAlternativeExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentLoopExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class StringResolverFactory
implements IStringParserFactory<VariableDeclaration> {
    public static final StringResolverFactory INSTANCE = new StringResolverFactory();

    protected StringResolverFactory() {
    }

    @Override
    public Expression createIfExpression(InPlaceIfCommand<VariableDeclaration> cmd) throws VilException {
        return new ContentAlternativeExpression(cmd.getCondition(), cmd.getThenExpressions(), cmd.getElseExpressions());
    }

    @Override
    public Expression createForExpression(InPlaceForCommand<VariableDeclaration> cmd) throws VilException {
        return new ContentLoopExpression(cmd.getIterator(), cmd.getInit(), cmd.getSeparator(), cmd.getEndSeparator(), cmd.getBody());
    }

    @Override
    public VariableDeclaration createVariable(String name, Expression initExpression, boolean asIterator) throws VilException {
        TypeDescriptor<?> type;
        Expression initEx = initExpression;
        TypeDescriptor<?> typeDescriptor = type = initEx != null ? initEx.inferType() : null;
        if (type == null) {
            throw new VilException("No type given/resolved for creating variable '" + name + "'.", 30006);
        }
        if (asIterator) {
            if (!type.isCollection()) {
                throw new VilException("Iterator initialization expression must be of type collection", 30017);
            }
            type = type.getGenericParameterCount() > 0 ? type.getGenericParameterType(0) : TypeRegistry.anyType();
            initEx = null;
        }
        return new VariableDeclaration(name, type, false, initExpression);
    }

    @Override
    public VariableDeclaration createVariableDeclaration(String name, TypeDescriptor<?> type) {
        return new VariableDeclaration(name, type, false, null);
    }

    @Override
    public Expression createVarDeclExpression(InPlaceVarDeclCommand<VariableDeclaration> cmd) throws VilException {
        return null;
    }

    @Override
    public IVersionRestriction createVersionRestriction(Expression expression, VariableDeclaration variable) throws VilException {
        return null;
    }

    @Override
    public Expression createImportExpression(InPlaceImportCommand<VariableDeclaration> cmd) throws VilException {
        return null;
    }
}

