/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.instantiation.core.Bundle;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.VilTemplateProcessor;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.AlternativeStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.BuilderBlockExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentAlternativeExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentImportExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentLoopExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentVarDeclExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.FlushStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.LoopStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.SwitchStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateCallExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.WhileStatement;
import org.apache.commons.io.FileUtils;

public class TemplateLangMetricsVisitor
implements ITemplateLangVisitor {
    private static Set<String> processedImports = new HashSet<String>();
    private int numberOfDefs;
    private int numberOfContentStmts;
    private int numberOfContentAlternatives;
    private int numberOfContentLoops;
    private int numberOfBuilderBlockExpressions;
    private int numberOfVariableDeclarations;
    private StatisticsAggregator builderBlocksPerDef = new StatisticsAggregator("#builder/def");
    private StatisticsAggregator callChainsInDefs = new StatisticsAggregator("#callChains/def");
    private StatisticsAggregator callChainsInContentStatements = new StatisticsAggregator("#callChains/content");
    private StatisticsAggregator variableExpressionsInContentStatements = new StatisticsAggregator("#varEx/content");
    private StatisticsAggregator mcCabe = new StatisticsAggregator("McCabe/def");
    private int emptyLines;
    private int commentLines;
    private int codeLines;
    private String name;
    private transient boolean inContentStatement = false;

    public TemplateLangMetricsVisitor() {
        this.reset();
    }

    public void reset() {
        this.name = "";
        this.numberOfDefs = 0;
        this.numberOfContentStmts = 0;
        this.numberOfContentAlternatives = 0;
        this.numberOfContentLoops = 0;
        this.numberOfBuilderBlockExpressions = 0;
        this.numberOfVariableDeclarations = 0;
        this.builderBlocksPerDef.reset();
        this.callChainsInDefs.reset();
        this.callChainsInContentStatements.reset();
        this.variableExpressionsInContentStatements.reset();
        this.mcCabe.reset();
        this.emptyLines = 0;
        this.commentLines = 0;
        this.codeLines = 0;
    }

    @Override
    public Object visitTemplate(Template template) throws VilException {
        this.name = template.getName();
        int d = 0;
        while (d < template.getVariableDeclarationCount()) {
            template.getVariableDeclaration(d).accept(this);
            ++d;
        }
        d = 0;
        while (d < template.getDefCount()) {
            template.getDef(d).accept(this);
            ++d;
        }
        ModelInfo info = TemplateModel.INSTANCE.availableModels().getModelInfo((IModel)template);
        if (info != null) {
            File f = new File(info.getLocation());
            try {
                List lines = FileUtils.readLines((File)f, (Charset)Charset.defaultCharset());
                boolean inComment = false;
                for (String l : lines) {
                    if ((l = l.trim()).isBlank()) {
                        ++this.emptyLines;
                    } else if (l.startsWith("//")) {
                        ++this.commentLines;
                    } else if (l.startsWith("/*")) {
                        inComment = true;
                    }
                    if (inComment) {
                        ++this.commentLines;
                        inComment = !l.endsWith("*/");
                        continue;
                    }
                    if (l.isBlank()) continue;
                    ++this.codeLines;
                }
            }
            catch (IOException e) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("Reading " + String.valueOf(info.getLocation()) + ": " + e.getMessage());
            }
        } else {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("No model information for VTL template '" + template.getName() + "'");
        }
        return null;
    }

    @Override
    public Object visitDef(Def def) throws VilException {
        this.mcCabe.add(1);
        ++this.numberOfDefs;
        int e = 0;
        while (e < def.getBodyElementCount()) {
            def.getBodyElement(e).accept(this);
            ++e;
        }
        this.builderBlocksPerDef.aggregate();
        this.mcCabe.aggregate();
        return null;
    }

    @Override
    public Object visitTemplateBlock(TemplateBlock block) throws VilException {
        int e = 0;
        while (e < block.getBodyElementCount()) {
            block.getBodyElement(e).accept(this);
            ++e;
        }
        return null;
    }

    @Override
    public Object visitAlternative(AlternativeStatement alternative) throws VilException {
        this.mcCabe.add(1);
        alternative.getIfStatement().accept(this);
        if (alternative.getElseStatement() != null) {
            alternative.getElseStatement().accept(this);
        }
        return null;
    }

    @Override
    public Object visitLoop(LoopStatement loop) throws VilException {
        this.mcCabe.add(1);
        loop.getLoopStatement().accept(this);
        return null;
    }

    @Override
    public Object visitWhile(WhileStatement stmt) throws VilException {
        this.mcCabe.add(1);
        stmt.getLoopStatement().accept(this);
        return null;
    }

    @Override
    public Object visitSwitch(SwitchStatement swtch) throws VilException {
        this.mcCabe.add(swtch.getAlternativeCount());
        int a = 0;
        while (a < swtch.getAlternativeCount()) {
            swtch.getAlternative(a).getValue().accept(this);
            ++a;
        }
        return null;
    }

    @Override
    public Object visitContentStatement(ContentStatement cnt) throws VilException {
        ++this.numberOfContentStmts;
        this.inContentStatement = true;
        cnt.getContent().accept(this);
        this.inContentStatement = false;
        this.callChainsInContentStatements.aggregate();
        this.variableExpressionsInContentStatements.aggregate();
        return null;
    }

    @Override
    public Object visitJavaExtension(JavaExtension ext) throws VilException {
        return null;
    }

    private void incCallChain() {
        if (this.inContentStatement) {
            this.callChainsInContentStatements.add(1);
        } else {
            this.callChainsInDefs.add(1);
        }
    }

    @Override
    public Object visitTemplateCallExpression(TemplateCallExpression call) throws VilException {
        this.incCallChain();
        int a = 0;
        while (a < call.getArgumentsCount()) {
            call.getArgument(a).accept(this);
            ++a;
        }
        return null;
    }

    @Override
    public Object visitFlush(FlushStatement flush) throws VilException {
        return null;
    }

    @Override
    public Object visitContentAlternativeExpression(ContentAlternativeExpression ex) throws VilException {
        ++this.numberOfContentAlternatives;
        return null;
    }

    @Override
    public Object visitContentLoopExpression(ContentLoopExpression ex) throws VilException {
        ++this.numberOfContentLoops;
        return null;
    }

    @Override
    public Object visitContentVarDeclExpression(ContentVarDeclExpression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitContentImportExpression(ContentImportExpression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitVariableDeclaration(VariableDeclaration var) throws VilException {
        ++this.numberOfVariableDeclarations;
        if (var.getExpression() != null) {
            var.getExpression().accept(this);
        }
        return null;
    }

    @Override
    public Object visitAdvice(Advice advice) throws VilException {
        return null;
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatement statement) throws VilException {
        statement.getExpression().accept(this);
        this.callChainsInDefs.aggregate();
        return null;
    }

    @Override
    public Object visitTypedef(Typedef typedef) throws VilException {
        return null;
    }

    @Override
    public Object visitCompound(Compound compound) throws VilException {
        return null;
    }

    @Override
    public Object visitParenthesisExpression(ParenthesisExpression par) throws VilException {
        par.getExpr().accept(this);
        return null;
    }

    @Override
    public Object visitCallExpression(CallExpression call) throws VilException {
        this.incCallChain();
        int a = 0;
        while (a < call.getArgumentsCount()) {
            call.getArgument(a).accept(this);
            ++a;
        }
        return null;
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        return null;
    }

    @Override
    public Object visitVarModelIdentifierExpression(VarModelIdentifierExpression identifier) throws VilException {
        return null;
    }

    @Override
    public Object visitVilTypeExpression(VilTypeExpression typeExpression) throws VilException {
        return null;
    }

    @Override
    public Object visitVariableExpression(VariableExpression cst) throws VilException {
        if (this.inContentStatement) {
            this.variableExpressionsInContentStatements.add(1);
        }
        return null;
    }

    @Override
    public Object visitExpressionEvaluator(ExpressionEvaluator ex) throws VilException {
        ex.getExpression().accept(this);
        return null;
    }

    @Override
    public Object visitExpression(Expression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitValueAssignmentExpression(ValueAssignmentExpression ex) throws VilException {
        if (ex.getValueExpression() != null) {
            ex.getValueExpression().accept(this);
        }
        return null;
    }

    @Override
    public Object visitContainerInitializerExpression(ContainerInitializerExpression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitCompositeExpression(CompositeExpression ex) throws VilException {
        int i = 0;
        while (i < ex.getExpressionsCount()) {
            ex.getExpression(i).accept(this);
            ++i;
        }
        return null;
    }

    @Override
    public Object visitFieldAccessExpression(FieldAccessExpression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitResolvableOperationExpression(ResolvableOperationExpression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        this.incCallChain();
        int a = 0;
        while (a < ex.getArgumentsCount()) {
            ex.getArgument(a).accept(this);
            ++a;
        }
        return null;
    }

    @Override
    public Object visitMultiAndExpression(MultiAndExpression ex) throws VilException {
        int e = 0;
        while (e < ex.getExpressionCount()) {
            ex.getExpression(e).accept(this);
            ++e;
        }
        return null;
    }

    @Override
    public Object visitStringExpression(StringExpression ex) throws VilException {
        return null;
    }

    @Override
    public Object visitBuilderBlockExpression(BuilderBlockExpression ex) throws VilException {
        ++this.numberOfBuilderBlockExpressions;
        this.builderBlocksPerDef.add(1);
        ex.getVariable().getExpression().accept(this);
        ex.getBlock().accept(this);
        return null;
    }

    public String toString() {
        return String.format("name %s codeLines %d/%d/%d MC %.0f[%.0f|%.0f|%.0f] defs %d bb %d[%.0f|%.0f|%.0f] CC/def [%.0f|%.0f|%.0f] CC/content [%.0f|%.0f|%.0f] vars/content [%.0f|%.0f|%.0f]", this.name, this.codeLines, this.commentLines, this.emptyLines, this.mcCabe.getTotalSum(), this.mcCabe.getAverageMin(), this.mcCabe.getAverage(), this.mcCabe.getAverageMax(), this.numberOfDefs, this.numberOfBuilderBlockExpressions, this.builderBlocksPerDef.getAverageMin(), this.builderBlocksPerDef.getAverage(), this.builderBlocksPerDef.getAverageMax(), this.callChainsInDefs.getAverageMin(), this.callChainsInDefs.getAverage(), this.callChainsInDefs.getAverageMax(), this.callChainsInContentStatements.getAverageMin(), this.callChainsInContentStatements.getAverage(), this.callChainsInContentStatements.getAverageMax(), this.variableExpressionsInContentStatements.getAverageMin(), this.variableExpressionsInContentStatements.getAverage(), this.variableExpressionsInContentStatements.getAverageMax());
    }

    public int getNumberOfDefs() {
        return this.numberOfDefs;
    }

    public int getNumberOfContentStmts() {
        return this.numberOfContentStmts;
    }

    public int getNumberOfContentAlternatives() {
        return this.numberOfContentAlternatives;
    }

    public int getNumberOfContentLoops() {
        return this.numberOfContentLoops;
    }

    public int getNumberOfBuilderBlockExpressions() {
        return this.numberOfBuilderBlockExpressions;
    }

    public int getNumberOfVariableDeclarations() {
        return this.numberOfVariableDeclarations;
    }

    public StatisticsAggregator getBuilderBlocksPerDef() {
        return this.builderBlocksPerDef;
    }

    public StatisticsAggregator getCallChainsInDefs() {
        return this.callChainsInDefs;
    }

    public StatisticsAggregator getCallChainsInContentStatements() {
        return this.callChainsInContentStatements;
    }

    public StatisticsAggregator getVariableExpressionsInContentStatements() {
        return this.variableExpressionsInContentStatements;
    }

    public StatisticsAggregator getMcCabe() {
        return this.mcCabe;
    }

    public int getEmptyLines() {
        return this.emptyLines;
    }

    public int getCommentLines() {
        return this.commentLines;
    }

    public int getCodeLines() {
        return this.codeLines;
    }

    public String getName() {
        return this.name;
    }

    public static void recordMetrics(Template template, long executionTime) {
        String file = System.getProperty("easy.vtl.metrics.file");
        if (Boolean.valueOf(System.getProperty("easy.vtl.metrics", "false")).booleanValue() || file != null) {
            TemplateLangMetricsVisitor.recordMetricsRec(template, executionTime, file);
        }
    }

    public static void clearProcessedImports() {
        processedImports.clear();
    }

    private static void recordMetricsRec(Template template, long executionTime, String file) {
        int i = 0;
        while (i < template.getImportsCount()) {
            ModelImport imp = template.getImport(i);
            if (!processedImports.contains(imp.getName()) && !imp.isWildcard()) {
                processedImports.add(imp.getName());
                Template imported = (Template)imp.getResolved();
                if (imported != null) {
                    TemplateLangMetricsVisitor.recordMetricsRec(imported, -1L, file);
                }
            }
            ++i;
        }
        TemplateLangMetricsVisitor.recordMetrics(template, executionTime, file);
    }

    private static void recordMetrics(Template template, long executionTime, String file) {
        block15: {
            try {
                TemplateLangMetricsVisitor metrics = new TemplateLangMetricsVisitor();
                template.accept(metrics);
                if (file != null && file.length() > 0) {
                    File f = new File(file);
                    boolean header = !f.exists() || f.length() == 0L;
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (PrintStream out = new PrintStream(new FileOutputStream(f, true));){
                            if (header) {
                                out.print("time\tname\texectime\tLOC\tCLOC\tELOC\tMcCabe\t");
                                TemplateLangMetricsVisitor.printStatisticsHeadline(out, metrics.getMcCabe());
                                out.print("#defs\t#builder\t");
                                TemplateLangMetricsVisitor.printStatisticsHeadline(out, metrics.getBuilderBlocksPerDef());
                                TemplateLangMetricsVisitor.printStatisticsHeadline(out, metrics.getCallChainsInDefs());
                                TemplateLangMetricsVisitor.printStatisticsHeadline(out, metrics.getCallChainsInContentStatements());
                                TemplateLangMetricsVisitor.printStatisticsHeadline(out, metrics.getVariableExpressionsInContentStatements());
                                out.println();
                            }
                            TemplateLangMetricsVisitor.printMetricsValue(out, System.currentTimeMillis());
                            TemplateLangMetricsVisitor.printMetricsValue(out, template.getName());
                            TemplateLangMetricsVisitor.printMetricsValue(out, executionTime);
                            TemplateLangMetricsVisitor.printMetricsValue(out, metrics.getCodeLines());
                            TemplateLangMetricsVisitor.printMetricsValue(out, metrics.getCommentLines());
                            TemplateLangMetricsVisitor.printMetricsValue(out, metrics.getEmptyLines());
                            TemplateLangMetricsVisitor.printMetricsValue(out, metrics.getMcCabe().getTotalSum());
                            TemplateLangMetricsVisitor.printStatistics(out, metrics.getMcCabe());
                            TemplateLangMetricsVisitor.printMetricsValue(out, metrics.getNumberOfDefs());
                            TemplateLangMetricsVisitor.printMetricsValue(out, metrics.getNumberOfBuilderBlockExpressions());
                            TemplateLangMetricsVisitor.printStatistics(out, metrics.getBuilderBlocksPerDef());
                            TemplateLangMetricsVisitor.printStatistics(out, metrics.getCallChainsInDefs());
                            TemplateLangMetricsVisitor.printStatistics(out, metrics.getCallChainsInContentStatements());
                            TemplateLangMetricsVisitor.printStatistics(out, metrics.getVariableExpressionsInContentStatements());
                            out.println();
                            break block15;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        Bundle.getLogger(VilTemplateProcessor.class).error("Writing metrics for '" + template.getName() + "': " + e.getMessage());
                    }
                    break block15;
                }
                System.out.println(String.valueOf(metrics) + " " + executionTime + "ms");
            }
            catch (VilException t) {
                Bundle.getLogger(VilTemplateProcessor.class).error("Calculating metrics for '" + template.getName() + "': " + t.getMessage());
            }
        }
    }

    private static void printMetricsValue(PrintStream out, Object value) {
        if (value instanceof Double || value instanceof Float) {
            value = value.toString().replace('.', ',');
        }
        out.print(value);
        out.print("\t");
    }

    private static void printStatisticsHeadline(PrintStream out, StatisticsAggregator stat) {
        out.print(stat.getName() + " min\t");
        out.print(stat.getName() + " avg\t");
        out.print(stat.getName() + " max\t");
    }

    private static void printStatistics(PrintStream out, StatisticsAggregator stat) {
        TemplateLangMetricsVisitor.printMetricsValue(out, stat.getAverageMin());
        TemplateLangMetricsVisitor.printMetricsValue(out, stat.getAverage());
        TemplateLangMetricsVisitor.printMetricsValue(out, stat.getAverageMax());
    }

    public static class StatisticsAggregator {
        private String name;
        private double avgMin;
        private double sum;
        private double avgMax;
        private int avgCount;
        private double avgSum;
        private double totalSum;

        public StatisticsAggregator(String name) {
            this.name = name;
        }

        public void reset() {
            this.avgMin = 0.0;
            this.sum = 0.0;
            this.avgMax = 0.0;
            this.avgCount = 0;
            this.avgSum = 0.0;
            this.totalSum = 0.0;
        }

        public String getName() {
            return this.name;
        }

        public void add(int value) {
            this.sum += (double)value;
            this.totalSum += (double)value;
        }

        public void aggregate() {
            this.avgMax = Math.max(this.avgMax, this.sum);
            this.avgSum += this.sum;
            this.avgMin = this.avgCount == 0 ? 0.0 : Math.min(this.avgMin, this.sum);
            ++this.avgCount;
            this.sum = 0.0;
        }

        public double getAverage() {
            return this.avgCount == 0 ? 0.0 : this.avgSum / (double)this.avgCount;
        }

        public double getAverageMin() {
            return this.avgMin;
        }

        public double getAverageMax() {
            return this.avgMax;
        }

        public int getAverageCount() {
            return this.avgCount;
        }

        public double getTotalSum() {
            return this.totalSum;
        }
    }
}

