/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.Writer;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.instantiation.core.model.common.IVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.common.WriterVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.AlternativeStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.BuilderBlockExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentAlternativeExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentImportExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentLoopExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentVarDeclExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.FlushStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.InContentExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.LoopStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.SwitchStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateCallExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.WhileStatement;

public class TemplateLangWriter
extends WriterVisitor<VariableDeclaration>
implements ITemplateLangVisitor {
    public TemplateLangWriter(Writer out) {
        super(out);
    }

    private int getNonDefaultJavaExtensionCount(Template template) {
        int count = 0;
        int e = 0;
        int n = template.getJavaExtensionCount();
        while (e < n) {
            if (!template.getJavaExtension(e).isDefault()) {
                ++count;
            }
            ++e;
        }
        return count;
    }

    @Override
    public Object visitTemplate(Template template) throws VilException {
        int i = 0;
        while (i < template.getImportsCount()) {
            ModelImport ref = template.getImport(i);
            this.printIndentation();
            this.printImportLeadin(ref);
            this.printVersionRestrictions(ref.getVersionRestriction(), false);
            this.println(";");
            ++i;
        }
        if (template.getImportsCount() > 0) {
            this.println();
        }
        int e = 0;
        while (e < template.getJavaExtensionCount()) {
            template.getJavaExtension(e).accept(this);
            ++e;
        }
        if (this.getNonDefaultJavaExtensionCount(template) > 0) {
            this.println();
        }
        int a = 0;
        while (a < template.getAdviceCount()) {
            template.getAdvice(a).accept(this);
            ++a;
        }
        this.printIndenationHint(template.getIndentationConfiguration());
        this.printFormattingHint(template.getFormattingConfiguration());
        this.printIndentation();
        this.print("template ");
        this.print(template.getName());
        this.printParameterList(template);
        if (template.getSuper() != null) {
            this.print(" extends ");
            this.print(template.getSuper().getName());
        }
        this.println(" {");
        int contained = template.getVariableDeclarationCount() + template.getDefCount() + TemplateLangWriter.o2i(template.getVersion()) + template.getTypedefCount() + template.getCompoundCount();
        if (contained > 0) {
            this.println();
            this.increaseIndentation();
            if (template.getVersion() != null) {
                this.printIndentation();
                this.printVersion(template.getVersion());
                this.println();
            }
            if (template.getTypedefCount() > 0) {
                this.printTypedefs(template);
                this.println();
            }
            if (template.getCompoundCount() > 0) {
                this.printCompounds(template);
                this.println();
            }
            int v = 0;
            while (v < template.getVariableDeclarationCount()) {
                template.getVariableDeclaration(v).accept((IVisitor)this);
                ++v;
            }
            if (template.getVariableDeclarationCount() > 0) {
                this.println();
            }
            int d = 0;
            while (d < template.getDefCount()) {
                if (d > 0) {
                    this.println();
                }
                template.getDef(d).accept(this);
                ++d;
            }
            this.decreaseIndentation();
            this.println();
        }
        this.printIndentation();
        this.println("}");
        return null;
    }

    private void printIndenationHint(IndentationConfiguration config) {
        if (config != null && config.isIndentationEnabled()) {
            this.printIndentation();
            this.print("@indent(");
            this.printIndentationHintEntry("indentation", config.getIndentationStep());
            if (config.isTabEmulationEnabled()) {
                this.print(", ");
                this.printIndentationHintEntry("tabEmulation", config.getTabEmulation());
            }
            if (config.getAdditional() != 1) {
                this.print(", ");
                this.printIndentationHintEntry("additional", config.getAdditional());
            }
            this.println(")");
        }
    }

    private void printFormattingHint(FormattingConfiguration config) {
        if (config != null) {
            this.printIndentation();
            this.print("@format(");
            this.printFormattingHintEntry("lineEnd", config.getLineEndingOrig());
            this.println(")");
        }
    }

    private void printIndentationHintEntry(String name, int value) {
        this.print(name);
        this.print(" = ");
        this.print(value);
    }

    private void printFormattingHintEntry(String name, String value) {
        this.print(name);
        this.print(" = ");
        this.print(StringUtils.convertToString((String)value));
    }

    @Override
    public Object visitJavaExtension(JavaExtension ext) throws VilException {
        if (!ext.isDefault()) {
            this.printIndentation();
            this.print("extension ");
            this.print(ext.getName());
            this.println(";");
        }
        return null;
    }

    @Override
    public Object visitDef(Def def) throws VilException {
        int a = 0;
        while (a < def.getAnnotationCount()) {
            this.printIndentation();
            this.print("@");
            this.print(def.getAnnotation(a));
            this.println();
            ++a;
        }
        this.printIndentation();
        if (def.isProtected()) {
            this.print("protected");
            this.printWhitespace();
        }
        this.print("def");
        this.printWhitespace();
        if (def.getSpecifiedType() != null) {
            this.printType(def.getSpecifiedType());
            this.print(" ");
        }
        this.print(def.getName());
        this.printParameterList(def);
        this.print(" ");
        this.visitTemplateBlock(def);
        this.println();
        return null;
    }

    @Override
    public Object visitTemplateBlock(TemplateBlock block) throws VilException {
        this.println("{");
        this.increaseIndentation();
        int b = 0;
        while (b < block.getBodyElementCount()) {
            block.getBodyElement(b).accept(this);
            ++b;
        }
        this.decreaseIndentation();
        this.printIndentation();
        this.print("}");
        return null;
    }

    @Override
    public Object visitAlternative(AlternativeStatement alternative) throws VilException {
        boolean ifIsBlock;
        this.printIndentation();
        this.print("if (");
        alternative.getCondition().accept(this);
        this.print(") ");
        boolean printIndentation = this.isPrintExpressionStatementIndentation();
        boolean lastIsBlock = ifIsBlock = alternative.getIfStatement().isBlock();
        this.setPrintExpressionStatementIndentation(ifIsBlock);
        alternative.getIfStatement().accept(this);
        if (alternative.getElseStatement() != null) {
            boolean elseIsBlock;
            if (!ifIsBlock) {
                this.increaseIndentation();
                this.printIndentation();
                this.decreaseIndentation();
            } else {
                this.print(" ");
            }
            this.print("else ");
            lastIsBlock = elseIsBlock = alternative.getElseStatement().isBlock();
            this.setPrintExpressionStatementIndentation(elseIsBlock);
            alternative.getElseStatement().accept(this);
        }
        this.setPrintExpressionStatementIndentation(printIndentation);
        if (lastIsBlock) {
            this.println();
        }
        return null;
    }

    private void printSeparatorExpression(Expression expression) throws VilException {
        if (expression != null) {
            this.print(", ");
            expression.accept(this);
        }
    }

    @Override
    public Object visitLoop(LoopStatement loop) throws VilException {
        this.printIndentation();
        this.print("for (");
        this.printType(loop.getIteratorVariable().getType());
        this.printWhitespace();
        this.print(loop.getIteratorVariable().getName());
        this.print(" : ");
        loop.getContainerExpression().accept(this);
        this.printSeparatorExpression(loop.getSeparatorExpression());
        if (loop.getSeparatorExpression() != null) {
            this.printSeparatorExpression(loop.getFinalSeparatorExpression());
        }
        this.print(") ");
        boolean printIndentation = this.isPrintExpressionStatementIndentation();
        boolean isStmtBlock = loop.getLoopStatement().isBlock();
        this.setPrintExpressionStatementIndentation(isStmtBlock);
        loop.getLoopStatement().accept(this);
        this.setPrintExpressionStatementIndentation(printIndentation);
        if (isStmtBlock) {
            this.println();
        }
        return null;
    }

    @Override
    public Object visitSwitch(SwitchStatement swtch) throws VilException {
        this.printIndentation();
        this.print("switch(");
        swtch.getSwitchExpression().accept(this);
        this.println(") {");
        this.increaseIndentation();
        int a = 0;
        while (a < swtch.getAlternativeCount()) {
            SwitchStatement.Alternative alt = swtch.getAlternative(a);
            this.printIndentation();
            if (alt.isDefault()) {
                this.print("default : ");
            } else {
                alt.getCondition().accept(this);
                this.print(" : ");
            }
            alt.getValue().accept(this);
            if (a + 1 < swtch.getAlternativeCount()) {
                this.println(",");
            } else {
                this.println();
            }
            ++a;
        }
        this.decreaseIndentation();
        this.printIndentation();
        this.println("}");
        return null;
    }

    @Override
    public Object visitContentStatement(ContentStatement cnt) throws VilException {
        this.printIndentation();
        String terminal = cnt.getTerminal();
        this.print(terminal);
        try {
            this.setInContent(true);
            cnt.getContent().accept(this);
            this.setInContent(false);
            this.print(terminal);
            boolean semi = false;
            ContentStatement.LineEndType leType = cnt.getLineEndType();
            if (ContentStatement.LineEndType.LINE_END == leType) {
                this.print(" <CR>");
                semi = true;
            } else if (ContentStatement.LineEndType.NO_LINE_END == leType) {
                this.print(" !<CR>");
                semi = true;
            }
            if (cnt.getIndentExpression() != null) {
                this.print(" | ");
                cnt.getIndentExpression().accept(this);
                semi = true;
            }
            if (semi) {
                this.print(";");
            }
            this.println();
        }
        catch (VilException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    @Override
    public Object visitTemplateCallExpression(TemplateCallExpression call) throws VilException {
        if (call.isSuper()) {
            this.print("super.");
        }
        if (call.getPrefix() != null) {
            this.print(call.getPrefix());
            this.print("::");
        }
        this.print(call.getName());
        this.printArgumentList(call, 0);
        return null;
    }

    @Override
    public Object visitWhile(WhileStatement stmt) throws VilException {
        this.printIndentation();
        this.print("while");
        this.printWhitespace();
        this.print("(");
        stmt.getConditionExpression().accept(this);
        this.print(")");
        this.printWhitespace();
        boolean printIndentation = this.isPrintExpressionStatementIndentation();
        boolean isStmtBlock = stmt.getLoopStatement().isBlock();
        this.setPrintExpressionStatementIndentation(isStmtBlock);
        stmt.getLoopStatement().accept(this);
        this.setPrintExpressionStatementIndentation(printIndentation);
        if (isStmtBlock) {
            this.println();
        }
        return null;
    }

    @Override
    public Object visitFlush(FlushStatement stmt) throws VilException {
        this.printIndentation();
        this.println("flush;");
        return null;
    }

    @Override
    public Object visitContentAlternativeExpression(ContentAlternativeExpression ex) throws VilException {
        this.print("${IF ");
        ex.getCondition().accept(this);
        this.print("}");
        this.printContentExpressions(ex.thenEx());
        if (ex.getElseExpressionsCount() > 0) {
            this.print("${ELSE}");
            this.printContentExpressions(ex.elseEx());
        }
        this.print("${ENDIF}");
        return null;
    }

    @Override
    public Object visitContentLoopExpression(ContentLoopExpression ex) throws VilException {
        this.print("${FOR ");
        this.print(ex.getIterator().getName());
        this.print(" : ");
        ex.getInit().accept(this);
        if (ex.getSeparator() != null) {
            this.print(" SEPARATOR \"");
            ex.getSeparator().accept(this);
            this.print("\"");
            if (ex.getEndSeparator() != null) {
                this.print(" END \"");
                ex.getEndSeparator().accept(this);
                this.print("\"");
            }
        }
        this.print("}");
        this.printContentExpressions(ex);
        this.print("${ENDFOR}");
        return null;
    }

    @Override
    protected boolean quoteExpression(Expression expression) {
        return !(expression instanceof InContentExpression);
    }

    @Override
    public Object visitContentVarDeclExpression(ContentVarDeclExpression ex) throws VilException {
        this.print("${VAR ");
        ex.getVariable().accept(this);
        this.println("}");
        return null;
    }

    @Override
    public Object visitContentImportExpression(ContentImportExpression ex) throws VilException {
        this.print("${IMPORT ");
        this.print(ex.getTemplate());
        this.printVersionRestrictions(ex.getVersionRestriction(), true);
        this.println("}");
        return null;
    }

    @Override
    public Object visitBuilderBlockExpression(BuilderBlockExpression ex) throws VilException {
        ex.getVariable().getExpression().accept(this);
        this.print(".(");
        switch (ex.getMode()) {
            case TYPE_NAME: {
                this.print(ex.getVariable().getType().getName());
                this.print(" ");
            }
            case NAME: {
                this.print(ex.getVariable().getName());
                this.print("|");
                break;
            }
        }
        this.print("{");
        TemplateBlock block = ex.getBlock();
        if (block.getBodyElementCount() > 0) {
            this.println();
            this.increaseIndentation();
            int e = 0;
            while (e < block.getBodyElementCount()) {
                block.getBodyElement(e).accept(this);
                ++e;
            }
            this.decreaseIndentation();
            this.printIndentation();
        }
        this.print("})");
        return null;
    }
}

