/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public abstract class AbstractListWrapper<T>
extends AbstractCollectionWrapper<T>
implements Collection<T> {
    private List<T> list;
    private TypeDescriptor<?> type;
    private TypeDescriptor<?>[] params;

    public AbstractListWrapper(List<T> list, TypeRegistry registry, boolean set, Class<?> param) {
        this.list = list;
        this.params = registry.convert(param);
        this.type = AbstractListWrapper.constructType(this.params, set);
    }

    public AbstractListWrapper(List<T> list, boolean set, TypeDescriptor<?> ... params) {
        this.list = list;
        this.params = params;
        this.type = AbstractListWrapper.constructType(this.params, set);
    }

    protected static <T> List<T> removeDuplicates(List<T> elements) {
        ArrayList<T> result;
        if (elements == null) {
            result = null;
        } else {
            result = new ArrayList<T>();
            HashSet<T> known = new HashSet<T>();
            int size = elements.size();
            int e = 0;
            while (e < size) {
                T element = elements.get(e);
                if (!known.contains(element)) {
                    result.add(element);
                    known.add(element);
                }
                ++e;
            }
        }
        return result;
    }

    protected List<T> getList() {
        return this.list;
    }

    protected TypeDescriptor<?>[] getGenericParameter() {
        return this.params;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.list == null ? 0 : this.list.size();
    }

    @Override
    public int getGenericParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        if (this.params == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[index];
    }

    @Override
    public TypeDescriptor<?> getType() {
        return this.type;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return StringValueHelper.getStringValue(this, comparator);
    }

    @Override
    public boolean allowSequenceAdjustment() {
        return true;
    }

    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Invisible
    public List<T> toMappedList() {
        ArrayList<T> result;
        if (this.list != null) {
            result = new ArrayList<T>(this.list.size());
            result.addAll(this.list);
        } else {
            result = null;
        }
        return result;
    }

    @Invisible
    public Set<T> toMappedSet() {
        HashSet<T> result;
        if (this.list != null) {
            result = new HashSet<T>(this.list.size());
            result.addAll(this.list);
        } else {
            result = null;
        }
        return result;
    }

    @Invisible
    public String toString() {
        return this.list.toString();
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

