/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractArrayWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.GenericArguments;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.NotOclCompliant;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetOperations;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ArraySet<T>
extends AbstractArrayWrapper<T>
implements Set<T> {
    public ArraySet(T[] array, Class<?> param) {
        this(array, param, TypeRegistry.DEFAULT);
    }

    public ArraySet(T[] array, Class<?> param, TypeRegistry registry) {
        super(ArraySet.removeDuplicates(array), true, registry.convert(param));
    }

    public ArraySet(T[] array, TypeDescriptor<?> ... params) {
        super(ArraySet.removeDuplicates(array), true, params);
    }

    @Invisible
    public static final <T extends IVilType> Set<T> empty(Class<T> param) {
        return ArraySet.empty(param, TypeRegistry.DEFAULT);
    }

    @Invisible
    public static final <T> Set<T> empty(Class<?> param, TypeRegistry registry) {
        return ArraySet.empty(registry.findType(param));
    }

    @Invisible
    public static final <T> Set<T> empty(TypeDescriptor<?> param) {
        TypeDescriptor<?>[] params = TypeDescriptor.createArray(1);
        params[0] = param;
        return new ArraySet<T>(null, params);
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> selectByType(TypeDescriptor<?> type) {
        return new ListSet(ArraySet.selectByType(this, type, false, false), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> selectByKind(TypeDescriptor<?> type) {
        return new ListSet(ArraySet.selectByType(this, type, true, false), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> typeReject(TypeDescriptor<?> type) {
        return new ListSet(ArraySet.selectByType(this, type, true, true), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> excluding(Collection<T> set) {
        return new ListSet(ArraySet.excluding(this, set), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> including(Collection<T> set) {
        return new ListSet<T>(ArraySet.including(this, set), this.getGenericParameter());
    }

    @Override
    public Set<?> flatten() throws VilException {
        ArrayList result = new ArrayList();
        ArraySet.flatten(this, result);
        return new ListSet(result, this.getFlattenedParams(this));
    }

    @Override
    public Set<T> select(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSet(ArraySet.select(this, evaluator, true), param);
    }

    @Override
    public Set<T> reject(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSet(ArraySet.select(this, evaluator, false), param);
    }

    @Override
    public Set<?> collect(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSet<Object>(ArraySet.collect(this, evaluator, true), param);
    }

    @Override
    public void forEach(ExpressionEvaluator evaluator) throws VilException {
        ArraySet.collect(this, evaluator, true);
    }

    @Override
    public Set<?> collectNested(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSet<Object>(ArraySet.collect(this, evaluator, false), param);
    }

    @Override
    public Set<?> closure(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new SetSet<Object>(ArraySet.closure(this, evaluator), param);
    }

    @Override
    public Object apply(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.apply(this, evaluator);
    }

    @Override
    @OperationMeta(name={"equals"})
    public boolean isEquals(Collection<?> elements) {
        return ArraySet.sameElements(this, elements);
    }

    @Override
    public Sequence<T> toSequence() {
        return new ArraySequence(this.getArray(), this.getGenericParameter());
    }

    @Override
    public Sequence<T> asSequence() {
        return this.toSequence();
    }

    @Override
    public Set<T> asSet() {
        return this;
    }

    @Override
    public T projectSingle() {
        return 1 == this.size() ? (T)this.getArray()[0] : null;
    }

    @Override
    @GenericArguments(value={0})
    public T add(T element) {
        this.extendCapacity(1);
        T[] array = this.getArray();
        array[array.length - 1] = element;
        return element;
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> union(Set<T> set) {
        return new ListSet<T>(ArraySet.union(this, set), this.getGenericParameter());
    }

    @Override
    @ReturnGenerics(value={IVilType.class})
    public Set<T> intersection(Set<T> set) {
        return new ListSet<T>(ArraySet.intersection(this, set), this.getGenericParameter());
    }

    @Override
    @NotOclCompliant(value={"sort"})
    @ReturnGenerics(value={IVilType.class})
    @OperationMeta(name={"sortedBy", "sort"})
    public Collection<T> sortedBy(ExpressionEvaluator evaluator) throws VilException {
        AbstractCollectionWrapper result = this.getArray() == null ? this : new ListSequence(this.sortImpl(evaluator), this.getGenericParameter());
        return result;
    }

    @Override
    public Set<T> difference(Set<T> set) {
        return new SetSet<T>(SetOperations.difference(this, set), this.getGenericParameter());
    }

    @Override
    public Set<T> symmetricDifference(Set<T> set) {
        return new SetSet<T>(SetOperations.symmetricDifference(this, set), this.getGenericParameter());
    }

    @Override
    public Set<T> cloneCollection() {
        return new ArraySet(this.getArray(), this.getGenericParameter());
    }
}

