/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IInitializableValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;

public class CompoundInstance
implements IInitializableValue,
IStringValueProvider {
    private CompoundTypeDescriptor type;
    private Map<String, Object> slotValues = new HashMap<String, Object>();

    public CompoundInstance(CompoundTypeDescriptor type) {
        this.type = type;
    }

    @Override
    public void initialize(IExpressionVisitor evaluator) throws VilException {
        this.initializeFor(evaluator, this.type);
    }

    private void initializeFor(IExpressionVisitor evaluator, CompoundTypeDescriptor type) throws VilException {
        if (type.getRefines() != null) {
            this.initializeFor(evaluator, type.getRefines());
        }
        int f = 0;
        while (f < type.getFieldCount()) {
            Expression initEx;
            FieldDescriptor field = type.getField(f);
            if (field instanceof CompoundTypeDescriptor.SlotDescriptor && !this.slotValues.containsKey(field.getName()) && (initEx = ((CompoundTypeDescriptor.SlotDescriptor)field).getExpression()) != null) {
                this.setSlotValue(field.getName(), initEx.accept(evaluator));
            }
            ++f;
        }
    }

    public CompoundTypeDescriptor getType() {
        return this.type;
    }

    public Object getSlotValue(String name) throws VilException {
        this.checkSlot(name);
        return this.slotValues.get(name);
    }

    private FieldDescriptor checkSlot(String name) throws VilException {
        FieldDescriptor field = null;
        CompoundTypeDescriptor iter = this.type;
        while (iter != null && field == null) {
            field = iter.getField(name);
            iter = iter.getRefines();
        }
        if (field == null) {
            throw new VilException("Slot '" + name + "' is not defined for type " + this.type.getVilName(), 50000);
        }
        return field;
    }

    public void setSlotValue(String name, Object value) throws VilException {
        FieldDescriptor field = this.checkSlot(name);
        this.slotValues.put(name, RuntimeEnvironment.checkType(field.getName(), field.getType(), value, this.type.getTypeRegistry(), null));
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return StringValueHelper.getStringValue(this.slotValues, comparator);
    }
}

