/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import net.ssehub.easy.instantiation.core.model.vilTypes.ClassEquivalentTo;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

@ClassEquivalentTo(value={Boolean.class})
@ClassMeta(name="Boolean")
public class PseudoBoolean
implements IVilType {
    @DefaultValue
    public static final Boolean DEFAULT = false;

    protected PseudoBoolean() {
    }

    @OperationMeta(opType=OperationType.INFIX)
    public static boolean and(boolean b1, boolean b2) {
        return b1 & b2;
    }

    @OperationMeta(opType=OperationType.INFIX)
    public static boolean or(boolean b1, boolean b2) {
        return b1 | b2;
    }

    @OperationMeta(opType=OperationType.INFIX)
    public static boolean xor(boolean b1, boolean b2) {
        return b1 ^ b2;
    }

    @OperationMeta(name={"!", "not"}, opType=OperationType.PREFIX)
    public static boolean not(boolean val) {
        return !val;
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(boolean b1, boolean b2) {
        return b1 == b2;
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean unequals(boolean b1, boolean b2) {
        return b1 ^ b2;
    }

    @OperationMeta(opType=OperationType.INFIX)
    public static boolean implies(boolean b1, boolean b2) {
        return !b1 || b2;
    }

    @OperationMeta(opType=OperationType.INFIX)
    public static boolean iff(boolean b1, boolean b2) {
        return !(b1 && !b2 || b2 && !b1);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static String toString(boolean b0) {
        return String.valueOf(b0);
    }

    public static TypeDescriptor<?> getType(Boolean value) {
        return TypeRegistry.booleanType();
    }
}

