/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import net.ssehub.easy.instantiation.core.model.vilTypes.ClassEquivalentTo;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassNotAssignable;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoReal;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

@ClassEquivalentTo(value={Integer.class})
@ClassNotAssignable(value={PseudoReal.class})
@ClassMeta(name="Integer")
public class PseudoInteger
extends PseudoReal {
    @DefaultValue
    public static final Integer DEFAULT = 0;

    protected PseudoInteger() {
    }

    @OperationMeta(name={"+"}, opType=OperationType.INFIX)
    public static int add(int i1, int i2) {
        return i1 + i2;
    }

    @OperationMeta(name={"-"}, opType=OperationType.INFIX)
    public static int subtract(int i1, int i2) {
        return i1 - i2;
    }

    @OperationMeta(name={"*"}, opType=OperationType.INFIX)
    public static int multiplication(int i1, int i2) {
        return i1 * i2;
    }

    @OperationMeta(name={"/"}, opType=OperationType.INFIX)
    public static double division(int i1, int i2) {
        return (double)i1 / (double)i2;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static int div(int i1, int i2) {
        return i1 / i2;
    }

    @OperationMeta(name={"<"}, opType=OperationType.INFIX)
    public static boolean lessThan(int i1, int i2) {
        return i1 < i2;
    }

    @OperationMeta(name={"<="}, opType=OperationType.INFIX)
    public static boolean lessEqualThan(int i1, int i2) {
        return i1 <= i2;
    }

    @OperationMeta(name={">="}, opType=OperationType.INFIX)
    public static boolean greaterEqualThan(int i1, int i2) {
        return i1 >= i2;
    }

    @OperationMeta(name={">"}, opType=OperationType.INFIX)
    public static boolean greaterThan(int i1, int i2) {
        return i1 > i2;
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(int i1, int i2) {
        return i1 == i2;
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean unequals(int i1, int i2) {
        return i1 != i2;
    }

    @OperationMeta(name={"-"}, opType=OperationType.PREFIX)
    public static int negates(int i0) {
        return -i0;
    }

    @OperationMeta(name={"abs"}, opType=OperationType.FUNCTION)
    public static int intAbs(int i0) {
        return Math.abs(i0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static String toHexString(int i0) {
        return Integer.toHexString(i0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static String toOctalString(int i0) {
        return Integer.toOctalString(i0);
    }

    @Invisible
    @Conversion
    public static double convert(int val) {
        return val;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static int mod(int i1, int i2) {
        return i1 % i2;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static int min(int i1, int i2) {
        return Math.min(i1, i2);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static int max(int i1, int i2) {
        return Math.max(i1, i2);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static String toString(int i0) {
        return String.valueOf(i0);
    }

    public static TypeDescriptor<?> getType(Integer value) {
        return TypeRegistry.integerType();
    }
}

