/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import net.ssehub.easy.instantiation.core.model.vilTypes.ClassEquivalentTo;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

@ClassEquivalentTo(value={Double.class})
@ClassMeta(name="Real")
public class PseudoReal
implements IVilType {
    @DefaultValue
    public static final Double DEFAULT = 0.0;

    protected PseudoReal() {
    }

    @OperationMeta(name={"+"}, opType=OperationType.INFIX)
    public static double add(double r1, double r2) {
        return r1 + r2;
    }

    @OperationMeta(name={"-"}, opType=OperationType.INFIX)
    public static double subtract(double r1, double r2) {
        return r1 - r2;
    }

    @OperationMeta(name={"*"}, opType=OperationType.INFIX)
    public static double multiplication(double r1, double r2) {
        return r1 * r2;
    }

    @OperationMeta(name={"/"}, opType=OperationType.INFIX)
    public static double division(double r1, double r2) {
        return r1 / r2;
    }

    @OperationMeta(name={"<"}, opType=OperationType.INFIX)
    public static boolean lessThan(double r1, double r2) {
        return r1 < r2;
    }

    @OperationMeta(name={"<="}, opType=OperationType.INFIX)
    public static boolean lessEqualThen(double r1, double r2) {
        return r1 <= r2;
    }

    @OperationMeta(name={">="}, opType=OperationType.INFIX)
    public static boolean greaterEqualThen(double r1, double r2) {
        return r1 >= r2;
    }

    @OperationMeta(name={">"}, opType=OperationType.INFIX)
    public static boolean greaterThan(double r1, double r2) {
        return r1 > r2;
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(double r1, double r2) {
        return r1 == r2;
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean unequals(double r1, double r2) {
        return r1 != r2;
    }

    @OperationMeta(name={"-"}, opType=OperationType.PREFIX)
    public static double negates(double r0) {
        return -r0;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static double abs(double r0) {
        return Math.abs(r0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static boolean isNaN(double r0) {
        return Double.isNaN(r0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static boolean isFinite(double r0) {
        return Math.abs(r0) <= Double.MAX_VALUE;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static boolean isInfinite(double r0) {
        return Double.isInfinite(r0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static int floor(double r0) {
        return (int)Math.floor(r0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static int ceil(double r0) {
        return (int)Math.ceil(r0);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static double min(double r1, double r2) {
        return Math.min(r1, r2);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static double max(double r1, double r2) {
        return Math.max(r1, r2);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static String toString(double r0) {
        return String.valueOf(r0);
    }

    public static TypeDescriptor<?> getType(Double value) {
        return TypeRegistry.realType();
    }
}

