/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class ReflectionFieldDescriptor
extends FieldDescriptor {
    private Field field;
    private boolean readOnly;

    public ReflectionFieldDescriptor(TypeDescriptor<?> declaringType, Field field, Class<?>[] typeGenerics) {
        this(declaringType, field, field.getName(), Modifier.isFinal(field.getModifiers()), typeGenerics);
    }

    public ReflectionFieldDescriptor(TypeDescriptor<?> declaringType, Field field, String name, Class<?>[] typeGenerics) {
        this(declaringType, field, name == null ? field.getName() : name, Modifier.isFinal(field.getModifiers()), typeGenerics);
    }

    public ReflectionFieldDescriptor(TypeDescriptor<?> declaringType, Field field, String name, boolean readOnly, Class<?>[] typeGenerics) {
        super(declaringType, name, ReflectionResolver.resolveType(field.getType(), typeGenerics));
        this.field = field;
        this.readOnly = readOnly;
    }

    @Override
    public String getJavaSignature() {
        return this.field.getType().getName() + " " + this.field.getName();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public Object getValue(Object owner) throws VilException {
        try {
            return this.field.get(owner);
        }
        catch (IllegalArgumentException e) {
            throw new VilException(e, 50502);
        }
        catch (IllegalAccessException e) {
            throw new VilException(e, 50502);
        }
    }

    @Override
    public void setValue(Object owner, Object value) throws VilException {
        try {
            this.field.set(owner, value);
        }
        catch (IllegalArgumentException e) {
            throw new VilException(e, 50502);
        }
        catch (IllegalAccessException e) {
            throw new VilException(e, 50502);
        }
    }
}

