/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ActualValueReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.AliasTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassEquivalentTo;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IDirectTypeRegistryAccess;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilGenericType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.IntHolder;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoIterator;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ResolvableOperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SignatureUtils;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.utils.JavaUtils;

public class TypeRegistry {
    public static final Object NULL = NullValue.VALUE;
    public static final Class<?>[] INVISIBLE_BY_DEFAULT = new Class[]{Object.class};
    public static final TypeRegistry DEFAULT = new TypeRegistry();
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(TypeRegistry.class, "net.ssehub.easy.instantiation.core");
    private static List<Runnable> deferredRegistrations = new ArrayList<Runnable>();
    private static final java.util.Map<String, List<Method>> INVISIBLE_INHERITED = new HashMap<String, List<Method>>();
    private java.util.Map<String, TypeDescriptor<?>> types = new HashMap();
    private java.util.Map<String, TypeDescriptor<? extends IVilType>> instantiators = new HashMap<String, TypeDescriptor<? extends IVilType>>();
    private java.util.Map<IDatatype, TypeDescriptor<?>> fallbacks = new HashMap();
    private TypeRegistry parentRegistry;
    private List<ITypeResolver> resolver;
    private IDirectTypeRegistryAccess directAccess;

    static {
        int i = 0;
        while (i < INVISIBLE_BY_DEFAULT.length) {
            Method[] methods = INVISIBLE_BY_DEFAULT[i].getDeclaredMethods();
            int m = 0;
            while (m < methods.length) {
                TypeRegistry.addInvisibleInherited(methods[m]);
                ++m;
            }
            ++i;
        }
        DEFAULT.register(ReflectionTypeDescriptor.ANY, null);
        DEFAULT.register(ReflectionTypeDescriptor.TYPE, PseudoType.class);
    }

    private TypeRegistry() {
    }

    public TypeRegistry(TypeRegistry parentRegistry) {
        this.parentRegistry = parentRegistry == null ? DEFAULT : parentRegistry;
        this.directAccess = new DirectAccess();
    }

    public TypeRegistry getParentRegistry() {
        return this.parentRegistry;
    }

    public void addTypeResolver(ITypeResolver resolver) {
        if (resolver != null) {
            if (this.resolver == null) {
                this.resolver = new ArrayList<ITypeResolver>();
            }
            if (!this.resolver.contains(resolver)) {
                this.resolver.add(0, resolver);
                resolver.setRegistryAccess(this.directAccess);
            }
        }
    }

    public boolean registerCompoundType(CompoundTypeDescriptor type) {
        boolean successful;
        String name = type.getName();
        if (this.findType(name) == null) {
            this.register(name, type);
            successful = true;
        } else {
            successful = false;
        }
        return successful;
    }

    public boolean hasTypeResolver(Class<? extends ITypeResolver> cls) {
        boolean found = false;
        if (this.resolver != null) {
            found = cls == null && !this.resolver.isEmpty();
            int r = 0;
            while (!found && r < this.resolver.size()) {
                found = cls.isInstance(this.resolver.get(r));
                ++r;
            }
        }
        return found;
    }

    public void removeTypeResolver(ITypeResolver resolver) {
        if (resolver != null && this.resolver != null) {
            this.resolver.remove(resolver);
        }
    }

    private static boolean addInvisibleInherited(Method method) {
        boolean contained;
        String sig = SignatureUtils.getJavaSignature(method);
        List<Method> registered = INVISIBLE_INHERITED.get(sig);
        if (registered == null) {
            registered = new ArrayList<Method>();
            INVISIBLE_INHERITED.put(sig, registered);
        }
        if (!(contained = registered.contains(method))) {
            registered.add(method);
        }
        return contained;
    }

    public <T extends IVilType> TypeDescriptor<T> registerType(Class<T> type) throws VilException {
        TypeDescriptor<Object> registered;
        String key = ReflectionTypeDescriptor.getRegName(type);
        Instantiator inst = type.getAnnotation(Instantiator.class);
        if (inst == null) {
            String msg;
            registered = this.getType(key);
            if (registered != null && (msg = ArtifactFactory.checkReplacement(registered.getTypeClass(), type)) != null) {
                throw new VilException(msg, 40001);
            }
        } else {
            String name = inst.value();
            if (name == null || name.length() == 0) {
                throw new VilException("instantiator annotation at " + type.getName() + "does not provide the instantiator name ", 40007);
            }
            registered = this.instantiators.get(name);
        }
        if (registered != null) {
            if (type.equals(registered.getTypeClass())) {
                throw new VilException("type '" + key + "' is already registered", 40001);
            }
            if (!registered.getTypeClass().isAssignableFrom(type)) {
                throw new VilException("type replacement requires subtype relationship " + String.valueOf(type), 40002);
            }
        }
        TypeRegistry.cacheInheritedAnnotations(type);
        ReflectionTypeDescriptor<T> desc = type.equals(PseudoType.class) ? (ReflectionTypeDescriptor<T>)ReflectionTypeDescriptor.TYPE : TypeRegistry.createTypeDescriptor(type);
        if (inst == null) {
            this.register(key, desc);
            if (!type.getSimpleName().equals(key)) {
                this.register(type.getName(), desc);
            }
            desc.resolve();
            this.registerEquivalentClasses(type, desc);
            ArtifactFactory.registered(type);
        } else {
            desc.resolve();
            TypeRegistry.testInstantiatorType(desc, inst);
            this.instantiators.put(inst.value(), desc);
        }
        return desc;
    }

    private static <T extends IVilType> ReflectionTypeDescriptor<T> createTypeDescriptor(Class<T> type) throws VilException {
        ReflectionTypeDescriptor<T> desc = null;
        if (IActualValueProvider.class.isAssignableFrom(type)) {
            try {
                desc = new ActualValueReflectionTypeDescriptor<T>(type.getDeclaredConstructor(new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (desc == null) {
            desc = new ReflectionTypeDescriptor<T>(type);
        }
        return desc;
    }

    private static void testInstantiatorType(TypeDescriptor<? extends IVilType> type, Instantiator inst) throws VilException {
        if (!JavaUtils.isJavaIdentifier((String)inst.value())) {
            throw new VilException("instantiator name '" + inst.value() + "' is not a valid identifier", 40008);
        }
        int constructorMethods = 0;
        int staticInstantiatorMethods = 0;
        int instanceInstantiatorMethods = 0;
        int o = 0;
        while (o < type.getOperationsCount()) {
            OperationDescriptor desc = type.getOperation(o);
            if (desc.isConstructor()) {
                ++constructorMethods;
            } else if (desc.getName().equals(inst.value())) {
                if (desc.isStatic()) {
                    ++staticInstantiatorMethods;
                } else {
                    ++instanceInstantiatorMethods;
                }
            }
            ++o;
        }
        if (staticInstantiatorMethods == 0 && instanceInstantiatorMethods == 0) {
            throw new VilException("no valid instantiator method declared in " + inst.value() + " (" + type.getTypeClass().getName() + ")'", 40009);
        }
        if (instanceInstantiatorMethods > 0 && constructorMethods == 0) {
            throw new VilException("no valid constructor method declared in instance instantiator " + inst.value() + " (" + type.getTypeClass().getName() + ")'", 40009);
        }
    }

    private <T extends IVilType> void register(TypeDescriptor<T> desc, Class<T> metaProvider) {
        this.register(desc.getName(), desc);
        if (metaProvider != null) {
            this.registerEquivalentClasses(metaProvider, desc);
        }
    }

    protected void register(String key, TypeDescriptor<?> desc) {
        TypeDescriptor<?> previous = this.types.put(key, desc);
        String prevString = "";
        if (previous != null) {
            prevString = " (overriding)";
        }
        LOGGER.info("registered type " + key + " -> " + desc.getName() + " " + desc.hashCode() + " " + prevString);
    }

    private <T extends IVilType> void registerEquivalentClasses(Class<T> type, TypeDescriptor<T> desc) {
        ClassEquivalentTo meta = type.getAnnotation(ClassEquivalentTo.class);
        if (meta != null && meta.value() != null) {
            Class<?>[] classArray = meta.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> eq = classArray[n2];
                if (eq != null) {
                    this.register(eq.getName(), desc);
                    if (!this.types.containsKey(eq.getSimpleName())) {
                        this.register(eq.getSimpleName(), desc);
                    }
                    String primitive = null;
                    if (Boolean.class == eq) {
                        primitive = "boolean";
                    } else if (Integer.class == eq) {
                        primitive = "int";
                    } else if (Long.class == eq) {
                        primitive = "long";
                    } else if (Float.class == eq) {
                        primitive = "float";
                    } else if (Double.class == eq) {
                        primitive = "double";
                    } else if (Character.class == eq) {
                        primitive = "char";
                    } else if (Short.class == eq) {
                        primitive = "short";
                    } else if (Byte.class == eq) {
                        primitive = "byte";
                    }
                    if (primitive != null) {
                        this.register(primitive, desc);
                    }
                }
                ++n2;
            }
        }
    }

    private static void cacheInheritedAnnotations(Class<?> cls) {
        try {
            if (cls != Object.class) {
                Class<?>[] interf;
                Method[] methods = cls.getDeclaredMethods();
                int m = 0;
                while (m < methods.length) {
                    Method method = methods[m];
                    Invisible inv = method.getAnnotation(Invisible.class);
                    if (inv != null && inv.inherit() && TypeRegistry.addInvisibleInherited(methods[m])) break;
                    ++m;
                }
                Class<?> superCls = cls.getSuperclass();
                if (superCls != null) {
                    TypeRegistry.cacheInheritedAnnotations(superCls);
                }
                if ((interf = cls.getInterfaces()) != null) {
                    int i = 0;
                    while (i < interf.length) {
                        TypeRegistry.cacheInheritedAnnotations(interf[i]);
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            EASyLoggerFactory.INSTANCE.getLogger(TypeRegistry.class, "net.ssehub.easy.instantiation.core").warn(e.getClass().getSimpleName() + " while caching inherited annotations: " + e.getMessage());
        }
    }

    static boolean hasInheritedInvisibleAnnotation(String signature, Class<?> cls) {
        boolean found = false;
        List<Method> methods = INVISIBLE_INHERITED.get(signature);
        if (methods != null) {
            int m = 0;
            while (!found && m < methods.size()) {
                found = methods.get(m).getDeclaringClass().isAssignableFrom(cls);
                ++m;
            }
        }
        return found;
    }

    public <T extends IVilType> TypeDescriptor<T> register(Class<T> type) {
        TypeDescriptor<T> result = null;
        try {
            result = this.registerType(type);
        }
        catch (VilException e) {
            LOGGER.error(e.getMessage());
        }
        return result;
    }

    public Iterable<TypeDescriptor<?>> allTypes() {
        java.util.Collection<TypeDescriptor<?>> result;
        if (this.parentRegistry == null) {
            result = this.types.values();
        } else {
            ArrayList tmp = new ArrayList();
            TypeRegistry iter = this;
            do {
                tmp.addAll(iter.types.values());
            } while ((iter = iter.parentRegistry) != null);
            result = tmp;
        }
        return result;
    }

    public Iterable<TypeDescriptor<? extends IVilType>> allInstantiators() {
        java.util.Collection<TypeDescriptor<? extends IVilType>> result;
        if (this.parentRegistry == null) {
            result = this.instantiators.values();
        } else {
            ArrayList<TypeDescriptor<? extends IVilType>> tmp = new ArrayList<TypeDescriptor<? extends IVilType>>();
            TypeRegistry iter = this;
            do {
                tmp.addAll(iter.instantiators.values());
            } while ((iter = iter.parentRegistry) != null);
            result = tmp;
        }
        return result;
    }

    public Iterable<TypeDescriptor<?>> typesByNamePrefix(String prefix) {
        ArrayList result = new ArrayList();
        for (TypeDescriptor<?> type : this.types.values()) {
            if (!type.getName().startsWith(prefix)) continue;
            result.add(type);
        }
        return result;
    }

    public TypeDescriptor<?> getTypeOrFallback(IDatatype type) {
        TypeDescriptor<?> result = this.getType(type);
        if (result == null) {
            result = this.fallbacks.get(type);
        }
        return result;
    }

    protected boolean allowFallbacks() {
        return DEFAULT != this;
    }

    public void registerFallbackType(IDatatype type, TypeDescriptor<?> descriptor) {
        if (type != null && descriptor != null && this.allowFallbacks()) {
            this.fallbacks.put(type, descriptor);
        }
    }

    public TypeDescriptor<?> getType(IDatatype type) {
        TypeDescriptor<?> result = null;
        if (this.parentRegistry != null) {
            result = this.parentRegistry.getType(type);
        }
        if (result == null && this.resolver != null) {
            int r = 0;
            while (result == null && r < this.resolver.size()) {
                result = this.resolver.get(r).resolveType(type);
                ++r;
            }
        }
        if (result == null && (result = this.getType(type.getName())) == null) {
            result = this.getType(type.getQualifiedName());
        }
        return result;
    }

    public TypeDescriptor<?>[] resolveGenerics(IDatatype type) {
        TypeDescriptor<?>[] result = null;
        if (type.getGenericTypeCount() > 0) {
            result = TypeDescriptor.createArray(type.getGenericTypeCount());
            int g = 0;
            while (result != null && g < type.getGenericTypeCount()) {
                result[g] = this.getType(type.getGenericType(g));
                if (result[g] == null) {
                    result = null;
                }
                ++g;
            }
        }
        return result;
    }

    public TypeDescriptor<?> getType(String name) {
        return this.getType(name, true);
    }

    public TypeDescriptor<?> getType(String name, boolean addIfMissing) {
        TypeDescriptor<?> result = this.findType(name);
        if (result == null) {
            result = this.resolve(name, addIfMissing);
        }
        return result;
    }

    private TypeDescriptor<?> findType(String name) {
        TypeDescriptor<?> result = null;
        if (result == null) {
            result = this.types.get(name);
        }
        if (result == null && this.parentRegistry != null) {
            result = this.parentRegistry.findType(name);
        }
        return result;
    }

    public boolean hasType(String name) {
        return this.findType(name) != null;
    }

    private TypeDescriptor<?> resolve(String name, boolean addIfMissing) {
        TypeDescriptor<?> result = null;
        if (this.resolver != null) {
            int r = 0;
            while (result == null && r < this.resolver.size()) {
                result = this.resolver.get(r).resolveType(name, addIfMissing);
                ++r;
            }
        }
        if (result == null && this.parentRegistry != null) {
            this.parentRegistry.resolve(name, addIfMissing);
        }
        return result;
    }

    public static final TypeDescriptor<? extends Map<?, ?>> getMapType(TypeDescriptor<?> ... parameter) throws VilException {
        return new ReflectionTypeDescriptor<Map>(Map.class, parameter).resolve();
    }

    public static final TypeDescriptor<? extends PseudoIterator<?>> getIteratorType(TypeDescriptor<?> ... parameter) throws VilException {
        return new ReflectionTypeDescriptor<PseudoIterator>(PseudoIterator.class, parameter).resolve();
    }

    public static final TypeDescriptor<? extends Collection<?>> getCollectionType(TypeDescriptor<?> ... parameter) throws VilException {
        return new ReflectionTypeDescriptor<Collection>(Collection.class, parameter).resolve();
    }

    public static final TypeDescriptor<? extends Set<?>> getSetType(TypeDescriptor<?> ... parameter) throws VilException {
        return new ReflectionTypeDescriptor<Set>(Set.class, parameter).resolve();
    }

    public static final TypeDescriptor<? extends Sequence<?>> getSequenceType(TypeDescriptor<?> ... parameter) throws VilException {
        return new ReflectionTypeDescriptor<Sequence>(Sequence.class, parameter).resolve();
    }

    public static final TypeDescriptor<? extends ResolvableOperationType> getRuleType(TypeDescriptor<?> ... parameter) throws VilException {
        return new ReflectionTypeDescriptor<ResolvableOperationType>(ResolvableOperationType.class, parameter).resolve();
    }

    public TypeDescriptor<? extends IVilType> getInstantiator(String name) {
        TypeDescriptor<? extends IVilType> result = null;
        if (this.parentRegistry != null) {
            result = this.parentRegistry.getInstantiator(name);
        }
        if (result == null) {
            result = this.instantiators.get(name);
        }
        if (result == null && this.resolver != null) {
            int r = 0;
            while (result == null && r < this.resolver.size()) {
                result = this.resolver.get(r).resolveInstantiator(name);
                ++r;
            }
            if (result != null) {
                this.instantiators.put(result.getName(), result);
            }
        }
        return result;
    }

    public static final TypeDescriptor<?> resolvableOperationType() {
        return DEFAULT.getType(ResolvableOperationType.class);
    }

    public static final TypeDescriptor<?> stringType() {
        return DEFAULT.getType("String");
    }

    public static final TypeDescriptor<?> booleanType() {
        return DEFAULT.getType("Boolean");
    }

    public static final TypeDescriptor<?> versionType() {
        return ReflectionTypeDescriptor.VERSION;
    }

    public static final TypeDescriptor<?> anyType() {
        return ReflectionTypeDescriptor.ANY;
    }

    public static final TypeDescriptor<?> voidType() {
        return ReflectionTypeDescriptor.VOID;
    }

    public static final TypeDescriptor<?> typeType() {
        return ReflectionTypeDescriptor.TYPE;
    }

    public static final TypeDescriptor<?> integerType() {
        return DEFAULT.getType("Integer");
    }

    public static final TypeDescriptor<?> realType() {
        return DEFAULT.getType("Real");
    }

    public TypeDescriptor<?> getType(Class<?> cls) {
        return this.getType(ReflectionTypeDescriptor.getRegName(cls), !TypeRegistry.isInternalType(cls));
    }

    public static boolean isInternalType(Class<?> cls) {
        if (cls.isArray()) {
            cls = cls.getComponentType();
        }
        String pName = cls.getPackage() == null ? "" : cls.getPackage().getName();
        return pName.startsWith(TypeRegistry.class.getPackage().getName());
    }

    public TypeDescriptor<?> findType(Class<?> cls) {
        return cls == null ? null : this.getType(ReflectionTypeDescriptor.getRegName(cls), !TypeRegistry.isInternalType(cls));
    }

    public TypeDescriptor<?> findType(Class<?> cls, boolean addIfMissing) {
        return cls == null ? null : this.getType(ReflectionTypeDescriptor.getRegName(cls), addIfMissing);
    }

    public TypeDescriptor<?>[] convert(Class<?> param) {
        TypeDescriptor<?>[] result;
        if (param == null) {
            result = null;
        } else {
            result = TypeDescriptor.createArray(1);
            result[0] = this.getType(param);
            if (result[0] == null) {
                result[0] = ReflectionTypeDescriptor.VOID;
            }
        }
        return result;
    }

    public TypeDescriptor<?>[] convert(Class<?> ... params) {
        TypeDescriptor<?>[] result;
        if (params == null || params.length == 0) {
            result = null;
        } else {
            result = TypeDescriptor.createArray(params.length);
            int p = 0;
            while (p < params.length) {
                result[p] = this.getType(params[p]);
                if (result[p] == null) {
                    result[p] = ReflectionTypeDescriptor.VOID;
                }
                ++p;
            }
        }
        return result;
    }

    public boolean forRuntime() {
        boolean result = false;
        if (this.parentRegistry != null) {
            result = this.parentRegistry.forRuntime();
        }
        return result;
    }

    public static final boolean equals(IMetaType t1, IMetaType t2) {
        boolean equals = false;
        if (t1 != null && t2 != null) {
            equals = t1.getName().equals(t2.getName());
            if (t1 instanceof TypeDescriptor && t2 instanceof TypeDescriptor) {
                TypeDescriptor td1 = (TypeDescriptor)t1;
                TypeDescriptor td2 = (TypeDescriptor)t2;
                if (td1.getGenericParameterCount() == td2.getGenericParameterCount()) {
                    int p = 0;
                    while (equals && p < td1.getGenericParameterCount()) {
                        equals = TypeRegistry.equals(td1.getGenericParameterType(p), td2.getGenericParameterType(p));
                        ++p;
                    }
                }
            }
            if (!equals) {
                IMetaType b2;
                IMetaType b1 = t1.getBaseType() == null ? t1 : t1.getBaseType();
                IMetaType iMetaType = b2 = t2.getBaseType() == null ? t2 : t2.getBaseType();
                if (b1 != t1 || b2 != t2) {
                    equals = TypeRegistry.equals(b1, b2);
                }
            }
        }
        return equals;
    }

    public static String toName(IMetaType type) {
        String result = type instanceof TypeDescriptor ? ((TypeDescriptor)type).getVilName() : type.getName();
        return result;
    }

    public static void addTypeMapping(String name, TypeDescriptor<? extends IVilType> type) {
        TypeRegistry.DEFAULT.types.put(name, type);
    }

    protected TypeDescriptor<?> getMappedType(Class<?> cls, Class<?>[] generics, IntHolder pos) {
        return null;
    }

    public TypeDescriptor<?> obtainTypeDescriptor(Object obj) {
        TypeDescriptor<?> result = null;
        if (obj instanceof IVilGenericType) {
            result = ((IVilGenericType)obj).getType();
        }
        if (result == null) {
            result = obj == null ? TypeRegistry.voidType() : this.findType(obj.getClass());
        }
        return result;
    }

    public <T> boolean addTypeAlias(String name, TypeDescriptor<T> type) throws VilException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (DEFAULT == this) {
            throw new IllegalArgumentException("this function cannot be applied to the default type registry");
        }
        boolean success = false;
        TypeDescriptor<?> existing = this.getType(name, false);
        if (existing == null || TypeRegistry.equals(type, existing)) {
            this.types.put(name, new AliasTypeDescriptor<T>(this, name, type));
            success = true;
        }
        return success;
    }

    public static void considerDeferredRegistration(Runnable runnable) {
        if (Environment.runsInEclipse()) {
            deferredRegistrations.add(runnable);
        } else {
            runnable.run();
        }
    }

    public static void runDeferredRegistrations() {
        for (Runnable r : deferredRegistrations) {
            r.run();
        }
        deferredRegistrations.clear();
    }

    private class DirectAccess
    implements IDirectTypeRegistryAccess {
        private DirectAccess() {
        }

        @Override
        public void add(String name, TypeDescriptor<?> type) {
            TypeRegistry.this.types.put(name, type);
        }

        @Override
        public boolean contains(String name) {
            return TypeRegistry.this.types.containsKey(name);
        }

        @Override
        public TypeDescriptor<?> get(String name) {
            return TypeRegistry.this.types.get(name);
        }

        @Override
        public void addInstantiator(String name, TypeDescriptor<? extends IVilType> type) {
            TypeRegistry.this.instantiators.put(name, type);
        }

        @Override
        public boolean containsInstantiator(String name) {
            return TypeRegistry.this.instantiators.containsKey(name);
        }
    }
}

