/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FakeTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlAnnotationFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlComparisonOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlConversionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Utils;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.NullValue;

abstract class AbstractIvmlTypeDescriptor
extends TypeDescriptor<DecisionVariable> {
    private TypeRegistry typeRegistry;
    private AbstractIvmlTypeDescriptor[] refines;

    AbstractIvmlTypeDescriptor() throws VilException {
        super(null);
    }

    AbstractIvmlTypeDescriptor(IDatatype ivmlType, IvmlTypeResolver resolver) throws VilException {
        super(resolver.getTypeRegistry().resolveGenerics(ivmlType));
        this.typeRegistry = resolver.getTypeRegistry();
        this.setName(ivmlType.getQualifiedName());
        resolver.addType(this.getName(), this);
        resolver.addType(this.getQualifiedName(), this);
    }

    protected void addDecisionVariableOperations(Map<String, OperationDescriptor> operations) {
        Method[] methods = DecisionVariable.class.getMethods();
        int m = 0;
        while (m < methods.length) {
            Method method = methods[m];
            if (AbstractIvmlTypeDescriptor.includeMethod(method)) {
                Utils.addOperation(new ReflectionOperationDescriptor(this, method, false), operations);
                String name = ReflectionTypeDescriptor.stripGetterPrefix(method.getName());
                if (name != null) {
                    Utils.addOperation(new ReflectionOperationDescriptor(this, method, name, false), operations);
                }
            }
            ++m;
        }
    }

    private static boolean includeMethod(Method method) {
        OperationMeta opMeta;
        int modifier = method.getModifiers();
        boolean include = Modifier.isPublic(modifier) && !Modifier.isAbstract(modifier);
        include &= method.getAnnotation(Invisible.class) == null;
        include &= method.getAnnotation(Conversion.class) == null;
        if ((include &= Object.class != method.getDeclaringClass()) && (opMeta = method.getAnnotation(OperationMeta.class)) != null && OperationType.INFIX == opMeta.opType()) {
            include = false;
        }
        return include;
    }

    protected void addComparisonOperations(IDatatype type, Map<String, OperationDescriptor> operations) {
        TypeDescriptor<?> paramType = TypeRegistry.DEFAULT.findType(IvmlElement.class);
        Utils.addOperation(new IvmlComparisonOperationDescriptor(this, "==", true, paramType), operations);
        Utils.addOperation(new IvmlComparisonOperationDescriptor(this, "!=", false, paramType), operations);
        Utils.addOperation(new IvmlComparisonOperationDescriptor(this, "<>", false, paramType), operations);
        if (TypeQueries.isEnum((IDatatype)type)) {
            Utils.addOperation(new IvmlComparisonOperationDescriptor(this, "==", true, this), operations);
            Utils.addOperation(new IvmlComparisonOperationDescriptor(this, "!=", false, this), operations);
            Utils.addOperation(new IvmlComparisonOperationDescriptor(this, "<>", false, this), operations);
        }
    }

    protected void addConversionOperations(IDatatype type, List<OperationDescriptor> operations) {
        if (TypeQueries.isEnum((IDatatype)type)) {
            TypeDescriptor<?> returnType = TypeRegistry.DEFAULT.findType(IvmlElement.class);
            operations.add(new IvmlConversionOperationDescriptor(this, returnType));
        }
        operations.add(new IvmlConversionOperationDescriptor(this));
    }

    protected void addAttributeFields(Map<String, FieldDescriptor> fields, IModelElement elt, TypeRegistry registry) throws VilException {
        IModelElement iter = elt;
        do {
            if (!(iter instanceof IAttributableElement)) continue;
            IAttributableElement aElt = (IAttributableElement)iter;
            int a = 0;
            while (a < aElt.getAttributesCount()) {
                Attribute attribute = aElt.getAttribute(a);
                Utils.addField(new IvmlAnnotationFieldDescriptor(this, attribute, registry), fields);
                ++a;
            }
        } while ((iter = iter.getParent()) != null);
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public Class<DecisionVariable> getTypeClass() {
        return DecisionVariable.class;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public DecisionVariable create(Object ... params) throws VilException {
        return null;
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        boolean result = type instanceof TypeDescriptor ? this.isAssignableFrom((TypeDescriptor)type) : false;
        return result;
    }

    @Override
    public boolean isCollection() {
        return this.isSet() || this.isSequence();
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public boolean isSequence() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public IMetaType getSuperType() {
        return this.refines != null && this.refines.length > 0 ? this.refines[0] : null;
    }

    AbstractIvmlTypeDescriptor getRefines(int index) {
        return this.refines[index];
    }

    int getRefinesCount() {
        return this.refines == null ? 0 : this.refines.length;
    }

    protected void setRefines(AbstractIvmlTypeDescriptor[] refines) {
        this.refines = refines;
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return !this.getClass().isInstance(type) && !FakeTypeDescriptor.class.isInstance(type);
    }

    @Invisible(inherit=true)
    protected abstract IDatatype getIvmlType();

    protected boolean isEqual(AbstractIvmlTypeDescriptor d1, AbstractIvmlTypeDescriptor d2) {
        return d1 == d2 || d1 != null && d2 != null && TypeQueries.sameTypes((IDatatype)d1.getIvmlType(), (IDatatype)d2.getIvmlType());
    }

    @Override
    public Object getDefaultValue() {
        return NullValue.INSTANCE;
    }
}

