/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableValueMapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;

public class InstanceNameValueMapper
implements IVariableValueMapper {
    private static final String VALID = "valid:";
    private static final String ENACTING = "enact:";
    private transient Map<String, Object> values = new HashMap<String, Object>();

    private boolean getBoolean(IvmlElement element, String prefix, boolean deflt) {
        Object val = this.values.get(element.getInstanceName());
        boolean result = val instanceof Boolean ? (Boolean)val : deflt;
        return result;
    }

    @Override
    public boolean isValid(IvmlElement element) {
        return this.getBoolean(element, VALID, true);
    }

    @Override
    public boolean isEnacting(IvmlElement element) {
        return this.getBoolean(element, ENACTING, false);
    }

    @Override
    public Object getValue(IvmlElement element) {
        return this.values.get(element.getInstanceName());
    }

    public void setValue(IvmlElement element, Object value) {
        this.setValue(element.getInstanceName(), value);
    }

    public void setValue(String name, Object value) {
        if (value == null) {
            this.values.remove(name);
        } else {
            this.values.put(name, value);
        }
    }

    public void setValid(IvmlElement element, Boolean value) {
        this.setValid(element.getInstanceName(), value);
    }

    public void setValid(String name, Boolean value) {
        this.setValue(VALID + name, (Object)value);
    }

    public void setEnacting(IvmlElement element, Boolean value) {
        this.setEnacting(element.getInstanceName(), value);
    }

    public void setEnacting(String name, Boolean value) {
        this.setValue(VALID + name, (Object)value);
    }

    public void clear() {
        this.values.clear();
    }
}

