/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeAssignmentProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlConfigurationConversionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlConfigurationFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class IvmlProjectTypeDescriptor
extends AbstractIvmlTypeDescriptor
implements IActualValueProvider,
IActualTypeAssignmentProvider {
    private Project project;

    IvmlProjectTypeDescriptor() throws VilException {
    }

    IvmlProjectTypeDescriptor(Project project, IvmlTypeResolver resolver) throws VilException {
        super(project.getType(), resolver);
        this.project = project;
        HashMap<String, OperationDescriptor> operations = new HashMap<String, OperationDescriptor>();
        HashMap<String, FieldDescriptor> fields = new HashMap<String, FieldDescriptor>();
        this.addDecisionVariableOperations(operations);
        this.addOperations(operations, fields, project, new HashSet<Project>());
        this.setOperations(operations.values());
        this.setFields(fields.values());
        ArrayList<OperationDescriptor> conversions = new ArrayList<OperationDescriptor>();
        conversions.add(new IvmlConfigurationConversionOperationDescriptor(this));
        this.setConversions(conversions);
    }

    private void addOperations(DecisionVariableDeclaration decl, Map<String, OperationDescriptor> operations, Map<String, FieldDescriptor> fields) {
        String name = decl.getName();
        if (!fields.containsKey(name)) {
            try {
                fields.put(name, new IvmlConfigurationFieldDescriptor(this, (AbstractVariable)decl, this.getTypeRegistry()));
            }
            catch (VilException ex) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception((Exception)((Object)ex));
            }
        }
    }

    private void addOperations(IDecisionVariableContainer cont, Map<String, OperationDescriptor> operations, Map<String, FieldDescriptor> fields) {
        int e = 0;
        while (e < cont.getElementCount()) {
            this.addOperations(cont.getElement(e), operations, fields);
            ++e;
        }
        int a = 0;
        while (a < cont.getAssignmentCount()) {
            this.addOperations((IDecisionVariableContainer)cont.getAssignment(a), operations, fields);
            ++a;
        }
    }

    private void addOperations(Map<String, OperationDescriptor> operations, Map<String, FieldDescriptor> fields, Project project, Set<Project> done) {
        if (!done.contains(project)) {
            done.add(project);
            int eCount = project.getElementCount();
            int e = 0;
            while (e < eCount) {
                ContainableModelElement elt = project.getElement(e);
                if (elt instanceof DecisionVariableDeclaration) {
                    this.addOperations((DecisionVariableDeclaration)elt, operations, fields);
                } else if (elt instanceof AttributeAssignment) {
                    this.addOperations((IDecisionVariableContainer)((AttributeAssignment)elt), operations, fields);
                }
                ++e;
            }
            int i = 0;
            while (i < project.getImportsCount()) {
                Project imp = (Project)project.getImport(i).getResolved();
                if (imp != null) {
                    this.addOperations(operations, fields, imp, done);
                }
                ++i;
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public boolean isAssignableFrom(TypeDescriptor<?> desc) {
        return desc == this || IvmlTypes.configurationType() == desc;
    }

    @Override
    public boolean isAssignableFrom(IMetaType type1, IMetaType type2) {
        return type1 == this && IvmlTypes.configurationType() == type2 || type2 == this && IvmlTypes.configurationType() == type1;
    }

    @Override
    public boolean isInstance(Object object) {
        boolean isInstance = false;
        if (object instanceof Configuration) {
            Configuration cfg = (Configuration)object;
            isInstance = cfg.getName().equals(this.project.getName());
        }
        return isInstance;
    }

    @Override
    public boolean isSameType(Object object) {
        boolean isSame = false;
        if (object instanceof Configuration) {
            Configuration cfg = (Configuration)object;
            isSame = cfg.getName().equals(this.project.getName());
        }
        return isSame;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public OperationDescriptor addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public Object determineActualValue(Object object) {
        Configuration cfg;
        if (object instanceof Configuration && !(cfg = (Configuration)object).getName().equals(this.project.getName())) {
            object = cfg.selectByProject(this.project.getName());
        }
        return object;
    }

    @Override
    public IMetaType getBaseType() {
        return null;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isInstantiator() {
        return false;
    }

    @Override
    protected IDatatype getIvmlType() {
        return this.project.getType();
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }
}

