/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.easyProducer.EasyLogLevel;
import java.io.File;
import java.util.List;

public class EasySetup {
    public static final String PLATFORM_META_MODEL_NAME = "IIPEcosphere";
    private File base;
    private File genTarget;
    private File ivmlMetaModelFolder;
    private File ivmlConfigFolder;
    private List<File> additionalIvmlFolders;
    private String ivmlModelName;
    private EasyLogLevel logLevel = EasyLogLevel.NORMAL;

    public static String getTestingEasyModelParent() {
        File easy;
        String result = ".";
        String cfgEasy = "configuration.easy";
        File current = new File("");
        if (current.getName().equals("configuration.easy") && (easy = new File("..", "configuration.easy")).isDirectory()) {
            result = easy.toString();
        }
        return result;
    }

    public void reset() {
        this.base = new File(".");
        this.genTarget = new File("gen");
        this.ivmlMetaModelFolder = new File("model");
        if (!this.ivmlMetaModelFolder.exists()) {
            this.ivmlMetaModelFolder = new File("src/main/easy");
        }
        if (!this.ivmlMetaModelFolder.exists()) {
            String parent = EasySetup.getTestingEasyModelParent();
            this.ivmlMetaModelFolder = new File(parent, "src/main/easy");
        }
        this.ivmlConfigFolder = null;
        this.additionalIvmlFolders = null;
        this.ivmlModelName = PLATFORM_META_MODEL_NAME;
    }

    public String getIvmlModelName() {
        return this.ivmlModelName;
    }

    public File getBase() {
        return this.base;
    }

    public File getGenTarget() {
        return this.genTarget;
    }

    public File getIvmlMetaModelFolder() {
        return this.ivmlMetaModelFolder;
    }

    public File getIvmlConfigFolder() {
        return this.ivmlConfigFolder;
    }

    public void setIvmlModelName(String ivmlModelName) {
        this.ivmlModelName = ivmlModelName;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void setGenTarget(File genTarget) {
        this.genTarget = genTarget;
    }

    public void setIvmlMetaModelFolder(File ivmlMetaModelFolder) {
        this.ivmlMetaModelFolder = ivmlMetaModelFolder;
    }

    public void setIvmlConfigFolder(File ivmlConfigFolder) {
        if (null == ivmlConfigFolder || null != ivmlConfigFolder && !this.ivmlMetaModelFolder.equals(ivmlConfigFolder)) {
            this.ivmlConfigFolder = ivmlConfigFolder;
        }
    }

    public EasyLogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(EasyLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public List<File> getAdditionalIvmlFolders() {
        return this.additionalIvmlFolders;
    }

    public void setAdditionalIvmlFolders(List<File> additionalIvmlFolders) {
        this.additionalIvmlFolders = additionalIvmlFolders;
    }
}

