/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasField;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasOperation;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSmeType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AbstractAasElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AasType
extends AbstractAasElement {
    public static final String PARENT_AAS = "*AAS*";
    private boolean allowDuplicates = false;
    private boolean ordered = false;
    private boolean fixedIdShort;
    private boolean isMultiValued;
    private AasSmeType smeType;
    private String parent;
    private List<AasField> fields = new ArrayList<AasField>();
    private List<AasOperation> operations = new ArrayList<AasOperation>();
    private EntityType entityType;
    private boolean isAspect;
    private Map<String, String> mappedSemanticIds = null;

    public AasType(String idShort, boolean fixedIdShort, boolean isMultiValued) {
        this.setIdShort(idShort);
        this.fixedIdShort = fixedIdShort;
        this.isMultiValued = isMultiValued;
    }

    AasType(AasType type) {
        super(type);
        this.allowDuplicates = type.allowDuplicates;
        this.ordered = type.ordered;
        this.fixedIdShort = type.fixedIdShort;
        this.isMultiValued = type.isMultiValued;
        this.smeType = type.smeType;
        this.parent = type.parent;
        for (AasField aasField : type.fields) {
            this.fields.add(new AasField(aasField));
        }
        for (AasField aasField : type.operations) {
            this.operations.add(new AasOperation(aasField));
        }
        this.entityType = type.entityType;
        this.isAspect = type.isAspect;
        if (null != type.mappedSemanticIds) {
            this.mappedSemanticIds = new HashMap<String, String>(type.mappedSemanticIds);
        }
    }

    public boolean isFixedIdShort() {
        return this.fixedIdShort;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public boolean isAspect() {
        return this.isAspect;
    }

    void setAspect(boolean isAspect) {
        this.isAspect = isAspect;
    }

    void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public AasSmeType getSmeType() {
        return this.smeType;
    }

    void setSmeType(AasSmeType smeType) {
        this.smeType = smeType;
    }

    void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    public boolean isAasParent() {
        return PARENT_AAS.equals(this.parent);
    }

    void addOperation(AasOperation operation) {
        this.addField(operation);
    }

    void addField(AasField field) {
        if (null != field) {
            if (AasSmeType.OPERATION == field.getSmeType()) {
                this.operations.add(new AasOperation(field));
            } else {
                this.fields.add(field);
            }
        }
    }

    public Iterable<AasField> fields() {
        return this.fields;
    }

    public boolean hasFields() {
        return this.fields.size() > 0;
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public Iterable<AasOperation> operations() {
        return this.operations;
    }

    public int getOperationsCount() {
        return this.operations.size();
    }

    boolean isLast(AasField field) {
        return this.fields.size() > 0 && this.fields.get(this.fields.size() - 1) == field;
    }

    void setMappedSemanticIds(Map<String, String> mappedSemanticIds) {
        if (null != mappedSemanticIds) {
            if (null == this.mappedSemanticIds) {
                this.mappedSemanticIds = mappedSemanticIds;
            } else {
                this.mappedSemanticIds.putAll(mappedSemanticIds);
            }
        }
    }

    public String getMappedSemanticId(String idShort) {
        return null == this.mappedSemanticIds ? null : this.mappedSemanticIds.get(idShort);
    }

    @Override
    public String toString() {
        return "AAStype: " + this.getIdShort();
    }

    public static enum EntityType {
        COMANAGEDENTITY("CoManagedEntity"),
        SELFMANAGEDENTITY("SelfManagedEntity");

        private String literal;

        private EntityType(String literal) {
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }

        public static EntityType fromText(String text) {
            EntityType result = null;
            if (null != text) {
                for (EntityType e : EntityType.values()) {
                    if (!text.contains(e.getLiteral())) continue;
                    result = e;
                    break;
                }
            }
            return result;
        }

        public static EntityType valueOfSafe(String value) {
            EntityType result = null;
            if (null != value) {
                try {
                    result = EntityType.valueOf(value);
                }
                catch (IllegalArgumentException ex) {
                    for (EntityType e : EntityType.values()) {
                        if (!e.getLiteral().equalsIgnoreCase(value)) continue;
                        result = e;
                        break;
                    }
                }
            }
            return result;
        }
    }
}

