/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.ivml;

import de.iip_ecosphere.platform.configuration.cfg.ConfigurationChangeType;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.DecisionVariableProvider;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.GraphFactory;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.GraphFormat;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlGraphMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh.ServiceMeshGraphMapper;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.uni_hildesheim.sse.ConstraintSyntaxException;
import de.uni_hildesheim.sse.ModelUtility;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ChangeHistory;
import net.ssehub.easy.producer.core.mgmt.EasyExecutor;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.sseReasoner.model.SubstitutionVisitor;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ConstantDecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.IvmlModelQuery;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.model.values.VersionValue;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public abstract class AbstractIvmlModifier
implements DecisionVariableProvider {
    public static final Predicate<Project> NO_PROJECT_FILTER = p -> true;
    public static final Predicate<Project> NO_TEMPLATE_FILTER = p -> !IvmlUtils.isTemplate(p);
    private static final IVMLWriter.EmitFilter EMIT_FILTER = (var, val) -> {
        boolean emit = true;
        emit &= !ConstraintType.isConstraint((IDatatype)var.getType());
        emit &= val != NullValue.INSTANCE;
        if (var.getDefaultValue() instanceof ConstantValue) {
            emit &= !Value.equals((Value)val, (Value)((ConstantValue)var.getDefaultValue()).getConstantValue());
        }
        return emit;
    };
    private IvmlGraphMapper graphMapper;
    private Map<String, GraphFormat> graphFormats = new HashMap<String, GraphFormat>();
    private ConfigurationChangeListener changeListener;
    private Set<String> reservedVariableNames = new HashSet<String>();

    public AbstractIvmlModifier(IvmlGraphMapper graphMapper, ConfigurationChangeListener changeListener) {
        if (null == graphMapper) {
            throw new IllegalArgumentException("graphMapper must not be null");
        }
        this.graphMapper = graphMapper;
        this.changeListener = changeListener;
    }

    public void addGraphFormat(GraphFormat format) {
        if (null != format) {
            this.graphFormats.put(format.getName(), format);
        }
    }

    public GraphFactory getGraphFactory() {
        return this.graphMapper.getGraphFactory();
    }

    protected static void saveTo(Project prj, File file) throws ExecutionException {
        AbstractIvmlModifier.getLogger().info("Writing IVML project {} to file {}", (Object)prj.getName(), (Object)file);
        file.getParentFile().mkdirs();
        try (FileWriter fWriter = new FileWriter(file);){
            AbstractIvmlModifier.write(prj, fWriter);
            fWriter.close();
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    private static void write(Project prj, Writer out) {
        IVMLWriter writer = new IVMLWriter(out);
        writer.setFormatInitializer(true);
        writer.setEmitProjectFreezeDot(true);
        writer.setEmitFilter(EMIT_FILTER);
        prj.accept((IModelVisitor)writer);
    }

    protected abstract String getIvmlSubpath(Project var1);

    protected abstract File createIvmlConfigPath(String var1, Project var2);

    protected File getIvmlFile(Project project) {
        return this.createIvmlConfigPath(this.getIvmlSubpath(project), project);
    }

    protected boolean isAllowedForModification(Project prj) {
        return false;
    }

    public void deleteVariable(String varName) throws ExecutionException {
        AbstractIvmlModifier.getLogger().info("Deleting IVML variable {}", (Object)varName);
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        try {
            Project prj;
            AbstractVariable var = ModelQuery.findVariable((IResolutionScope)root, (String)varName, null);
            if (null != var) {
                prj = var.getProject();
                String subpath = this.getIvmlSubpath(prj);
                if (subpath == null && prj != root && !this.isAllowedForModification(prj)) {
                    throw new ExecutionException("Project " + prj.getName() + " is not allowed for modification", null);
                }
            } else {
                throw new ExecutionException("Cannot find variable " + varName, null);
            }
            this.removeConstraintsForVariable(prj, var);
            prj.removeElement((ContainableModelElement)var);
            IDecisionVariable dVar = cfg.getDecision(var);
            cfg.removeDecision(dVar);
            this.notifyChange(dVar, ConfigurationChangeType.DELETED);
            ReasoningResult res = this.validateAndPropagate(NO_TEMPLATE_FILTER);
            this.throwIfFails(res, true);
            AbstractIvmlModifier.saveTo(prj, this.getIvmlFile(prj));
            AbstractIvmlModifier.getLogger().info("Deleted IVML variable {}", (Object)varName);
        }
        catch (ModelQueryException e) {
            throw new ExecutionException(e);
        }
    }

    public String getTemplates() throws ExecutionException {
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        List result = IvmlUtils.findTemplates(root).stream().map(var -> var.getName()).collect(Collectors.toList());
        return JsonUtils.toJson(result);
    }

    private static <K, V> V getOrCreate(HashMap<K, V> hash, K key, Supplier<V> creator) {
        V result = hash.get(key);
        if (null == result) {
            result = creator.get();
            hash.put(key, result);
        }
        return result;
    }

    private void instantiateMeshes(Set<IDecisionVariable> meshes, Mode mode, InstantiationContext context) throws ExecutionException, ConfigurationException, ModelQueryException, ModelManagementException {
        for (IDecisionVariable e : meshes) {
            AbstractVariable decl = e.getDeclaration();
            context.currentTemplateVariable = decl.getName();
            this.instantiateTemplateVariable(e, decl.getType().getName(), null, mode, context);
        }
    }

    public String instantiateTemplate(String varName, String appName, Map<String, String> adjustments) throws ExecutionException {
        String result = "";
        AbstractIvmlModifier.getLogger().info("Instantiating template {} to {} with value adjustments {}", new Object[]{varName, appName, adjustments});
        if (!AbstractIvmlModifier.isValidIdentifier(appName)) {
            throw new ExecutionException("'" + appName + "' is not a valid identifier", null);
        }
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        Optional<AbstractVariable> templateVarOpt = IvmlUtils.findTemplates(root).stream().filter(var -> var.getName().equals(varName)).findFirst();
        if (templateVarOpt.isPresent()) {
            InstantiationContext context = new InstantiationContext(adjustments);
            try {
                AbstractVariable templateVar = templateVarOpt.get();
                IDecisionVariable template = cfg.getDecision(templateVar);
                IDecisionVariable templateMeshes = template.getNestedElement("services");
                ServiceMeshGraphMapper mapper = new ServiceMeshGraphMapper();
                Set<IDecisionVariable> consts = this.collectConstants(cfg, templateVar.getProject());
                HashSet<IDecisionVariable> types = new HashSet<IDecisionVariable>();
                HashSet<IDecisionVariable> services = new HashSet<IDecisionVariable>();
                HashMap meshes = new HashMap();
                for (int n = 0; n < templateMeshes.getNestedElementsCount(); ++n) {
                    IDecisionVariable mesh = IvmlUtils.dereference(templateMeshes.getNestedElement(n));
                    Set meshElts = AbstractIvmlModifier.getOrCreate(meshes, mesh, () -> new HashSet());
                    IvmlGraphMapper.IvmlGraph graph = mapper.getGraphFor(mesh);
                    for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : graph.nodes()) {
                        IDecisionVariable var2 = ivmlGraphNode.getVariable();
                        meshElts.add(var2);
                        IDecisionVariable impl = IvmlUtils.dereference(var2.getNestedElement("impl"));
                        if (null != impl) {
                            services.add(impl);
                            this.collectTypes(impl.getNestedElement("input"), types);
                            this.collectTypes(impl.getNestedElement("output"), types);
                            this.collectTypes(impl.getNestedElement("inInterface"), types);
                            this.collectTypes(impl.getNestedElement("outInterface"), types);
                        }
                        ivmlGraphNode.outEdges().forEach(e -> meshElts.add(IvmlUtils.dereference(e.getVariable())));
                    }
                }
                this.instantiateVariables(consts, "AllConstants", context);
                this.instantiateVariables(types, "AllTypes", context);
                context.appPrefix = appName;
                context.enableNameAdjustment = true;
                this.instantiateVariables(services, "AllServices", context);
                for (IDecisionVariable m : meshes.keySet()) {
                    context.currentTemplateVariable = m.getDeclaration().getName();
                    this.instantiateTemplateVariable(m, "ServiceMesh", null, Mode.CREATE_SETTARGET, context);
                    this.instantiateMeshes((Set)meshes.get(m), Mode.CREATE, context);
                    this.instantiateMeshes((Set)meshes.get(m), Mode.SET_VALUE, context);
                    context.currentTemplateVariable = m.getDeclaration().getName();
                    context.meshes.add(this.instantiateTemplateVariable(m, "ServiceMesh", null, Mode.SET_VALUE, context));
                    context.targetProject = null;
                }
                context.appPrefix = null;
                context.currentTemplateVariable = varName;
                IDecisionVariable tmp = this.instantiateTemplateVariable(cfg.getDecision(templateVar), "Application", appName, Mode.BOTH, context);
                if (null != tmp) {
                    result = tmp.getDeclaration().getName();
                    IDecisionVariable derivedFrom = tmp.getNestedElement("derivedFrom");
                    derivedFrom.setValue(ValueFactory.createValue((IDatatype)derivedFrom.getDeclaration().getType(), (Object[])new Object[]{templateVar.getName()}), (IAssignmentState)AssignmentState.ASSIGNED);
                }
                ReasoningResult res = this.validateAndPropagate(NO_TEMPLATE_FILTER);
                this.throwIfFails(res, true);
                for (Project p : context.modified) {
                    AbstractIvmlModifier.saveTo(p, this.getIvmlFile(p));
                }
                AbstractIvmlModifier.getLogger().info("Instantiated template {} to {} with value adjustments {}", new Object[]{varName, appName, adjustments});
            }
            catch (ModelManagementException | ConfigurationException | ModelQueryException | ValueDoesNotMatchTypeException e2) {
                throw new ExecutionException(e2);
            }
        } else {
            throw new ExecutionException("Cannot find template " + varName, null);
        }
        return result;
    }

    private void collectTypes(IDecisionVariable var, Set<IDecisionVariable> result) {
        if (null != var) {
            for (int n = 0; n < var.getNestedElementsCount(); ++n) {
                IDecisionVariable ioType = var.getNestedElement(n);
                IDecisionVariable typeRef = ioType.getNestedElement("type");
                if (null == typeRef) continue;
                result.add(IvmlUtils.dereference(typeRef));
            }
        }
    }

    private Set<IDecisionVariable> collectConstants(Configuration cfg, Project prj) {
        HashSet<IDecisionVariable> result = new HashSet<IDecisionVariable>();
        IvmlUtils.iterElements(prj, AbstractVariable.class, v -> {
            IDecisionVariable decVar;
            if (v.isConstant() && (decVar = cfg.getDecision(v)) != null) {
                result.add(decVar);
            }
        });
        return result;
    }

    private Map<String, IDecisionVariable> mapElementsByName(Configuration cfg, Project prj) {
        HashMap<String, IDecisionVariable> result = new HashMap<String, IDecisionVariable>();
        IvmlUtils.iterElements(prj, AbstractVariable.class, v -> {
            IDecisionVariable decVar = cfg.getDecision(v);
            String name = AbstractIvmlModifier.getName(decVar, null);
            if (null != name) {
                result.put(name, decVar);
            }
        });
        return result;
    }

    private static String getName(IDecisionVariable var, String dflt) {
        Value val;
        IDecisionVariable nameVar;
        String result = dflt;
        if (null != var && null != (nameVar = var.getNestedElement("name")) && (val = nameVar.getValue()) instanceof StringValue) {
            result = ((StringValue)val).getValue();
        }
        return result;
    }

    private void instantiateVariables(Set<IDecisionVariable> vars, String targetPrj, InstantiationContext context) throws ConfigurationException, ExecutionException {
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        Project target = IvmlModelQuery.findProject((Project)root, (String)targetPrj);
        Map<String, IDecisionVariable> known = this.mapElementsByName(cfg, target);
        for (IDecisionVariable t : vars) {
            String tName = AbstractIvmlModifier.getName(t, null);
            if (null == tName || known.containsKey(tName)) continue;
            AbstractVariable tDecl = t.getDeclaration();
            DecisionVariableDeclaration var = new DecisionVariableDeclaration(context.prefixVarName(tDecl.getName()), tDecl.getType(), (IModelElement)target);
            context.currentTemplateVariable = t.getDeclaration().getName();
            this.addNameAdjustment(t, context.currentTemplateVariable, context);
            this.setValue(var, t.getValue(), context);
            target.addBeforeFreeze((ContainableModelElement)var);
            IDecisionVariable dVar = cfg.createDecision((AbstractVariable)var);
            this.notifyChange(dVar, ConfigurationChangeType.CREATED);
            context.substitutions.put(t.getDeclaration(), (AbstractVariable)var);
            context.modified.add(target);
        }
    }

    private void setValue(DecisionVariableDeclaration var, Value val, InstantiationContext context) throws ExecutionException {
        try {
            ValueAdjustmentVisitor adj = new ValueAdjustmentVisitor(context);
            val.clone().accept((IValueVisitor)adj);
            ConstantValue cst = new ConstantValue(adj.value);
            cst.inferDatatype();
            var.setValue((ConstraintSyntaxTree)cst);
        }
        catch (CSTSemanticException | ValueDoesNotMatchTypeException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    private IDecisionVariable instantiateTemplateVariable(IDecisionVariable decVar, String targetType, String varName, Mode mode, InstantiationContext context) throws ModelManagementException, ModelQueryException, ConfigurationException, ExecutionException {
        varName = null == varName ? context.currentTemplateVariable : varName;
        IDecisionVariable result = null;
        String varNameId = context.prefixVarName(AbstractIvmlModifier.toIdentifier(varName));
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        IDatatype appType = this.findType(root, targetType);
        Project appPrj = this.adaptTarget(root, null == context.targetProject ? this.getVariableTarget(root, appType, varName, context.getMeshNames()) : context.targetProject);
        if (null != appType) {
            DecisionVariableDeclaration var;
            if (mode.create) {
                var = new DecisionVariableDeclaration(varNameId, appType, (IModelElement)appPrj);
                if (Mode.CREATE_SETTARGET == mode) {
                    context.targetProject = appPrj;
                }
                appPrj.addBeforeFreeze((ContainableModelElement)var);
                context.substitutions.put(decVar.getDeclaration(), (AbstractVariable)var);
                this.addNameAdjustment(decVar, varName, context);
            } else {
                var = (DecisionVariableDeclaration)appPrj.getElement(varNameId);
            }
            if (mode.setValue) {
                this.setValue(var, decVar.getValue(), context);
                result = cfg.createDecision((AbstractVariable)var);
                this.notifyChange(result, ConfigurationChangeType.CREATED);
                context.modified.add(appPrj);
            }
        }
        return result;
    }

    private void addNameAdjustment(IDecisionVariable decVar, String varName, InstantiationContext context) {
        String value;
        String nameSlot;
        if (context.enableNameAdjustment && !context.adjustments.containsKey(nameSlot = varName + ".name") && null != (value = IvmlUtils.getVarNameSafe(decVar.getDeclaration(), null))) {
            context.adjustments.put(nameSlot, context.prefixVarName(value));
        }
    }

    public String getOpenTemplateVariables(String varName) throws ExecutionException {
        ReasoningResult res = this.validateAndPropagate(NO_PROJECT_FILTER);
        return JsonUtils.toJson(IvmlUtils.analyzeForTemplate(res, varName));
    }

    protected void throwIfFails(ReasoningResult res, boolean reloadIfFail) throws ExecutionException {
        boolean hasConflict = IvmlUtils.analyzeReasoningResult(res, false, false);
        if (hasConflict) {
            if (reloadIfFail) {
                this.reloadConfiguration();
            }
            Object msg = "";
            if (null != res) {
                for (int m = 0; m < res.getMessageCount(); ++m) {
                    if (((String)msg).length() > 0) {
                        msg = (String)msg + "\n";
                    }
                    Message rmsg = res.getMessage(m);
                    msg = (String)msg + rmsg.getDescription();
                    msg = (String)msg + String.valueOf(rmsg.getConflictComments());
                    msg = (String)msg + String.valueOf(rmsg.getConflictSuggestions());
                    for (int v = 0; v < res.getAffectedVariablesCount(); ++v) {
                        if (v > 0) {
                            msg = (String)msg + ", ";
                        }
                        msg = (String)msg + res.getAffectedVariable(v).getQualifiedName();
                    }
                }
                EasyExecutor.printReasoningMessages((ReasoningResult)res);
            } else {
                msg = "Internal reasoning issue. Please check logs.";
            }
            AbstractIvmlModifier.getLogger().error("Reasoning failed: {}", msg);
            throw new ExecutionException((String)msg, null);
        }
    }

    protected void removeConstraintsForVariable(Project prj, AbstractVariable var) {
        for (int e = 0; e < prj.getElementCount(); ++e) {
            OCLFeatureCall call;
            Constraint c;
            ConstraintSyntaxTree cst;
            ContainableModelElement elt = prj.getElement(e);
            if (!(elt instanceof Constraint) || !((cst = (c = (Constraint)elt).getConsSyntax()) instanceof OCLFeatureCall) || !"=".equals((call = (OCLFeatureCall)cst).getOperation()) || !(call.getOperand() instanceof Variable) || ((Variable)call.getOperand()).getVariable() != var) continue;
            c.getProject().removeElement((ContainableModelElement)c);
        }
    }

    protected Project getVariableTarget(Project root, IDatatype type, String name, List<String> meshes) throws ExecutionException {
        return root;
    }

    protected Project adaptTarget(Project root, Project project) throws ExecutionException {
        return project;
    }

    static boolean isValidIdentifier(String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getVariableName(String type, String elementName, String elementVersion) {
        String separator = "_";
        Object varName = type + "_" + elementName;
        if (elementVersion.length() > 0) {
            varName = (String)varName + "_" + elementVersion;
        }
        StringBuilder builder = new StringBuilder((String)varName);
        for (int i = builder.length() - 1; i >= 0; --i) {
            if (Character.isJavaIdentifierPart(builder.charAt(i))) continue;
            builder.deleteCharAt(i);
        }
        varName = builder.toString();
        if ("_".equals(varName)) {
            varName = "unknown";
        }
        if (!Character.isJavaIdentifierStart(((String)varName).charAt(0))) {
            varName = "a" + (String)varName;
        }
        if (Character.isUpperCase(((String)varName).charAt(0))) {
            varName = Character.toLowerCase(((String)varName).charAt(0)) + ((String)varName).substring(1);
        }
        Configuration cfg = this.getIvmlConfiguration();
        try {
            String baseName = (String)varName + "_";
            int count = 1;
            while (cfg.getDecision((String)varName, false) != null || this.reservedVariableNames.contains(varName)) {
                varName = baseName + String.format("%02d", count++);
            }
        }
        catch (ModelQueryException modelQueryException) {
            // empty catch block
        }
        this.reservedVariableNames.add((String)varName);
        return varName;
    }

    public void renameVariable(String varName, String newVarName) throws ExecutionException {
        if (varName.length() > 0 && newVarName.length() > 0 && !newVarName.equals(varName)) {
            AbstractIvmlModifier.getLogger().info("Renaming IVML variable {} to {}", (Object)varName, (Object)newVarName);
            Configuration cfg = this.getIvmlConfiguration();
            Project root = cfg.getProject();
            try {
                AbstractVariable var = IvmlModelQuery.findVariable((IResolutionScope)root, (String)varName, null);
                cfg.renameVariable(var, AbstractIvmlModifier.toIdentifier(newVarName));
                ReasoningResult res = this.validateAndPropagate(NO_TEMPLATE_FILTER);
                this.throwIfFails(res, true);
                Set<Project> projects = IvmlUtils.findProjectsUsingVariable(root, var);
                for (Project p : projects) {
                    AbstractIvmlModifier.saveTo(p, this.getIvmlFile(p));
                }
                AbstractIvmlModifier.getLogger().info("Renamed IVML variable {} to {}", (Object)varName, (Object)newVarName);
            }
            catch (ModelQueryException e) {
                throw new ExecutionException(e);
            }
        } else {
            AbstractIvmlModifier.getLogger().info("Skipped renaming IVML variable {} to {} as not given/same.", (Object)varName, (Object)newVarName);
        }
    }

    public void createVariable(String varName, String type, boolean asConst, String valueEx) throws ExecutionException {
        if (!AbstractIvmlModifier.isValidIdentifier(varName)) {
            throw new ExecutionException("'" + varName + "' is not a valid identifier", null);
        }
        AbstractIvmlModifier.getLogger().info("Creating IVML variable {} {} = {};", new Object[]{type, varName, valueEx});
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        try {
            IDatatype t = this.findType(root, type);
            Project target = this.adaptTarget(root, this.getVariableTarget(root, t, varName, null));
            if (null == t) {
                throw new ExecutionException("No such type " + type, null);
            }
            Object var = asConst ? new ConstantDecisionVariableDeclaration(AbstractIvmlModifier.toIdentifier(varName), t, (IModelElement)target) : new DecisionVariableDeclaration(AbstractIvmlModifier.toIdentifier(varName), t, (IModelElement)target);
            this.setValue((AbstractVariable)var, valueEx);
            target.add((ContainableModelElement)var);
            IDecisionVariable dVar = cfg.createDecision((AbstractVariable)var);
            this.notifyChange(dVar, ConfigurationChangeType.CREATED);
            ReasoningResult res = this.validateAndPropagate(NO_TEMPLATE_FILTER);
            this.throwIfFails(res, true);
            AbstractIvmlModifier.saveTo(target, this.getIvmlFile(target));
            AbstractIvmlModifier.getLogger().info("Created IVML variable {} in {}", (Object)varName, (Object)target.getName());
            this.reservedVariableNames.remove(varName);
        }
        catch (ConfigurationException | ModelQueryException e) {
            throw new ExecutionException(e);
        }
    }

    private IDatatype findType(Project scope, String type) throws ModelQueryException {
        IDatatype result = null;
        for (GenericTypeIndicator indicator : GenericTypeIndicator.values()) {
            String prefix = indicator.getPrefix();
            if (!type.startsWith(prefix) || !type.endsWith(")")) continue;
            String t = type.substring(prefix.length(), type.length() - 1);
            result = indicator.getCreator().createType(type, this.findType(scope, t), scope);
            break;
        }
        if (null == result) {
            result = ModelQuery.findType((IResolutionScope)scope, (String)type, null);
        }
        return result;
    }

    public synchronized void changeValues(Map<String, String> values) throws ExecutionException {
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration cfg = this.getVilConfiguration();
        Project root = cfg.getConfiguration().getProject();
        HashSet<Project> projects = new HashSet<Project>();
        HashMap<String, IDecisionVariable> vars = new HashMap<String, IDecisionVariable>();
        for (String string : values.keySet()) {
            vars.put(string, this.getVariable(cfg, string));
        }
        ChangeHistory history = cfg.getChangeHistory();
        history.start();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            IDecisionVariable var = (IDecisionVariable)vars.get(entry.getKey());
            try {
                AbstractVariable varDecl = var.getDeclaration();
                Project target = varDecl.getProject();
                String subpath = this.getIvmlSubpath(target);
                if (null == subpath) {
                    target = root;
                }
                if (varDecl.getProject() == target) {
                    this.setValue(varDecl, entry.getValue());
                } else {
                    this.removeConstraintsForVariable(target, varDecl);
                    this.createAssignment(varDecl, entry.getValue(), target);
                    projects.add(target);
                }
                this.notifyChange(var, ConfigurationChangeType.MODIFIED);
            }
            catch (ExecutionException e) {
                history.rollback();
                throw e;
            }
        }
        ReasoningResult reasoningResult = ReasonerFrontend.getInstance().propagate(cfg.getConfiguration(), null, null);
        boolean bl = IvmlUtils.analyzeReasoningResult(reasoningResult, false, false);
        if (bl) {
            history.rollback();
            this.throwIfFails(reasoningResult, false);
        } else {
            AbstractIvmlModifier.getLogger().info("Committing IVML changes:");
            history.commit();
            HashMap<Project, CopiedFile> copies = new HashMap<Project, CopiedFile>();
            for (Project p : projects) {
                File f = this.getIvmlFile(p);
                copies.put(p, AbstractIvmlModifier.copyToTmp(f));
                AbstractIvmlModifier.saveTo(p, f);
                AbstractIvmlModifier.getLogger().info(" - Writing IVML file {}", (Object)f);
            }
            this.reloadAndValidate(copies);
        }
    }

    protected void setValue(IDecisionVariable var, String expression, EvaluationVisitor eval, AssignmentState state) throws ExecutionException {
        try {
            ConstraintSyntaxTree cst = this.createExpression(null, expression, var.getConfiguration().getProject());
            if (null == eval) {
                eval = new EvaluationVisitor();
            }
            eval.init((IConfiguration)var.getConfiguration(), (IAssignmentState)state, false, null);
            eval.visit(cst);
            Value val = eval.getResult();
            eval.clear();
            var.setValue(val, (IAssignmentState)state);
        }
        catch (ConfigurationException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    protected ConstraintSyntaxTree createExpression(IDatatype type, String expression, Project scope) throws ExecutionException {
        try {
            if (null == scope) {
                scope = this.getIvmlConfiguration().getProject();
            }
            return ModelUtility.INSTANCE.createExpression(type, expression, scope);
        }
        catch (CSTSemanticException e) {
            throw new ExecutionException("IVML expression semantic error: " + e.getMessage(), null);
        }
        catch (ConstraintSyntaxException e) {
            throw new ExecutionException("IVML expression syntax error: " + e.getMessage(), null);
        }
    }

    protected Constraint createAssignment(AbstractVariable varDecl, String valueEx, Project prj) throws ExecutionException {
        try {
            Constraint c = new Constraint(this.createExpression(null, varDecl.getName() + "=" + valueEx, prj), (IModelElement)prj);
            prj.addBeforeFreeze((ContainableModelElement)c);
            return c;
        }
        catch (CSTSemanticException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    protected void setValue(AbstractVariable var, String expression) throws ExecutionException {
        try {
            IDatatype type = var.getType();
            ConstraintSyntaxTree cst = this.createExpression(type, expression, var.getProject());
            cst.inferDatatype();
            var.setValue(cst);
        }
        catch (CSTSemanticException | ValueDoesNotMatchTypeException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    protected static CopiedFile copyToTmp(File file) throws ExecutionException {
        CopiedFile result = null;
        if (file.exists()) {
            File cp = new File(FileUtils.getTempDirectory(), file.getName());
            try {
                Files.copy(file.toPath(), cp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                result = new CopiedFile(file, cp);
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        } else {
            result = new CopiedFile(file, null);
        }
        return result;
    }

    protected void reloadAndValidate(Map<Project, CopiedFile> copies) throws ExecutionException {
        this.reloadConfiguration();
        ReasoningResult res = this.validateAndPropagate(NO_TEMPLATE_FILTER);
        Object msg = "";
        boolean hasConflict = IvmlUtils.analyzeReasoningResult(res, false, false);
        if (hasConflict) {
            for (CopiedFile c : copies.values()) {
                try {
                    c.restore();
                }
                catch (IOException e) {
                    if (((String)msg).length() > 0) {
                        msg = (String)msg + "\n";
                    }
                    msg = (String)msg + e.getMessage();
                }
            }
            if (((String)msg).length() > 0) {
                throw new ExecutionException("Cannot restore model: " + (String)msg, null);
            }
            this.reloadConfiguration();
            this.throwIfFails(res, false);
        } else {
            for (CopiedFile c : copies.values()) {
                c.clean();
            }
        }
    }

    public String getGraph(String varName, String format) throws ExecutionException {
        GraphFormat gFormat = this.getGraphFormat(format);
        IDecisionVariable var = this.getVariable(varName);
        IvmlGraphMapper.IvmlGraph graph = this.graphMapper.getGraphFor(var);
        return gFormat.toString(graph);
    }

    protected GraphFormat getGraphFormat(String format) throws ExecutionException {
        if (null == format) {
            throw new ExecutionException("format must not be null", null);
        }
        GraphFormat result = this.graphFormats.get(format);
        if (null == result) {
            throw new ExecutionException("format '" + format + "' is unknown", null);
        }
        return result;
    }

    protected IvmlGraphMapper getMapper() {
        return this.graphMapper;
    }

    @Override
    public IDecisionVariable getVariable(String qualifiedVarName) throws ExecutionException {
        return this.getVariable(this.getVilConfiguration(), qualifiedVarName);
    }

    protected IDecisionVariable getVariable(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration cfg, String qualifiedVarName) throws ExecutionException {
        try {
            return cfg.getConfiguration().getDecision(qualifiedVarName, false);
        }
        catch (ModelQueryException e) {
            throw new ExecutionException(e.getMessage(), null);
        }
    }

    protected static void addImport(Project target, String imp, Project root, Project res) throws ModelManagementException {
        ProjectImport i = new ProjectImport(imp);
        if (null == res) {
            i.setResolved(ModelQuery.findProject((Project)root, (String)imp));
        } else {
            i.setResolved(res);
        }
        target.addImport(i);
    }

    protected static String toIdentifierFirstUpper(String str) {
        return PseudoString.firstToUpperCase((String)AbstractIvmlModifier.toIdentifier(str));
    }

    protected static String toIdentifier(String str) {
        return PseudoString.toIdentifier((String)str);
    }

    protected abstract net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration getVilConfiguration();

    protected abstract Configuration getIvmlConfiguration();

    protected ReasoningResult validateAndPropagate() {
        return this.validateAndPropagate(null);
    }

    protected abstract ReasoningResult validateAndPropagate(Predicate<Project> var1);

    protected abstract void reloadConfiguration();

    protected void notifyChange(IDecisionVariable var, ConfigurationChangeType type) {
        if (null != this.changeListener && null != var) {
            this.changeListener.configurationChanged(var, type);
        }
    }

    protected void notifyChange(Project prj, ConfigurationChangeType type) {
        Configuration cfg = this.getIvmlConfiguration();
        for (int e = 0; e < prj.getElementCount(); ++e) {
            ContainableModelElement elt = prj.getElement(e);
            if (!(elt instanceof AbstractVariable)) continue;
            this.notifyChange(cfg.getDecision((AbstractVariable)elt), type);
        }
    }

    public static String getType(IDecisionVariable var) {
        IDatatype type = var.getDeclaration().getType();
        return IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AbstractIvmlModifier.class);
    }

    public static interface ConfigurationChangeListener {
        public void configurationChanged(IDecisionVariable var1, ConfigurationChangeType var2);
    }

    private static class InstantiationContext {
        private Map<String, String> adjustments;
        private Set<Project> modified = new HashSet<Project>();
        private Map<AbstractVariable, AbstractVariable> substitutions = new HashMap<AbstractVariable, AbstractVariable>();
        private List<IDecisionVariable> meshes = new ArrayList<IDecisionVariable>();
        private String currentTemplateVariable;
        private String appPrefix = "";
        private Project targetProject;
        private boolean enableNameAdjustment = false;

        private InstantiationContext(Map<String, String> adjustments) {
            this.adjustments = adjustments;
        }

        private List<String> getMeshNames() {
            return this.meshes.stream().map(m -> m.getDeclaration().getParent().getName()).collect(Collectors.toList());
        }

        private String getCurrentTemplateVariableName() {
            return null == this.currentTemplateVariable ? "" : this.currentTemplateVariable;
        }

        private String prefixVarName(String name) {
            return this.appPrefix == null || this.appPrefix.length() == 0 ? name : this.appPrefix + AbstractIvmlModifier.toIdentifierFirstUpper(name);
        }
    }

    private static enum Mode {
        CREATE(true, false),
        CREATE_SETTARGET(true, false),
        SET_VALUE(false, true),
        BOTH(true, true);

        private boolean create;
        private boolean setValue;

        private Mode(boolean create, boolean setValue) {
            this.create = create;
            this.setValue = setValue;
        }
    }

    private static class ValueAdjustmentVisitor
    implements IValueVisitor {
        private InstantiationContext context;
        private Value value;
        private String nested;

        private ValueAdjustmentVisitor(InstantiationContext context) {
            this.context = context;
            this.nested = context.getCurrentTemplateVariableName();
        }

        public void visitConstraintValue(ConstraintValue value) {
            try {
                SubstitutionVisitor vis = new SubstitutionVisitor();
                for (Map.Entry<AbstractVariable, AbstractVariable> ent : this.context.substitutions.entrySet()) {
                    vis.addVariableMapping(ent.getKey(), ent.getValue(), 0);
                }
                value.getValue().accept((IConstraintTreeVisitor)vis);
                ConstraintSyntaxTree vr = vis.getResult();
                this.value = null == vr || vr == value.getValue() ? value : ValueFactory.createValue((IDatatype)value.getType(), (Object[])new Object[]{vr});
            }
            catch (ValueDoesNotMatchTypeException e) {
                AbstractIvmlModifier.getLogger().error("Value does not match: {}", (Object)e.getMessage());
            }
        }

        public void visitCompoundValue(CompoundValue value) {
            String origNested = this.nested;
            for (String slot : value.getSlotNames()) {
                this.nested = origNested + "." + slot;
                try {
                    String adj;
                    Value slotVal = value.getNestedValue(slot);
                    if (null == slotVal) continue;
                    slotVal.accept((IValueVisitor)this);
                    if (this.context.adjustments != null && null != (adj = this.context.adjustments.get(this.nested))) {
                        IDatatype slotType = ((Compound)value.getType()).getElement(slot).getType();
                        this.value = ValueFactory.createValue((IDatatype)slotType, (Object[])new Object[]{adj});
                    }
                    value.configureValue(slot, (Object)this.value);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    AbstractIvmlModifier.getLogger().error("Value does not match: {}", (Object)e.getMessage());
                }
            }
            this.nested = origNested;
            this.value = value;
        }

        public void visitContainerValue(ContainerValue value) {
            for (int e = 0; e < value.getElementSize(); ++e) {
                value.getElement(e).accept((IValueVisitor)this);
                try {
                    value.setValue(e, this.value);
                    continue;
                }
                catch (ValueDoesNotMatchTypeException ex) {
                    AbstractIvmlModifier.getLogger().error("Value does not match: {}", (Object)ex.getMessage());
                }
            }
            this.value = value;
        }

        public void visitReferenceValue(ReferenceValue referenceValue) {
            AbstractVariable var = this.context.substitutions.get(referenceValue.getValue());
            if (null != var) {
                try {
                    referenceValue.setValue((Object)var);
                }
                catch (ValueDoesNotMatchTypeException e) {
                    AbstractIvmlModifier.getLogger().error("Value does not match: {}", (Object)e.getMessage());
                }
            }
            this.value = referenceValue;
        }

        public void visitEnumValue(EnumValue value) {
            this.value = value;
        }

        public void visitStringValue(StringValue value) {
            this.value = value;
        }

        public void visitIntValue(IntValue value) {
            this.value = value;
        }

        public void visitRealValue(RealValue value) {
            this.value = value;
        }

        public void visitBooleanValue(BooleanValue value) {
            this.value = value;
        }

        public void visitMetaTypeValue(MetaTypeValue value) {
            this.value = value;
        }

        public void visitNullValue(NullValue value) {
            this.value = value;
        }

        public void visitVersionValue(VersionValue value) {
            this.value = value;
        }
    }

    private static enum GenericTypeIndicator {
        REF_TO("refTo(", (n, t, s) -> new Reference(n, t, (ModelElement)s)),
        SET_OF("setOf(", (n, t, s) -> new net.ssehub.easy.varModel.model.datatypes.Set(n, t, (IModelElement)s)),
        SEQUENCE_OF("sequenceOf(", (n, t, s) -> new Sequence(n, t, (IModelElement)s));

        private String prefix;
        private TypeCreationFunction creator;

        private GenericTypeIndicator(String prefix, TypeCreationFunction creator) {
            this.prefix = prefix;
            this.creator = creator;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public TypeCreationFunction getCreator() {
            return this.creator;
        }
    }

    private static interface TypeCreationFunction {
        public IDatatype createType(String var1, IDatatype var2, Project var3);
    }

    protected static class CopiedFile {
        private File original;
        private File copy;

        private CopiedFile(File original, File copy) {
            this.original = original;
            this.copy = copy;
        }

        private void restore() throws IOException {
            if (null == this.copy) {
                this.original.delete();
            } else {
                Files.copy(this.copy.toPath(), this.original.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }

        private void clean() {
            if (null != this.copy) {
                this.copy.delete();
            }
        }
    }
}

