/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.opcua.data;

import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.BaseType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.FieldType;
import java.util.ArrayList;

public class MethodType
extends BaseType {
    private ArrayList<FieldType> fields;

    public MethodType(String nodeId, String browseName, String displayName, String description, boolean optional, ArrayList<FieldType> fields) {
        super(nodeId, browseName, displayName, description, optional);
        this.fields = fields;
    }

    public ArrayList<FieldType> getFields() {
        return this.fields;
    }

    public void setFields(ArrayList<FieldType> fields) {
        this.fields = fields;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tUAMethodType " + this.getVarName() + " = {\n");
        builder.append("\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t" + MethodType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\tnodeClass = NodeClass::UAMethod,\n");
        builder.append("\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\toptional = " + this.isOptional() + ",\n");
        if (!this.fields.isEmpty()) {
            builder.append("\t\tfields = {\n\t\t\t");
            for (FieldType f : this.fields) {
                builder.append(f.toString());
                if (f.equals(this.fields.get(this.fields.size() - 1))) {
                    builder.append("\t\t\t}\n");
                    continue;
                }
                builder.append("\t\t\t}, ");
            }
            builder.append("\t\t}\n");
        } else {
            builder.append("\t\tfields = {\n\t}\n");
        }
        builder.append("\t};\n\n");
        return builder.toString();
    }
}

