/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.opcua.data;

import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.BaseType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.FieldType;
import java.util.ArrayList;

public class ObjectType
extends BaseType {
    private String type;
    private ArrayList<FieldType> fields;

    public ObjectType(String nodeId, String browseName, String displayName, String description, boolean optional, String type, ArrayList<FieldType> fields) {
        super(nodeId, browseName, displayName, description, optional);
        this.type = type;
        this.fields = fields;
    }

    public String getType() {
        return this.type;
    }

    public ArrayList<FieldType> getFields() {
        return this.fields;
    }

    public void setFields(ArrayList<FieldType> fields) {
        this.fields = fields;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tUAObjectType " + this.getVarName() + " = {\n");
        builder.append("\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t" + ObjectType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\tnodeClass = NodeClass::UAObject,\n");
        builder.append("\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\tdescription = \"" + this.getDescription() + "\",\n");
        builder.append("\t\toptional = " + this.isOptional() + ",\n");
        builder.append("\t\ttypeDefinition = refBy(opc" + this.type + "),\n");
        if (!this.fields.isEmpty()) {
            builder.append("\t\tfields = {\n\t\t\t");
            for (FieldType f : this.fields) {
                builder.append(f.toString());
                if (f.equals(this.fields.get(this.fields.size() - 1))) {
                    builder.append("\t\t\t}\n");
                    continue;
                }
                builder.append("\t\t\t}, ");
            }
            builder.append("\t\t}\n");
        } else {
            builder.append("\t\tfields = {\n\t}\n");
        }
        builder.append("\t};\n\n");
        return builder.toString();
    }
}

