/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.opcua.parser;

import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.BaseType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.DataLiteral;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.DataType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.EnumLiteral;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.EnumType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.FieldMethodType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.FieldObjectType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.FieldType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.FieldVariableType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.Literal;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.MethodType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.ObjectType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.ObjectTypeType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.RootMethodType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.RootObjectType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.RootVariableType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.VariableTypeType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.parser.Collector;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.parser.ElementType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.parser.Generator;
import de.iip_ecosphere.platform.support.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomParser {
    private static boolean verboseDefault = false;
    private static String usingIvmlFolder = "src/test/easy";
    private static final Set<String> IDENTIFY_FIELDS_PERMITTED_REFERENCE_TYPE;
    private Document[] documents;
    private NodeList objectTypeList;
    private NodeList objectList;
    private NodeList variableList;
    private NodeList methodList;
    private NodeList dataTypeList;
    private NodeList variableTypeList;
    private NodeList aliasList;
    private ArrayList<BaseType> hierarchy;
    private boolean verbose = verboseDefault;
    private String baseNameSpace;
    private ArrayList<NodeList> externAliasLists;

    private DomParser(NodeList objectTypeList, NodeList objectList, NodeList variableList, NodeList methodList, NodeList dataTypeList, NodeList variableTypeList, NodeList aliasList, ArrayList<BaseType> hierarchy) {
        this.objectTypeList = objectTypeList;
        this.objectList = objectList;
        this.variableList = variableList;
        this.methodList = methodList;
        this.dataTypeList = dataTypeList;
        this.variableTypeList = variableTypeList;
        this.aliasList = aliasList;
        this.hierarchy = hierarchy;
    }

    public void setExternAliasLists(ArrayList<NodeList> externAliasLists) {
        this.externAliasLists = externAliasLists;
    }

    public void setDocuments(Document[] documents) {
        this.documents = documents;
    }

    public void setBaseNameSpace(String baseNameSpace) {
        this.baseNameSpace = baseNameSpace;
    }

    public static void setDefaultVerbose(boolean verbose) {
        verboseDefault = verbose;
    }

    private static String searchVarName(BaseType uaElement, ArrayList<BaseType> hierarchy) {
        String varName = "";
        block0: for (BaseType o : hierarchy) {
            ArrayList<FieldType> fields;
            if (!(o instanceof ObjectType) || (fields = ((ObjectType)o).getFields()).isEmpty()) continue;
            for (FieldType f : fields) {
                if (f instanceof FieldVariableType || !uaElement.getNodeId().equals(f.getNodeId())) continue;
                varName = f.getDataType();
                continue block0;
            }
        }
        return varName;
    }

    private String changeVariableDataTypes(String dataType) {
        if (((String)dataType).contains("i=") && !((String)dataType).contains("ns=")) {
            block38: for (int i = 0; i < this.aliasList.getLength(); ++i) {
                Element alias = DomParser.getNextNodeElement(this.aliasList, i);
                NodeList childNodeList = alias.getChildNodes();
                for (int j = 0; j < childNodeList.getLength(); ++j) {
                    String nodeId;
                    Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                    if (childNode == null || !(nodeId = childNode.getTextContent()).equals(dataType)) continue;
                    dataType = childNode.getAttribute("Alias");
                    continue block38;
                }
            }
        }
        boolean modelTypes = false;
        switch (dataType) {
            case "SByte": {
                dataType = "SByteType";
                modelTypes = true;
                break;
            }
            case "Boolean": {
                dataType = "BooleanType";
                modelTypes = true;
                break;
            }
            case "Byte": {
                dataType = "ByteType";
                modelTypes = true;
                break;
            }
            case "ByteString": {
                dataType = "ByteStringType";
                modelTypes = true;
                break;
            }
            case "Integer": {
                dataType = "IntegerType";
                modelTypes = true;
                break;
            }
            case "Int16": {
                dataType = "Integer16Type";
                modelTypes = true;
                break;
            }
            case "UInt16": {
                dataType = "UnsignedInteger16Type";
                modelTypes = true;
                break;
            }
            case "Int32": {
                dataType = "Integer32Type";
                modelTypes = true;
                break;
            }
            case "UInt32": {
                dataType = "UnsignedInteger32Type";
                modelTypes = true;
                break;
            }
            case "Int64": {
                dataType = "Integer64Type";
                modelTypes = true;
                break;
            }
            case "UInt64": {
                dataType = "UnsignedInteger64Type";
                modelTypes = true;
                break;
            }
            case "Float": {
                dataType = "FloatType";
                modelTypes = true;
                break;
            }
            case "Double": {
                dataType = "DoubleType";
                modelTypes = true;
                break;
            }
            case "String": {
                dataType = "StringType";
                modelTypes = true;
                break;
            }
            case "DateTime": {
                dataType = "DateTimeType";
                modelTypes = true;
                break;
            }
            case "UInteger": {
                dataType = "opcUnsignedIntegerType";
                break;
            }
            case "": {
                dataType = "opcUnknownDataType";
                break;
            }
            default: {
                if (((String)dataType).contains("ns=" + this.baseNameSpace)) {
                    dataType = this.checkForInternDataType((String)dataType);
                    dataType = "opc" + (String)dataType + "Type";
                    break;
                }
                if (((String)dataType).contains("opc") || modelTypes) break;
                dataType = this.checkForExternDataType((String)dataType);
                dataType = "opc" + (String)dataType + "Type";
            }
        }
        return dataType;
    }

    private void adaptDatatypesToModel(ObjectType uaObject, MethodType uaMethod) {
        if (uaMethod == null) {
            ArrayList<FieldType> fields = uaObject.getFields();
            for (FieldType f : fields) {
                if (f instanceof FieldVariableType) {
                    DomParser.nop();
                    continue;
                }
                if (f instanceof FieldObjectType) {
                    f.setDataType(BaseType.validateVarName(uaObject.getVarName() + f.getDisplayname()));
                    fields.set(fields.indexOf(f), f);
                    continue;
                }
                if (!(f instanceof FieldMethodType)) continue;
                f.setDataType(BaseType.validateVarName(uaObject.getVarName() + f.getDisplayname()));
                fields.set(fields.indexOf(f), f);
            }
        } else {
            ArrayList<FieldType> fields = uaMethod.getFields();
            for (FieldType f : fields) {
                if (f instanceof FieldVariableType) {
                    DomParser.nop();
                    continue;
                }
                if (f instanceof FieldObjectType) {
                    f.setDataType(BaseType.validateVarName(uaMethod.getVarName() + f.getDisplayname()));
                    fields.set(fields.indexOf(f), f);
                    continue;
                }
                if (!(f instanceof FieldMethodType)) continue;
                f.setDataType(BaseType.validateVarName(uaMethod.getVarName() + f.getDisplayname()));
                fields.set(fields.indexOf(f), f);
            }
        }
    }

    private static void nop() {
    }

    private static Element checkRelation(String currentNodeId, NodeList nodes) {
        Element relatedElement = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = DomParser.getNextNodeElement(nodes, i);
            String nodeId = node.getAttribute("NodeId");
            if (!currentNodeId.equals(nodeId)) continue;
            relatedElement = node;
            i = nodes.getLength();
        }
        return relatedElement;
    }

    private static Element getNextNodeElement(NodeList nodes, int iterator) {
        Node n = nodes.item(iterator);
        Element node = null;
        if (n.getNodeType() == 1) {
            node = (Element)n;
        }
        return node;
    }

    private String retrieveParent(String parentNodeId, NodeList list) {
        String rootParent = "";
        Element element = DomParser.checkRelation(parentNodeId, list);
        if (element != null) {
            NodeList childNodeList = element.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                if (childNode == null || !childNode.getTagName().equals("DisplayName")) continue;
                rootParent = BaseType.validateVarName("opc" + childNode.getTextContent());
                break;
            }
        }
        return rootParent;
    }

    private String checkForInternDataType(String dataTypeNodeId) {
        String identifiedDataType = "";
        block0: for (int i = 0; i < this.dataTypeList.getLength(); ++i) {
            Element dataType = DomParser.getNextNodeElement(this.dataTypeList, i);
            if (dataType == null || !dataType.getAttribute("NodeId").equals(dataTypeNodeId)) continue;
            NodeList childNodeList = dataType.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                if (childNode == null || childNode.getTagName().equals("References") || !childNode.getTagName().equals("DisplayName")) continue;
                identifiedDataType = childNode.getTextContent().replaceAll("[\u201c\u201d\"_\\\\]", "");
                continue block0;
            }
        }
        return identifiedDataType;
    }

    private String checkForExternDataType(String dataType) {
        if (dataType.contains("ns=") | dataType.contains("i=")) {
            dataType = this.retrieveAttributesForExternDataType(dataType);
        }
        boolean foundAlias = false;
        block0: for (int i = 0; i < this.aliasList.getLength(); ++i) {
            Element alias = DomParser.getNextNodeElement(this.aliasList, i);
            NodeList childNodeList = alias.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                if (childNode == null || !childNode.getAttribute("Alias").equals(dataType)) continue;
                foundAlias = true;
                String nodeId = childNode.getTextContent();
                if (!nodeId.contains("i=") || nodeId.contains("ns=" + this.baseNameSpace)) continue block0;
                dataType = this.retrieveAttributesForExternDataType(nodeId);
                continue block0;
            }
        }
        if (!foundAlias) {
            for (NodeList l : this.externAliasLists) {
                block3: for (int i = 0; i < l.getLength(); ++i) {
                    Element alias = DomParser.getNextNodeElement(l, i);
                    NodeList childNodeList = alias.getChildNodes();
                    for (int j = 0; j < childNodeList.getLength(); ++j) {
                        Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                        if (childNode == null || !childNode.getAttribute("Alias").equals(dataType)) continue;
                        foundAlias = true;
                        String nodeId = childNode.getTextContent();
                        if (!nodeId.contains("i=") || nodeId.contains("ns=" + this.baseNameSpace)) continue block3;
                        dataType = this.retrieveAttributesForExternDataType(nodeId);
                        continue block3;
                    }
                }
            }
        }
        return dataType;
    }

    private String retrieveAttributesForExternDataType(String nodeId) {
        String dataType = "";
        for (int k = 0; k < this.documents.length; ++k) {
            Element element;
            NodeList typeList = this.documents[k].getElementsByTagName("UADataType");
            Object externNodeId = nodeId;
            if (((String)externNodeId).contains("ns=")) {
                externNodeId = ((String)externNodeId).substring(0, ((String)externNodeId).indexOf("=") + 1) + "1" + ((String)externNodeId).substring(((String)externNodeId).indexOf(";"), ((String)externNodeId).length());
            }
            if ((element = DomParser.checkRelation((String)externNodeId, typeList)) == null) continue;
            NodeList childNodeList = element.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                if (childNode == null || childNode.getTagName().equals("References") || !childNode.getTagName().equals("DisplayName")) continue;
                dataType = childNode.getTextContent().replaceAll("[\u201c\u201d\"_\\\\]", "");
                break;
            }
            this.retrieveAttributes(element, null, ElementType.DATATYPE, nodeId);
            break;
        }
        return dataType;
    }

    private String identifySpecificReference(String reference, Node node, ElementType type) {
        NodeList references = node.getChildNodes();
        block0: for (int k = 0; k < references.getLength(); ++k) {
            Element refNode = DomParser.getNextNodeElement(references, k);
            if (refNode == null || !refNode.getAttribute("ReferenceType").equals(reference)) continue;
            String refId = refNode.getTextContent();
            if (refId.contains("ns=" + this.baseNameSpace) || !refId.contains("ns=")) {
                TypeListAndType r = this.getTypeListAndTypeRootNs(refId, reference, type);
                type = r.type;
                Element refElement = DomParser.checkRelation(refId, r.typeList);
                if (refElement == null) break;
                DescriptionOrDocumentation d = this.getDescriptionOrDocumentation(reference, refElement);
                reference = d.reference;
                if (type.isCore()) break;
                this.createElement(type, refElement, refId, d.displayName, d.description, d.documentation, null, null, null, null, null, false);
                break;
            }
            String newRefId = refId.substring(0, refId.indexOf("=") + 1) + "1" + refId.substring(refId.indexOf(";"), refId.length());
            for (int i = 1; i < this.documents.length; ++i) {
                NodeList typeList = null;
                if (type == ElementType.ROOTOBJECT || type == ElementType.SUBOBJECT) {
                    typeList = this.documents[i].getElementsByTagName("UAObjectType");
                    type = ElementType.OBJECTTYPE;
                } else if (type == ElementType.FIELDVARIABLE) {
                    typeList = this.documents[i].getElementsByTagName("UAVariableType");
                    type = ElementType.VARIABLETYPE;
                }
                Element refElement = DomParser.checkRelation(newRefId, typeList);
                if (refElement != null) {
                    DescriptionOrDocumentation d = this.getDescriptionOrDocumentation(reference, refElement);
                    reference = d.reference;
                    this.createElement(type, refElement, refId, d.displayName, d.description, d.documentation, null, null, null, null, null, false);
                    break block0;
                }
                if (type == ElementType.OBJECTTYPE) {
                    type = ElementType.ROOTOBJECT;
                    continue;
                }
                if (type != ElementType.VARIABLETYPE) continue;
                type = ElementType.FIELDVARIABLE;
            }
            break;
        }
        return reference;
    }

    private TypeListAndType getTypeListAndTypeRootNs(String refId, String reference, ElementType type) {
        TypeListAndType result = new TypeListAndType();
        result.type = type;
        if (refId.contains("ns=" + this.baseNameSpace)) {
            if (type == ElementType.ROOTOBJECT || type == ElementType.SUBOBJECT) {
                result.typeList = this.objectTypeList;
            } else if (type == ElementType.FIELDVARIABLE || type == ElementType.ROOTVARIABLE) {
                result.typeList = this.variableTypeList;
                result.type = ElementType.VARIABLETYPE;
            }
        } else if (!refId.contains("ns=")) {
            if (type.isCore()) {
                if (reference.equals("HasModellingRule")) {
                    result.typeList = this.documents[0].getElementsByTagName("UAObject");
                } else {
                    result.typeList = this.documents[0].getElementsByTagName("UAObjectType");
                    result.type = ElementType.OBJECTTYPE;
                }
            } else if (type == ElementType.FIELDVARIABLE || type == ElementType.ROOTVARIABLE) {
                if (reference.equals("HasModellingRule")) {
                    result.typeList = this.documents[0].getElementsByTagName("UAObject");
                    result.type = ElementType.ROOTOBJECT;
                } else {
                    result.typeList = this.documents[0].getElementsByTagName("UAVariableType");
                    result.type = ElementType.VARIABLETYPE;
                }
            }
        }
        return result;
    }

    private DescriptionOrDocumentation getDescriptionOrDocumentation(String reference, Element refElement) {
        DescriptionOrDocumentation result = new DescriptionOrDocumentation();
        result.reference = reference;
        NodeList childNodeList = refElement.getChildNodes();
        for (int j = 0; j < childNodeList.getLength(); ++j) {
            Element childNode = DomParser.getNextNodeElement(childNodeList, j);
            if (childNode == null || childNode.getTagName().equals("References")) continue;
            if (childNode.getTagName().equals("DisplayName")) {
                result.displayName = result.reference = childNode.getTextContent().replaceAll("[\u201c\u201d\"\\\\]", "");
                continue;
            }
            if (childNode.getTagName().equals("Description")) {
                result.description = childNode.getTextContent().replaceAll("[\u201c\u201d\"\\\\]", "");
                continue;
            }
            if (!childNode.getTagName().equals("Documentation")) continue;
            result.documentation = childNode.getTextContent();
        }
        return result;
    }

    private ArrayList<FieldType> identifyFields(Node childNode) {
        ArrayList<FieldType> fields = new ArrayList<FieldType>();
        NodeList references = childNode.getChildNodes();
        for (int k = 0; k < references.getLength(); ++k) {
            Element refNode = DomParser.getNextNodeElement(references, k);
            if (refNode == null || !IDENTIFY_FIELDS_PERMITTED_REFERENCE_TYPE.contains(refNode.getAttribute("ReferenceType"))) continue;
            String refId = refNode.getTextContent();
            Element refElement = DomParser.checkRelation(refId, this.variableList);
            if (refElement != null) {
                this.retrieveAttributesForRefElement(fields, refId, refElement, ElementType.FIELDVARIABLE);
                continue;
            }
            refElement = DomParser.checkRelation(refId, this.objectList);
            if (refElement != null && !refNode.getAttribute("IsForward").equals("false")) {
                this.retrieveAttributesForRefElement(fields, refId, refElement, ElementType.FIELDOBJECT);
                continue;
            }
            refElement = DomParser.checkRelation(refId, this.methodList);
            if (refElement == null) continue;
            this.retrieveAttributesForRefElement(fields, refId, refElement, ElementType.FIELDMETHOD);
        }
        return fields;
    }

    private void retrieveAttributesForRefElement(ArrayList<FieldType> fields, String refId, Element refElement, ElementType elementType) {
        if (fields.size() == 0) {
            this.retrieveAttributes(refElement, fields, elementType, null);
        } else {
            boolean retrieve = true;
            for (FieldType f : fields) {
                if (!f.getNodeId().equals(refId)) continue;
                retrieve = false;
            }
            if (retrieve) {
                this.retrieveAttributes(refElement, fields, elementType, null);
            }
        }
    }

    private void retrieveRootElement(Element object, ElementType type) {
        this.retrieveAttributes(object, null, type, null);
    }

    private void retrieveRelatedSubElements(ArrayList<FieldType> subElements) {
        ArrayList<FieldType> fields = new ArrayList<FieldType>();
        for (FieldType field : subElements) {
            if (!(field instanceof FieldVariableType) && !(field instanceof FieldMethodType)) {
                Element object = DomParser.checkRelation(field.getNodeId(), this.objectList);
                this.retrieveAttributes(object, fields, ElementType.SUBOBJECT, null);
                continue;
            }
            if (field instanceof FieldVariableType || field instanceof FieldObjectType) continue;
            Element method = DomParser.checkRelation(field.getNodeId(), this.methodList);
            this.retrieveAttributes(method, fields, ElementType.SUBMETHOD, null);
        }
    }

    private void retrieveAttributes(Element element, ArrayList<FieldType> subFields, ElementType type, String externNodeId) {
        String id = "";
        String description = "";
        String displayName = "";
        String documentation = "";
        String typeDef = "";
        String modellingRule = "";
        boolean optional = false;
        ArrayList<FieldType> objectFields = new ArrayList<FieldType>();
        ArrayList<EnumLiteral> literals = new ArrayList<EnumLiteral>();
        ArrayList<DataLiteral> dataLiterals = new ArrayList<DataLiteral>();
        id = externNodeId == null ? element.getAttribute("NodeId") : externNodeId;
        NodeList childNodeList = element.getChildNodes();
        for (int j = 0; j < childNodeList.getLength(); ++j) {
            Element childNode = DomParser.getNextNodeElement(childNodeList, j);
            if (childNode != null && !childNode.getTagName().equals("References")) {
                if (childNode.getTagName().equals("Description")) {
                    description = (childNode.getTextContent() + "@" + childNode.getAttribute("Locale")).replaceAll("[\u201c\u201d\"\\\\]", "");
                    continue;
                }
                if (childNode.getTagName().equals("DisplayName")) {
                    displayName = childNode.getTextContent().replaceAll("[\u201c\u201d\"_\\\\]", "");
                    continue;
                }
                if (childNode.getTagName().equals("Documentation")) {
                    documentation = childNode.getTextContent().replaceAll("[\u201c\u201d\"\\\\]", "");
                    continue;
                }
                if (!childNode.getTagName().equals("Definition")) continue;
                NodeList fields = childNode.getChildNodes();
                for (int k = 0; k < fields.getLength(); ++k) {
                    Literal literal;
                    Element fieldNode = DomParser.getNextNodeElement(fields, k);
                    if (fieldNode == null) continue;
                    Object fieldName = "_" + fieldNode.getAttribute("Name").replaceAll("[,\u201c\u201d\"\\\\]", "_");
                    if (((String)fieldName).equals("") || ((String)fieldName).equals("_")) {
                        fieldName = "placeholder_" + childNode.getAttribute("Name").replaceAll("[/,\u201c\u201d\"\\\\]", "_");
                    } else {
                        fieldName = ((String)fieldName).replace("\u00b5", "mu");
                        fieldName = ((String)fieldName).replace("/", "_per_");
                        fieldName = ((String)fieldName).replace("\u00b2", "_toPowerOf2");
                        fieldName = ((String)fieldName).replace("\u00b3", "_toPowerOf3");
                        fieldName = ((String)fieldName).replace("\u00b0", "degree_");
                    }
                    String fieldDescription = DomParser.getFieldDescription(fieldNode);
                    String fieldValue = fieldNode.getAttribute("Value");
                    String fieldDataType = "";
                    if (fieldValue.equals("")) {
                        fieldDataType = fieldNode.getAttribute("DataType");
                        literal = new DataLiteral((String)fieldName, this.changeVariableDataTypes(fieldDataType), fieldDescription);
                        dataLiterals.add((DataLiteral)literal);
                        continue;
                    }
                    type = ElementType.ENUM;
                    literal = new EnumLiteral((String)fieldName, fieldValue, fieldDescription);
                    literals.add((EnumLiteral)literal);
                }
                continue;
            }
            if (childNode == null || !childNode.getTagName().equals("References")) continue;
            if (type.equals((Object)ElementType.ROOTOBJECT) || type.equals((Object)ElementType.SUBOBJECT) || type.equals((Object)ElementType.ROOTMETHOD) || type.equals((Object)ElementType.SUBMETHOD)) {
                objectFields = this.identifyFields(childNode);
            }
            if (type == ElementType.ENUM) continue;
            if (type != ElementType.FIELDOBJECT && type != ElementType.FIELDMETHOD && type != ElementType.SUBMETHOD && type != ElementType.ROOTMETHOD) {
                typeDef = this.identifySpecificReference("HasTypeDefinition", childNode, type);
            }
            if (type == ElementType.OBJECTTYPE || type == ElementType.VARIABLETYPE || type == ElementType.DATATYPE || !(modellingRule = this.identifySpecificReference("HasModellingRule", childNode, type)).toUpperCase().contains("OPTIONAL")) continue;
            optional = true;
        }
        this.createElement(type, element, id, displayName, description, documentation, subFields, objectFields, literals, dataLiterals, typeDef, optional);
    }

    private static String getFieldDescription(Element fieldNode) {
        String fieldDescription = "";
        NodeList fieldChilds = fieldNode.getChildNodes();
        for (int l = 0; l < fieldChilds.getLength(); ++l) {
            Element fieldChildNode = DomParser.getNextNodeElement(fieldChilds, l);
            if (fieldChildNode == null || !fieldChildNode.getTagName().equals("Description")) continue;
            fieldDescription = fieldChildNode.getAttribute("Locale").equals("") ? fieldChildNode.getTextContent().replaceAll("[\u201c\u201d\"\\\\]", "") : (fieldChildNode.getTextContent() + "@" + fieldChildNode.getAttribute("Locale")).replaceAll("[\u201c\u201d\"\\\\]", "");
        }
        return fieldDescription;
    }

    private void createElement(ElementType type, Element element, String id, String displayName, String description, String documentation, ArrayList<FieldType> subFields, ArrayList<FieldType> objectFields, ArrayList<EnumLiteral> literals, ArrayList<DataLiteral> dataLiterals, String typeDef, boolean optional) {
        switch (type) {
            case ROOTOBJECT: {
                RootObjectType uaRootObject = new RootObjectType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, optional, BaseType.validateVarName("opc" + typeDef), this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectTypeList), objectFields);
                uaRootObject.setVarName(this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectTypeList) + displayName);
                if (!objectFields.isEmpty()) {
                    this.adaptDatatypesToModel(uaRootObject, null);
                }
                this.addElement(uaRootObject, type);
                if (uaRootObject.getFields().isEmpty()) break;
                this.retrieveRelatedSubElements(uaRootObject.getFields());
                break;
            }
            case ROOTVARIABLE: {
                String dimension;
                String dataType = element.getAttribute("DataType");
                if (dataType.equals("EnumValueType")) {
                    Element relatedDataTypeElement = DomParser.checkRelation(element.getAttribute("ParentNodeId"), this.dataTypeList);
                    NodeList dataChildNodeList = relatedDataTypeElement.getChildNodes();
                    for (int j = 0; j < dataChildNodeList.getLength(); ++j) {
                        Element childNode = DomParser.getNextNodeElement(dataChildNodeList, j);
                        if (childNode == null || !childNode.getTagName().equals("DisplayName")) continue;
                        dataType = childNode.getTextContent();
                    }
                } else {
                    dataType = this.changeVariableDataTypes(dataType);
                }
                if ((dimension = element.getAttribute("ArrayDimensions")).contains(",")) {
                    dimension = dimension.substring(0, dimension.indexOf(","));
                }
                RootVariableType uaRootVariable = new RootVariableType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, dataType, BaseType.validateVarName("opc" + typeDef + "Type"), optional, element.getAttribute("AccessLevel"), element.getAttribute("ValueRank"), dimension, this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectTypeList));
                uaRootVariable.setVarName(this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectTypeList) + displayName);
                this.addElement(uaRootVariable, type);
                break;
            }
            case ROOTMETHOD: {
                RootMethodType uaRootMethod = new RootMethodType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, optional, null, this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectTypeList), objectFields);
                uaRootMethod.setVarName(this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectTypeList) + displayName);
                if (!objectFields.isEmpty()) {
                    this.adaptDatatypesToModel(uaRootMethod, null);
                }
                this.addElement(uaRootMethod, type);
                if (uaRootMethod.getFields().isEmpty()) break;
                this.retrieveRelatedSubElements(uaRootMethod.getFields());
                break;
            }
            case SUBOBJECT: {
                ObjectType uaSubObject = new ObjectType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, optional, BaseType.validateVarName(typeDef), objectFields);
                uaSubObject.setVarName(DomParser.searchVarName(uaSubObject, this.hierarchy));
                if (!objectFields.isEmpty()) {
                    this.adaptDatatypesToModel(uaSubObject, null);
                }
                this.println(uaSubObject.toString());
                this.hierarchy.add(uaSubObject);
                if (uaSubObject.getFields().isEmpty()) break;
                this.retrieveRelatedSubElements(uaSubObject.getFields());
                break;
            }
            case SUBMETHOD: {
                MethodType uaMethod = new MethodType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, optional, objectFields);
                uaMethod.setVarName(DomParser.searchVarName(uaMethod, this.hierarchy));
                if (!objectFields.isEmpty()) {
                    this.adaptDatatypesToModel(null, uaMethod);
                }
                this.println(uaMethod.toString());
                this.hierarchy.add(uaMethod);
                if (uaMethod.getFields().isEmpty()) break;
                this.retrieveRelatedSubElements(uaMethod.getFields());
                break;
            }
            case FIELDOBJECT: {
                FieldObjectType uaFieldObject = new FieldObjectType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, "", optional);
                uaFieldObject.setVarName("opc" + displayName);
                if (this.checkRedundancy(uaFieldObject.getVarName(), subFields)) break;
                subFields.add(uaFieldObject);
                break;
            }
            case FIELDVARIABLE: {
                String fieldDimension;
                String dataType = element.getAttribute("DataType");
                if (dataType.equals("EnumValueType")) {
                    Element relatedDataTypeElement = DomParser.checkRelation(element.getAttribute("ParentNodeId"), this.dataTypeList);
                    NodeList dataChildNodeList = relatedDataTypeElement.getChildNodes();
                    for (int j = 0; j < dataChildNodeList.getLength(); ++j) {
                        Element childNode = DomParser.getNextNodeElement(dataChildNodeList, j);
                        if (childNode == null || !childNode.getTagName().equals("DisplayName")) continue;
                        dataType = childNode.getTextContent();
                    }
                } else {
                    dataType = this.changeVariableDataTypes(dataType);
                }
                if ((fieldDimension = element.getAttribute("ArrayDimensions")).contains(",")) {
                    fieldDimension = fieldDimension.substring(0, fieldDimension.indexOf(","));
                }
                FieldVariableType uaFieldVariable = new FieldVariableType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, dataType, BaseType.validateVarName("opc" + typeDef + "Type"), optional, element.getAttribute("AccessLevel"), element.getAttribute("ValueRank"), fieldDimension);
                uaFieldVariable.setVarName(this.retrieveParent(element.getAttribute("ParentNodeId"), this.objectList) + displayName);
                if (this.checkRedundancy(uaFieldVariable.getVarName(), subFields)) break;
                subFields.add(uaFieldVariable);
                break;
            }
            case FIELDMETHOD: {
                FieldMethodType uaFieldMethod = new FieldMethodType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, "", optional);
                uaFieldMethod.setVarName("opc" + displayName);
                if (this.checkRedundancy(uaFieldMethod.getVarName(), subFields)) break;
                subFields.add(uaFieldMethod);
                break;
            }
            case ENUM: {
                EnumType enumeration = new EnumType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, documentation, literals);
                enumeration.setVarName("opc" + displayName + "Type");
                this.addElement(enumeration, type);
                break;
            }
            case DATATYPE: {
                DataType uaDataType = new DataType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, documentation, dataLiterals);
                uaDataType.setVarName("opc" + displayName + "Type");
                this.addElement(uaDataType, type);
                break;
            }
            case OBJECTTYPE: {
                ObjectTypeType uaObjectType = new ObjectTypeType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, documentation);
                uaObjectType.setVarName("opc" + displayName);
                this.addElement(uaObjectType, type);
                break;
            }
            case VARIABLETYPE: {
                VariableTypeType uaVariableType = new VariableTypeType(id, element.getAttribute("BrowseName").replaceAll("[\u201c\u201d\"\\\\]", ""), displayName, description, documentation, this.changeVariableDataTypes(element.getAttribute("DataType")));
                uaVariableType.setVarName("opc" + displayName + "Type");
                this.addElement(uaVariableType, type);
                break;
            }
        }
    }

    private void addElement(BaseType element, ElementType type) {
        if (!this.checkRedundancy(element.getVarName(), null)) {
            this.println(element.toString());
            this.hierarchy.add(element);
        }
    }

    private boolean checkRedundancy(String varName, ArrayList<FieldType> list) {
        boolean duplicateVar = false;
        if (list != null) {
            for (FieldType f : list) {
                if (!f.getVarName().equals(varName)) continue;
                duplicateVar = true;
                break;
            }
        } else {
            for (BaseType o : this.hierarchy) {
                if (!o.getVarName().equals(varName)) continue;
                duplicateVar = true;
                break;
            }
        }
        return duplicateVar;
    }

    private void retrieveElementTypes() {
        int i;
        for (i = 0; i < this.objectTypeList.getLength(); ++i) {
            Element objectType = DomParser.getNextNodeElement(this.objectTypeList, i);
            if (objectType == null) continue;
            this.retrieveAttributes(objectType, null, ElementType.OBJECTTYPE, null);
        }
        for (i = 0; i < this.dataTypeList.getLength(); ++i) {
            Element dataType = DomParser.getNextNodeElement(this.dataTypeList, i);
            if (dataType == null) continue;
            this.retrieveAttributes(dataType, null, ElementType.DATATYPE, null);
        }
    }

    private static String toOsPath(File file) {
        return file.toString();
    }

    private static String toOsPath(String path) {
        return DomParser.toOsPath(new File(path));
    }

    private static File[] checkRequiredModels(DomParser parser, String modelName, String path, String fileName, NodeList nameSpaceUris) {
        Scanner scanner = new Scanner(System.in);
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(0, "UA");
        for (int i = 0; i < nameSpaceUris.getLength(); ++i) {
            Element element = DomParser.getNextNodeElement(nameSpaceUris, i);
            if (element == null) continue;
            NodeList childNodeList = element.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                if (childNode == null || !childNode.getTagName().equals("Uri")) continue;
                uris.add(childNode.getTextContent());
            }
        }
        int nameSpace = 0;
        int ns = 0;
        Iterator iterator = uris.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            if (value.equals(modelName)) {
                nameSpace = ns;
                parser.setBaseNameSpace(Integer.toString(nameSpace));
                iterator.remove();
                break;
            }
            ++ns;
        }
        boolean correct = false;
        File[] models = null;
        File[] files = null;
        ArrayList<File> foundFiles = new ArrayList<File>();
        File f = new File(path, "/RequiredModels");
        do {
            if (!f.exists()) {
                requiredModels = new File(path, "/RequiredModels");
                System.out.println("Directory " + requiredModels.toString() + " is not existing.");
                boolean created = requiredModels.mkdir();
                if (created) {
                    System.out.println("Creating directory.\n");
                } else {
                    System.out.println("Directory " + requiredModels.toString() + " can't be created.\n");
                }
                System.out.println("Please add the following models to " + requiredModels.toString() + ":");
                for (String s : uris) {
                    System.out.println(s);
                }
            } else {
                requiredModels = new File(path, "/RequiredModels");
                files = f.listFiles();
                if (files.length == 0) {
                    System.out.println("The folder RequiredModels is still empty.");
                    System.out.println("Please add the following models to " + requiredModels.toString() + ":");
                    for (String s : uris) {
                        System.out.println(s);
                    }
                } else {
                    Object missingModels = "";
                    boolean modelFound = false;
                    for (String s : uris) {
                        s = StringUtils.removeEnd((String)s.replace("http://opcfoundation.org/UA/", ""), (String)"/").replace("/", ".").toUpperCase();
                        for (int i = 0; i < files.length; ++i) {
                            String model = null;
                            model = DomParser.toOsPath(files[i]).equals(DomParser.toOsPath(path + "/RequiredModels/Opc.Ua.NodeSet2.xml")) ? "UA" : DomParser.toOsPath(files[i]).toUpperCase().replace(DomParser.toOsPath(path.toUpperCase() + "/REQUIREDMODELS/OPC.UA."), "").replace(".NODESET2.XML", "");
                            if (!model.equals(s)) continue;
                            if (model.equals("UA")) {
                                rModel = new File(files[i].toString());
                                foundFiles.add(rModel);
                            } else {
                                rModel = new File(files[i].toString());
                                foundFiles.add(rModel);
                            }
                            modelFound = true;
                            break;
                        }
                        if (!modelFound) {
                            missingModels = (String)missingModels + s + "\n";
                        }
                        modelFound = false;
                    }
                    if (((String)missingModels).isEmpty()) {
                        System.out.println("All required models are available in " + path);
                        models = new File[foundFiles.size()];
                        models = foundFiles.toArray(models);
                        correct = true;
                    } else {
                        System.out.println("The following models are still missing:\n" + (String)missingModels);
                    }
                }
            }
            if (correct) continue;
            boolean confirmed = false;
            do {
                System.out.println("\nPress y to continue if the respective files were added.");
                String input = scanner.nextLine();
                if (!input.equals("y")) continue;
                confirmed = true;
            } while (!confirmed);
        } while (!correct);
        scanner.close();
        return models;
    }

    private void parseFile() {
        String parentNodeId;
        int i;
        for (i = 0; i < this.objectList.getLength(); ++i) {
            Element rootObject;
            Element object = DomParser.getNextNodeElement(this.objectList, i);
            if (object == null || (rootObject = DomParser.checkRelation(parentNodeId = object.getAttribute("ParentNodeId"), this.objectTypeList)) == null) continue;
            this.retrieveRootElement(object, ElementType.ROOTOBJECT);
        }
        for (i = 0; i < this.variableList.getLength(); ++i) {
            Element rootVariable;
            Element variable = DomParser.getNextNodeElement(this.variableList, i);
            if (variable == null || (rootVariable = DomParser.checkRelation(parentNodeId = variable.getAttribute("ParentNodeId"), this.objectTypeList)) == null) continue;
            this.retrieveRootElement(variable, ElementType.ROOTVARIABLE);
        }
        for (i = 0; i < this.methodList.getLength(); ++i) {
            Element rootMethod;
            Element method = DomParser.getNextNodeElement(this.methodList, i);
            if (method == null || (rootMethod = DomParser.checkRelation(parentNodeId = method.getAttribute("ParentNodeId"), this.objectTypeList)) == null) continue;
            this.retrieveRootElement(method, ElementType.ROOTMETHOD);
        }
        if (this.dataTypeList.getLength() > 0 || this.objectTypeList.getLength() > 0) {
            this.retrieveElementTypes();
        }
    }

    private static DomParser createParser(String path, File compSpec, boolean verbose) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DomParser parser = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(compSpec);
            System.out.println("\n" + compSpec.getName());
            NodeList nameSpaceUris = doc.getElementsByTagName("NamespaceUris");
            NodeList objectTypeList = doc.getElementsByTagName("UAObjectType");
            NodeList objectList = doc.getElementsByTagName("UAObject");
            NodeList variableList = doc.getElementsByTagName("UAVariable");
            NodeList methodList = doc.getElementsByTagName("UAMethod");
            NodeList dataTypeList = doc.getElementsByTagName("UADataType");
            NodeList variableTypeList = doc.getElementsByTagName("UAVariableType");
            NodeList aliasList = doc.getElementsByTagName("Aliases");
            NodeList models = doc.getElementsByTagName("Models");
            String modelName = "";
            block2: for (int i = 0; i < models.getLength(); ++i) {
                Element element = DomParser.getNextNodeElement(models, i);
                if (element == null) continue;
                NodeList childNodeList = element.getChildNodes();
                for (int j = 0; j < childNodeList.getLength(); ++j) {
                    Element childNode = DomParser.getNextNodeElement(childNodeList, j);
                    if (childNode == null) continue;
                    modelName = childNode.getAttribute("ModelUri");
                    continue block2;
                }
            }
            ArrayList<BaseType> hierarchy = new ArrayList<BaseType>();
            parser = new DomParser(objectTypeList, objectList, variableList, methodList, dataTypeList, variableTypeList, aliasList, hierarchy);
            File[] reqModels = DomParser.checkRequiredModels(parser, modelName, path, DomParser.toOsPath(compSpec).replace(DomParser.toOsPath(path + "/Opc.Ua."), "").replace(".NodeSet.xml", ""), nameSpaceUris);
            Document[] documents = new Document[reqModels.length];
            ArrayList<NodeList> aliasLists = new ArrayList<NodeList>();
            for (int i = 0; i < reqModels.length; ++i) {
                System.out.println(reqModels[i]);
                documents[i] = builder.parse(reqModels[i]);
                NodeList externAliasList = documents[i].getElementsByTagName("Aliases");
                aliasLists.add(externAliasList);
            }
            parser.setExternAliasLists(aliasLists);
            parser.setDocuments(documents);
            parser.verbose = verbose;
            parser.parseFile();
            Collector.collectInformation(compSpec.getName(), objectTypeList, objectList, variableList, methodList, dataTypeList, variableTypeList, hierarchy, reqModels.length);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.out.println(e.getMessage());
        }
        return parser;
    }

    public static void setUsingIvmlFolder(String folder) {
        usingIvmlFolder = folder;
    }

    private void createIvmlModel(String fileName, File ivmlFile) {
        Generator.generateIVMLModel(fileName, ivmlFile, this.hierarchy);
        Generator.generateVDWConnectorSettings(fileName, this.hierarchy, usingIvmlFolder);
        this.println("FINISHED");
    }

    private void println(String text) {
        if (this.verbose) {
            System.out.println(text);
        }
    }

    public static void process(File xmlIn, String outName, File ivmlOut, boolean verbose) {
        System.out.println("Processing " + String.valueOf(xmlIn) + " to " + outName + "(" + String.valueOf(ivmlOut) + ")");
        String path = xmlIn.getParent();
        DomParser parser = DomParser.createParser(path, xmlIn, verbose);
        parser.createIvmlModel(outName, ivmlOut);
    }

    public static void main(String[] args) {
        File file;
        ArrayList<File> files = new ArrayList<File>();
        if (args.length == 1) {
            file = new File(args[0]);
        } else {
            File baseDir = new File("src/main/resources/NodeSets/");
            files.add(new File(baseDir, "Opc.Ua.Woodworking.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.MachineTool.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Weihenstephan.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Adi.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.AutoID.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.CNC.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.BACnet.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.CAS.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.CommercialKitchenEquipment.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.CSPPlusForMachine.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.DEXPI.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Sercos.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.TMC.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Scheduler.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Scales.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Safety.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.RSL.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Robotics.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Pumps.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.POWERLINK.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.PnRio.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.PnEm.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Pn.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.PLCopen.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.OPENSCS.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Onboarding.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.AMLLibraries.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.AMB.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Fdi5.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Fdi7.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.FDT.NodeSet.xml"));
            files.add(new File(baseDir, "Opc.Ua.fx.ac.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.fx.cm.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.fx.data.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Glass.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.I4AAS.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Ijt.Tightening.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.IOLink.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.IOLinkIODD.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.IRDI.NodeSet2.xml"));
            files.add(new File(baseDir, "opc.ua.isa95-jobcontrol.nodeset2.xml"));
            files.add(new File(baseDir, "Opc.Ua.ISA95.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.MachineVision.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.MDIS.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.MTConnect.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.DevelopmentSupport.Dozer.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.DevelopmentSupport.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.DevelopmentSupport.RoofSupportSystem.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.Extraction.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.Extraction.ShearerLoader.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.Loading.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.Loading.HydraulicExcavator.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.MineralProcessing.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.MineralProcessing.RockCrusher.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.MonitoringSupervisionServices.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.PELOServices.FaceAlignmentSystem.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.PELOServices.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.TransportDumping.ArmouredFaceConveyor.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Mining.TransportDumping.General.NodeSet2.xml"));
            files.add(new File(baseDir, "Opc.Ua.Machinery.NodeSet2.xml"));
        }
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File f;
            file = f = (File)iterator.next();
            String fileName = file.getName();
            fileName = StringUtils.removeStart((String)fileName, (String)"Opc.Ua");
            fileName = StringUtils.removeEnd((String)fileName, (String)".xml");
            fileName = StringUtils.removeEnd((String)fileName, (String)".NodeSet2");
            fileName = fileName.replace(".", "");
            fileName = fileName.replace("-", "_");
            File ivmlFile = new File("target/gen/Opc" + fileName + ".ivml");
            DomParser.process(file, fileName, ivmlFile, verboseDefault);
        }
        Collector.informationToExcel();
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("HasComponent");
        tmp.add("HasOrderedComponent");
        tmp.add("HasProperty");
        tmp.add("FromState");
        tmp.add("ToState");
        IDENTIFY_FIELDS_PERMITTED_REFERENCE_TYPE = Collections.unmodifiableSet(tmp);
    }

    private static class TypeListAndType {
        private NodeList typeList;
        private ElementType type;

        private TypeListAndType() {
        }
    }

    private static class DescriptionOrDocumentation {
        private String reference;
        private String displayName = "";
        private String description = "";
        private String documentation = "";

        private DescriptionOrDocumentation() {
        }
    }
}

